/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.btree.decorator;

import com.almasb.fxgl.ai.btree.Decorator;
import com.almasb.fxgl.ai.btree.Task;
import com.almasb.fxgl.ai.btree.annotation.TaskAttribute;
import com.almasb.fxgl.ai.btree.annotation.TaskConstraint;
import com.almasb.fxgl.ai.utils.random.ConstantFloatDistribution;
import com.almasb.fxgl.ai.utils.random.FloatDistribution;
import com.almasb.fxgl.core.math.FXGLMath;

@TaskConstraint(minChildren=0, maxChildren=1)
public class Random<E>
extends Decorator<E> {
    @TaskAttribute
    public FloatDistribution success;
    private float p;

    public Random() {
        this(ConstantFloatDistribution.ZERO_POINT_FIVE);
    }

    public Random(Task<E> task2) {
        this(ConstantFloatDistribution.ZERO_POINT_FIVE, task2);
    }

    public Random(FloatDistribution success) {
        this.success = success;
    }

    public Random(FloatDistribution success, Task<E> task2) {
        super(task2);
        this.success = success;
    }

    @Override
    public void start() {
        this.p = this.success.nextFloat();
    }

    @Override
    public void run() {
        if (this.child != null) {
            super.run();
        } else {
            this.decide();
        }
    }

    @Override
    public void childFail(Task<E> runningTask) {
        this.decide();
    }

    @Override
    public void childSuccess(Task<E> runningTask) {
        this.decide();
    }

    private void decide() {
        if (FXGLMath.random() <= (double)this.p) {
            this.success();
        } else {
            this.fail();
        }
    }

    @Override
    protected Task<E> copyTo(Task<E> task2) {
        Random random = (Random)task2;
        random.success = this.success;
        return super.copyTo(task2);
    }
}

