/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.btree.decorator;

import com.almasb.fxgl.ai.btree.Decorator;
import com.almasb.fxgl.ai.btree.Task;
import com.almasb.fxgl.ai.btree.annotation.TaskAttribute;
import com.almasb.fxgl.ai.utils.NonBlockingSemaphore;
import com.almasb.fxgl.ai.utils.NonBlockingSemaphoreRepository;

public class SemaphoreGuard<E>
extends Decorator<E> {
    @TaskAttribute(required=true)
    public String name;
    private transient NonBlockingSemaphore semaphore;
    private boolean semaphoreAcquired;

    public SemaphoreGuard() {
    }

    public SemaphoreGuard(Task<E> task2) {
        super(task2);
    }

    public SemaphoreGuard(String name) {
        this.name = name;
    }

    public SemaphoreGuard(String name, Task<E> task2) {
        super(task2);
        this.name = name;
    }

    @Override
    public void start() {
        if (this.semaphore == null) {
            this.semaphore = NonBlockingSemaphoreRepository.getSemaphore(this.name);
        }
        this.semaphoreAcquired = this.semaphore.acquire();
        super.start();
    }

    @Override
    public void run() {
        if (this.semaphoreAcquired) {
            super.run();
        } else {
            this.fail();
        }
    }

    @Override
    public void end() {
        if (this.semaphoreAcquired) {
            if (this.semaphore == null) {
                this.semaphore = NonBlockingSemaphoreRepository.getSemaphore(this.name);
            }
            this.semaphore.release();
            this.semaphoreAcquired = false;
        }
        super.end();
    }

    @Override
    public void reset() {
        super.reset();
        this.semaphore = null;
        this.semaphoreAcquired = false;
    }

    @Override
    protected Task<E> copyTo(Task<E> task2) {
        SemaphoreGuard semaphoreGuard = (SemaphoreGuard)task2;
        semaphoreGuard.name = this.name;
        semaphoreGuard.semaphore = null;
        semaphoreGuard.semaphoreAcquired = false;
        return super.copyTo(task2);
    }
}

