/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppStateMachine;
import com.almasb.fxgl.app.ExceptionHandler;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.FXGLExecutor;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.Gameplay;
import com.almasb.fxgl.gameplay.notification.NotificationServiceProvider;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.net.FXGLNet;
import com.almasb.fxgl.scene.menu.MenuSettings;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.time.LocalTimer;
import com.almasb.fxgl.time.OfflineTimer;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.FXGLDisplay;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.fxgl.util.Version;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/almasb/fxgl/app/FXGL;", "", "()V", "Companion", "fxgl"})
public final class FXGL {
    private static GameApplication internalApp;
    private static Bundle internalBundle;
    private static final Logger log;
    private static boolean configured;
    private static final MenuSettings _menuSettings;
    private static final Lazy _gameConfig$delegate;
    private static boolean firstRun;
    private static final Lazy _notificationService$delegate;
    private static final Lazy _assetLoader$delegate;
    private static final Lazy _eventBus$delegate;
    private static final Lazy _audioPlayer$delegate;
    private static final Lazy _display$delegate;
    private static final Lazy _executor$delegate;
    private static final Lazy _net$delegate;
    private static final Lazy _gameplay$delegate;
    private static final Lazy _input$delegate;
    private static final Lazy _masterTimer$delegate;
    public static final Companion Companion;

    private FXGL() {
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("FXGL");
        _menuSettings = new MenuSettings();
        _gameConfig$delegate = LazyKt.lazy((Function0)Companion._gameConfig.2.INSTANCE);
        _notificationService$delegate = LazyKt.lazy((Function0)Companion._notificationService.2.INSTANCE);
        _assetLoader$delegate = LazyKt.lazy((Function0)Companion._assetLoader.2.INSTANCE);
        _eventBus$delegate = LazyKt.lazy((Function0)Companion._eventBus.2.INSTANCE);
        _audioPlayer$delegate = LazyKt.lazy((Function0)Companion._audioPlayer.2.INSTANCE);
        _display$delegate = LazyKt.lazy((Function0)Companion._display.2.INSTANCE);
        _executor$delegate = LazyKt.lazy((Function0)Companion._executor.2.INSTANCE);
        _net$delegate = LazyKt.lazy((Function0)Companion._net.2.INSTANCE);
        _gameplay$delegate = LazyKt.lazy((Function0)Companion._gameplay.2.INSTANCE);
        _input$delegate = LazyKt.lazy((Function0)Companion._input.2.INSTANCE);
        _masterTimer$delegate = LazyKt.lazy((Function0)Companion._masterTimer.2.INSTANCE);
    }

    @NotNull
    public static final /* synthetic */ GameApplication access$getInternalApp$cp() {
        GameApplication gameApplication = internalApp;
        if (gameApplication == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalApp");
        }
        return gameApplication;
    }

    @NotNull
    public static final /* synthetic */ Bundle access$getInternalBundle$cp() {
        Bundle bundle = internalBundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalBundle");
        }
        return bundle;
    }

    @JvmStatic
    public static final ReadOnlyGameSettings getSettings() {
        return Companion.getSettings();
    }

    @JvmStatic
    @NotNull
    public static final MenuSettings getMenuSettings() {
        return Companion.getMenuSettings();
    }

    @JvmStatic
    public static final <T> T getGameConfig() {
        return Companion.getGameConfig();
    }

    @JvmStatic
    @NotNull
    public static final GameApplication getApp() {
        return Companion.getApp();
    }

    @JvmStatic
    public static final int getAppWidth() {
        return Companion.getAppWidth();
    }

    @JvmStatic
    public static final int getAppHeight() {
        return Companion.getAppHeight();
    }

    @JvmStatic
    @NotNull
    public static final <T extends GameApplication> T getAppCast() {
        return Companion.getAppCast();
    }

    @JvmStatic
    @NotNull
    public static final Bundle getSystemBundle() {
        return Companion.getSystemBundle();
    }

    @JvmStatic
    public static final void configure(@NotNull GameApplication app) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
        Companion.configure(app);
    }

    @JvmStatic
    public static final boolean isFirstRun() {
        return Companion.isFirstRun();
    }

    @JvmStatic
    protected static final void destroy() {
        Companion.destroy();
    }

    @JvmStatic
    public static final ExceptionHandler getExceptionHandler() {
        return Companion.getExceptionHandler();
    }

    @JvmStatic
    public static final UIFactory getUIFactory() {
        return Companion.getUIFactory();
    }

    @JvmStatic
    @NotNull
    public static final NotificationServiceProvider getNotificationService() {
        return Companion.getNotificationService();
    }

    @JvmStatic
    @NotNull
    public static final AssetLoader getAssetLoader() {
        return Companion.getAssetLoader();
    }

    @JvmStatic
    @NotNull
    public static final EventBus getEventBus() {
        return Companion.getEventBus();
    }

    @JvmStatic
    @NotNull
    public static final AudioPlayer getAudioPlayer() {
        return Companion.getAudioPlayer();
    }

    @JvmStatic
    @NotNull
    public static final FXGLDisplay getDisplay() {
        return Companion.getDisplay();
    }

    @JvmStatic
    @NotNull
    public static final FXGLExecutor getExecutor() {
        return Companion.getExecutor();
    }

    @JvmStatic
    @NotNull
    public static final FXGLNet getNet() {
        return Companion.getNet();
    }

    @JvmStatic
    @NotNull
    public static final Gameplay getGameplay() {
        return Companion.getGameplay();
    }

    @JvmStatic
    public static final Input getInput() {
        return Companion.getInput();
    }

    @JvmStatic
    @NotNull
    public static final LocalTimer newLocalTimer() {
        return Companion.newLocalTimer();
    }

    @JvmStatic
    @NotNull
    public static final LocalTimer newOfflineTimer(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Companion.newOfflineTimer(name);
    }

    @JvmStatic
    public static final Timer getMasterTimer() {
        return Companion.getMasterTimer();
    }

    @JvmStatic
    public static final int getInt(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getInt(key);
    }

    @JvmStatic
    public static final double getDouble(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getDouble(key);
    }

    @JvmStatic
    public static final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getBoolean(key);
    }

    @JvmStatic
    @NotNull
    public static final String getString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getString(key);
    }

    @JvmStatic
    public static final void setProperty(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Companion.setProperty(key, value);
    }

    @JvmStatic
    @NotNull
    public static final String getLocalizedString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.getLocalizedString(key);
    }

    @JvmStatic
    @NotNull
    public static final StringBinding localizedStringProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.localizedStringProperty(key);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020IH\u0007J\b\u0010[\u001a\u00020YH\u0002J\b\u0010\\\u001a\u00020YH\u0005J\b\u0010]\u001a\u00020IH\u0007J\u0017\u0010^\u001a\u0002H_\"\b\b\u0000\u0010_*\u00020IH\u0007\u00a2\u0006\u0002\u0010KJ\b\u0010`\u001a\u00020aH\u0007J\b\u0010b\u001a\u00020aH\u0007J\b\u0010c\u001a\u00020\u0004H\u0007J\b\u0010d\u001a\u00020\nH\u0007J\u0010\u0010e\u001a\u00020@2\u0006\u0010f\u001a\u00020gH\u0007J\b\u0010h\u001a\u00020\u000fH\u0007J\u0010\u0010i\u001a\u00020j2\u0006\u0010f\u001a\u00020gH\u0007J\b\u0010k\u001a\u00020\u0014H\u0007J\u0010\u0010l\u001a\n (*\u0004\u0018\u00010m0mH\u0007J\b\u0010n\u001a\u00020\u0019H\u0007J\u0013\u0010o\u001a\u0002H_\"\u0004\b\u0000\u0010_H\u0007\u00a2\u0006\u0002\u0010\u001fJ\b\u0010p\u001a\u00020\"H\u0007J\u0010\u0010q\u001a\n (*\u0004\u0018\u00010'0'H\u0007J\u0010\u0010r\u001a\u00020a2\u0006\u0010f\u001a\u00020gH\u0007J\u0010\u0010s\u001a\u00020g2\u0006\u0010f\u001a\u00020gH\u0007J\u0010\u0010t\u001a\n (*\u0004\u0018\u00010-0-H\u0007J\b\u0010u\u001a\u000202H\u0007J\b\u0010v\u001a\u000206H\u0007J\b\u0010w\u001a\u00020;H\u0007J\u0010\u0010x\u001a\u00020g2\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010y\u001a\n (*\u0004\u0018\u00010z0zH\u0007J\u0010\u0010{\u001a\u00020g2\u0006\u0010f\u001a\u00020gH\u0007J\b\u0010|\u001a\u00020OH\u0007J\u0010\u0010}\u001a\n (*\u0004\u0018\u00010~0~H\u0007J\b\u0010\u007f\u001a\u00020@H\u0007J\t\u0010\u0080\u0001\u001a\u00020YH\u0002J\u0013\u0010\u0081\u0001\u001a\u00020Y2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\t\u0010\u0084\u0001\u001a\u00020YH\u0002J\t\u0010\u0085\u0001\u001a\u00020YH\u0002J\t\u0010\u0086\u0001\u001a\u00020YH\u0002J\u0012\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0006\u0010f\u001a\u00020gH\u0007J\n\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0007J\u0013\u0010\u008b\u0001\u001a\u00030\u008a\u00012\u0007\u0010\u008c\u0001\u001a\u00020gH\u0007J\t\u0010\u008d\u0001\u001a\u00020YH\u0002J\t\u0010\u008e\u0001\u001a\u00020YH\u0002J\u001a\u0010\u008f\u0001\u001a\u00020Y2\u0006\u0010f\u001a\u00020g2\u0007\u0010\u0090\u0001\u001a\u00020\u0001H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\b\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\b\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\b\u001a\u0004\b#\u0010$R#\u0010&\u001a\n (*\u0004\u0018\u00010'0'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\b\u001a\u0004\b)\u0010*R#\u0010,\u001a\n (*\u0004\u0018\u00010-0-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\b\u001a\u0004\b.\u0010/R\u0014\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001b\u00105\u001a\u0002068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\b\u001a\u0004\b7\u00108R\u001b\u0010:\u001a\u00020;8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\b\u001a\u0004\b<\u0010=R\u001a\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020@X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR\u001a\u0010H\u001a\u00020IX\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001a\u0010N\u001a\u00020OX\u0082.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u0014\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010W\u00a8\u0006\u0091\u0001"}, d2={"Lcom/almasb/fxgl/app/FXGL$Companion;", "", "()V", "_assetLoader", "Lcom/almasb/fxgl/asset/AssetLoader;", "get_assetLoader", "()Lcom/almasb/fxgl/asset/AssetLoader;", "_assetLoader$delegate", "Lkotlin/Lazy;", "_audioPlayer", "Lcom/almasb/fxgl/audio/AudioPlayer;", "get_audioPlayer", "()Lcom/almasb/fxgl/audio/AudioPlayer;", "_audioPlayer$delegate", "_display", "Lcom/almasb/fxgl/ui/FXGLDisplay;", "get_display", "()Lcom/almasb/fxgl/ui/FXGLDisplay;", "_display$delegate", "_eventBus", "Lcom/almasb/fxgl/event/EventBus;", "get_eventBus", "()Lcom/almasb/fxgl/event/EventBus;", "_eventBus$delegate", "_executor", "Lcom/almasb/fxgl/app/FXGLExecutor;", "get_executor", "()Lcom/almasb/fxgl/app/FXGLExecutor;", "_executor$delegate", "_gameConfig", "get_gameConfig", "()Ljava/lang/Object;", "_gameConfig$delegate", "_gameplay", "Lcom/almasb/fxgl/gameplay/Gameplay;", "get_gameplay", "()Lcom/almasb/fxgl/gameplay/Gameplay;", "_gameplay$delegate", "_input", "Lcom/almasb/fxgl/input/Input;", "kotlin.jvm.PlatformType", "get_input", "()Lcom/almasb/fxgl/input/Input;", "_input$delegate", "_masterTimer", "Lcom/almasb/fxgl/time/Timer;", "get_masterTimer", "()Lcom/almasb/fxgl/time/Timer;", "_masterTimer$delegate", "_menuSettings", "Lcom/almasb/fxgl/scene/menu/MenuSettings;", "get_menuSettings", "()Lcom/almasb/fxgl/scene/menu/MenuSettings;", "_net", "Lcom/almasb/fxgl/net/FXGLNet;", "get_net", "()Lcom/almasb/fxgl/net/FXGLNet;", "_net$delegate", "_notificationService", "Lcom/almasb/fxgl/gameplay/notification/NotificationServiceProvider;", "get_notificationService", "()Lcom/almasb/fxgl/gameplay/notification/NotificationServiceProvider;", "_notificationService$delegate", "configured", "", "getConfigured", "()Z", "setConfigured", "(Z)V", "firstRun", "getFirstRun", "setFirstRun", "internalApp", "Lcom/almasb/fxgl/app/GameApplication;", "getInternalApp", "()Lcom/almasb/fxgl/app/GameApplication;", "setInternalApp", "(Lcom/almasb/fxgl/app/GameApplication;)V", "internalBundle", "Lcom/almasb/fxgl/io/serialization/Bundle;", "getInternalBundle", "()Lcom/almasb/fxgl/io/serialization/Bundle;", "setInternalBundle", "(Lcom/almasb/fxgl/io/serialization/Bundle;)V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getLog", "()Lcom/almasb/fxgl/core/logging/Logger;", "configure", "", "app", "createRequiredDirs", "destroy", "getApp", "getAppCast", "T", "getAppHeight", "", "getAppWidth", "getAssetLoader", "getAudioPlayer", "getBoolean", "key", "", "getDisplay", "getDouble", "", "getEventBus", "getExceptionHandler", "Lcom/almasb/fxgl/app/ExceptionHandler;", "getExecutor", "getGameConfig", "getGameplay", "getInput", "getInt", "getLocalizedString", "getMasterTimer", "getMenuSettings", "getNet", "getNotificationService", "getProperty", "getSettings", "Lcom/almasb/fxgl/settings/ReadOnlyGameSettings;", "getString", "getSystemBundle", "getUIFactory", "Lcom/almasb/fxgl/ui/UIFactory;", "isFirstRun", "loadDefaultSystemData", "loadProperties", "props", "Ljava/util/ResourceBundle;", "loadSystemData", "loadSystemProperties", "loadUserProperties", "localizedStringProperty", "Ljavafx/beans/binding/StringBinding;", "newLocalTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "newOfflineTimer", "name", "runUpdaterAndWait", "saveSystemData", "setProperty", "value", "fxgl"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_gameConfig", "get_gameConfig()Ljava/lang/Object;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_notificationService", "get_notificationService()Lcom/almasb/fxgl/gameplay/notification/NotificationServiceProvider;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_assetLoader", "get_assetLoader()Lcom/almasb/fxgl/asset/AssetLoader;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_eventBus", "get_eventBus()Lcom/almasb/fxgl/event/EventBus;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_audioPlayer", "get_audioPlayer()Lcom/almasb/fxgl/audio/AudioPlayer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_display", "get_display()Lcom/almasb/fxgl/ui/FXGLDisplay;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_executor", "get_executor()Lcom/almasb/fxgl/app/FXGLExecutor;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_net", "get_net()Lcom/almasb/fxgl/net/FXGLNet;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_gameplay", "get_gameplay()Lcom/almasb/fxgl/gameplay/Gameplay;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_input", "get_input()Lcom/almasb/fxgl/input/Input;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "_masterTimer", "get_masterTimer()Lcom/almasb/fxgl/time/Timer;"))};
        }

        private final GameApplication getInternalApp() {
            return FXGL.access$getInternalApp$cp();
        }

        private final void setInternalApp(GameApplication gameApplication) {
            internalApp = gameApplication;
        }

        private final Bundle getInternalBundle() {
            return FXGL.access$getInternalBundle$cp();
        }

        private final void setInternalBundle(Bundle bundle) {
            internalBundle = bundle;
        }

        private final Logger getLog() {
            return log;
        }

        private final boolean getConfigured() {
            return configured;
        }

        private final void setConfigured(boolean bl) {
            configured = bl;
        }

        @JvmStatic
        public final ReadOnlyGameSettings getSettings() {
            return this.getInternalApp().getSettings();
        }

        private final MenuSettings get_menuSettings() {
            return _menuSettings;
        }

        @JvmStatic
        @NotNull
        public final MenuSettings getMenuSettings() {
            return this.get_menuSettings();
        }

        private final Object get_gameConfig() {
            Lazy lazy = _gameConfig$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return lazy.getValue();
        }

        @JvmStatic
        public final <T> T getGameConfig() {
            return (T)this.get_gameConfig();
        }

        @JvmStatic
        @NotNull
        public final GameApplication getApp() {
            return this.getInternalApp();
        }

        @JvmStatic
        public final int getAppWidth() {
            return this.getInternalApp().getWidth();
        }

        @JvmStatic
        public final int getAppHeight() {
            return this.getInternalApp().getHeight();
        }

        @JvmStatic
        @NotNull
        public final <T extends GameApplication> T getAppCast() {
            GameApplication gameApplication = this.getInternalApp();
            if (gameApplication == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)((Object)gameApplication);
        }

        @JvmStatic
        @NotNull
        public final Bundle getSystemBundle() {
            return this.getInternalBundle();
        }

        @JvmStatic
        public final void configure(@NotNull GameApplication app) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)app), (String)"app");
            if (this.getConfigured()) {
                return;
            }
            this.setConfigured(true);
            Version.print();
            this.setInternalApp(app);
            this.loadSystemProperties();
            this.loadUserProperties();
            this.createRequiredDirs();
            if (this.getFirstRun()) {
                this.loadDefaultSystemData();
            } else {
                this.loadSystemData();
            }
            this.runUpdaterAndWait();
        }

        private final void loadSystemProperties() {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.almasb.fxgl.app.system");
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle, (String)"ResourceBundle.getBundle\u2026.almasb.fxgl.app.system\")");
            this.loadProperties(resourceBundle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadUserProperties() {
            try {
                Closeable closeable = FXGL.class.getResource("/assets/properties/system.properties").openStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    Companion.loadProperties(new PropertyResourceBundle(it));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IOException e) {
                this.getLog().warning("Loading user properties failed: " + e);
            }
        }

        private final void loadProperties(ResourceBundle props) {
            Set<String> set = props.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"props.keySet()");
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                String key = (String)element$iv;
                Object value = props.getObject(key);
                String string = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                Object object = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"value");
                Companion.setProperty(string, object);
            }
        }

        private final boolean getFirstRun() {
            return firstRun;
        }

        private final void setFirstRun(boolean bl) {
            firstRun = bl;
        }

        @JvmStatic
        public final boolean isFirstRun() {
            return this.getFirstRun();
        }

        private final void createRequiredDirs() {
            Path systemDir = Paths.get("system/", new String[0]);
            if (!Files.exists(systemDir, new LinkOption[0])) {
                this.setFirstRun(true);
                Files.createDirectories(systemDir, new FileAttribute[0]);
                Path readmeFile = Paths.get("system/Readme.txt", new String[0]);
                Files.write(readmeFile, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)"This directory contains FXGL system data files."), new OpenOption[0]);
            }
        }

        private final void saveSystemData() {
            this.getLog().debug("Saving FXGL system data");
            FS.Companion.writeDataTask(this.getInternalBundle(), "system/fxgl.bundle").onFailure(saveSystemData.1.INSTANCE).execute();
        }

        private final void loadSystemData() {
            this.getLog().debug("Loading FXGL system data");
            FS.Companion.readDataTask("system/fxgl.bundle").onSuccess(loadSystemData.1.INSTANCE).onFailure(loadSystemData.2.INSTANCE).execute();
        }

        private final void loadDefaultSystemData() {
            this.getLog().debug("Loading default FXGL system data");
            this.setInternalBundle(new Bundle("FXGL"));
        }

        private final void runUpdaterAndWait() {
            Async.startFX(runUpdaterAndWait.1.INSTANCE).await();
        }

        @JvmStatic
        protected final void destroy() {
            if (!this.getConfigured()) {
                throw (Throwable)new IllegalStateException("FXGL has not been configured");
            }
            this.saveSystemData();
        }

        @JvmStatic
        public final ExceptionHandler getExceptionHandler() {
            ReadOnlyGameSettings readOnlyGameSettings = this.getSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyGameSettings, (String)"getSettings()");
            return readOnlyGameSettings.getExceptionHandler();
        }

        @JvmStatic
        public final UIFactory getUIFactory() {
            ReadOnlyGameSettings readOnlyGameSettings = this.getSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyGameSettings, (String)"getSettings()");
            return readOnlyGameSettings.getUIFactory();
        }

        private final NotificationServiceProvider get_notificationService() {
            Lazy lazy = _notificationService$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[1];
            return (NotificationServiceProvider)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final NotificationServiceProvider getNotificationService() {
            return this.get_notificationService();
        }

        private final AssetLoader get_assetLoader() {
            Lazy lazy = _assetLoader$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[2];
            return (AssetLoader)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final AssetLoader getAssetLoader() {
            return this.get_assetLoader();
        }

        private final EventBus get_eventBus() {
            Lazy lazy = _eventBus$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[3];
            return (EventBus)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final EventBus getEventBus() {
            return this.get_eventBus();
        }

        private final AudioPlayer get_audioPlayer() {
            Lazy lazy = _audioPlayer$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[4];
            return (AudioPlayer)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final AudioPlayer getAudioPlayer() {
            return this.get_audioPlayer();
        }

        private final FXGLDisplay get_display() {
            Lazy lazy = _display$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[5];
            return (FXGLDisplay)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLDisplay getDisplay() {
            return this.get_display();
        }

        private final FXGLExecutor get_executor() {
            Lazy lazy = _executor$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[6];
            return (FXGLExecutor)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLExecutor getExecutor() {
            return this.get_executor();
        }

        private final FXGLNet get_net() {
            Lazy lazy = _net$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[7];
            return (FXGLNet)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final FXGLNet getNet() {
            return this.get_net();
        }

        private final Gameplay get_gameplay() {
            Lazy lazy = _gameplay$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[8];
            return (Gameplay)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Gameplay getGameplay() {
            return this.get_gameplay();
        }

        private final Input get_input() {
            Lazy lazy = _input$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[9];
            return (Input)lazy.getValue();
        }

        @JvmStatic
        public final Input getInput() {
            return this.get_input();
        }

        @JvmStatic
        @NotNull
        public final LocalTimer newLocalTimer() {
            AppStateMachine appStateMachine = this.getInternalApp().getStateMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)appStateMachine, (String)"internalApp.stateMachine");
            State state = appStateMachine.getPlayState();
            Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"internalApp.stateMachine.playState");
            return state.getTimer().newLocalTimer();
        }

        @JvmStatic
        @NotNull
        public final LocalTimer newOfflineTimer(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new OfflineTimer(name);
        }

        private final Timer get_masterTimer() {
            Lazy lazy = _masterTimer$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[10];
            return (Timer)lazy.getValue();
        }

        @JvmStatic
        public final Timer getMasterTimer() {
            return this.get_masterTimer();
        }

        @JvmStatic
        public final int getInt(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Integer.parseInt(this.getProperty(key));
        }

        @JvmStatic
        public final double getDouble(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Double.parseDouble(this.getProperty(key));
        }

        @JvmStatic
        public final boolean getBoolean(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return Boolean.parseBoolean(this.getProperty(key));
        }

        @JvmStatic
        @NotNull
        public final String getString(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return this.getProperty(key);
        }

        private final String getProperty(String key) {
            String string = System.getProperty("FXGL." + key);
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Key \"" + key + "\" not found!");
            }
            return string;
        }

        @JvmStatic
        public final void setProperty(@NotNull String key, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            System.setProperty("FXGL." + key, value.toString());
        }

        @JvmStatic
        @NotNull
        public final String getLocalizedString(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            String langName = this.get_menuSettings().getLanguage().resourceBundleName();
            ResourceBundle bundle = this.getAssetLoader().loadResourceBundle("languages/" + langName + ".properties");
            String string = bundle.getString(key);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle.getString(key)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final StringBinding localizedStringProperty(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            StringBinding stringBinding = Bindings.createStringBinding((Callable)new Callable<String>(key){
                final /* synthetic */ String $key;

                @NotNull
                public final String call() {
                    return FXGL.Companion.getLocalizedString(this.$key);
                }
                {
                    this.$key = string;
                }
            }, (Observable[])new Observable[]{(Observable)this.get_menuSettings().languageProperty()});
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBinding, (String)"Bindings.createStringBin\u2026tings.languageProperty())");
            return stringBinding;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLog$p(Companion $this) {
            return $this.getLog();
        }

        @NotNull
        public static final /* synthetic */ Bundle access$getInternalBundle$p(Companion $this) {
            return $this.getInternalBundle();
        }

        public static final /* synthetic */ void access$setInternalBundle$p(Companion $this, @NotNull Bundle bundle) {
            $this.setInternalBundle(bundle);
        }

        public static final /* synthetic */ void access$loadDefaultSystemData(Companion $this) {
            $this.loadDefaultSystemData();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @NotNull
        public static final /* synthetic */ GameApplication access$getInternalApp$p(Companion $this) {
            return $this.getInternalApp();
        }

        public static final /* synthetic */ void access$setInternalApp$p(Companion $this, @NotNull GameApplication gameApplication) {
            $this.setInternalApp(gameApplication);
        }
    }
}

