/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.DeveloperMenuBarController;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.settings.ReadOnlyGameSettings;
import com.almasb.fxgl.ui.UI;
import javafx.scene.input.KeyCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003*\u0003\b\u000b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\r\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ\r\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/app/SystemActions;", "", "()V", "bind", "", "input", "Lcom/almasb/fxgl/input/Input;", "devOptions", "com/almasb/fxgl/app/SystemActions$devOptions$1", "()Lcom/almasb/fxgl/app/SystemActions$devOptions$1;", "restartGame", "com/almasb/fxgl/app/SystemActions$restartGame$1", "()Lcom/almasb/fxgl/app/SystemActions$restartGame$1;", "screenshot", "com/almasb/fxgl/app/SystemActions$screenshot$1", "()Lcom/almasb/fxgl/app/SystemActions$screenshot$1;", "fxgl"})
public final class SystemActions {
    public static final SystemActions INSTANCE;

    public final void bind(@NotNull Input input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Input.addAction$default(input, (UserAction)this.screenshot(), KeyCode.P, null, 4, null);
        input.addAction((UserAction)this.devOptions(), KeyCode.DIGIT0, InputModifier.CTRL);
        input.addAction((UserAction)this.restartGame(), KeyCode.R, InputModifier.CTRL);
    }

    private final screenshot.1 screenshot() {
        return new UserAction("Screenshot"){

            protected void onActionBegin() {
                boolean ok = FXGL.Companion.getApp().saveScreenshot();
                FXGL.Companion.getNotificationService().pushNotification(ok ? "Screenshot saved" : "Screenshot failed");
            }
        };
    }

    private final devOptions.1 devOptions() {
        return new UserAction("Dev Options"){
            private boolean devBarOpen;
            private UI devUI;

            protected void onActionBegin() {
                ReadOnlyGameSettings readOnlyGameSettings = FXGL.Companion.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyGameSettings, (String)"FXGL.getSettings()");
                if (Intrinsics.areEqual((Object)((Object)readOnlyGameSettings.getApplicationMode()), (Object)((Object)ApplicationMode.RELEASE))) {
                    return;
                }
                if (this.devUI == null) {
                    this.devUI = FXGL.Companion.getAssetLoader().loadUI("dev_menu_bar.fxml", new DeveloperMenuBarController());
                }
                if (this.devBarOpen) {
                    FXGL.Companion.getApp().getGameScene().removeUI(this.devUI);
                    this.devBarOpen = false;
                } else {
                    FXGL.Companion.getApp().getGameScene().addUI(this.devUI);
                    this.devBarOpen = true;
                }
            }
        };
    }

    private final restartGame.1 restartGame() {
        return new UserAction("Restart"){

            protected void onActionBegin() {
                FXGL.Companion.getApp().startNewGame();
            }
        };
    }

    private SystemActions() {
    }

    static {
        SystemActions systemActions;
        INSTANCE = systemActions = new SystemActions();
    }
}

