/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.asset.FXGLAssets;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.gameplay.notification.NotificationEvent;
import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.saving.UserProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0019J&\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000eJ&\u0010$\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0019J\u0006\u0010+\u001a\u00020\u0014J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u000eJ\u000e\u00100\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u000eJ\u0006\u00101\u001a\u00020\u0014J\u0006\u00102\u001a\u00020\u0014J\u000e\u00103\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/almasb/fxgl/audio/AudioPlayer;", "", "()V", "activeMusic", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/audio/Music;", "activeSounds", "Lcom/almasb/fxgl/audio/Sound;", "globalMusicVolume", "Ljavafx/beans/property/SimpleDoubleProperty;", "globalSoundVolume", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "getGlobalMusicVolume", "", "getGlobalSoundVolume", "globalMusicVolumeProperty", "Ljavafx/beans/property/DoubleProperty;", "globalSoundVolumeProperty", "load", "", "profile", "Lcom/almasb/fxgl/saving/UserProfile;", "loopBGM", "bgmName", "", "onNotificationEvent", "event", "Lcom/almasb/fxgl/gameplay/notification/NotificationEvent;", "onUpdate", "tpf", "pauseAllMusic", "pauseMusic", "music", "playMusic", "assetName", "playPositionalSound", "sound", "soundPosition", "Ljavafx/geometry/Point2D;", "earPosition", "maxDistance", "playSound", "resumeAllMusic", "resumeMusic", "save", "setGlobalMusicVolume", "volume", "setGlobalSoundVolume", "stopAllMusic", "stopAllSounds", "stopMusic", "stopSound", "fxgl"})
public final class AudioPlayer {
    private final Logger log = Logger.Companion.get(this.getClass());
    private final ArrayList<Sound> activeSounds = new ArrayList();
    private final ArrayList<Music> activeMusic = new ArrayList();
    private final SimpleDoubleProperty globalMusicVolume = new SimpleDoubleProperty(0.5);
    private final SimpleDoubleProperty globalSoundVolume = new SimpleDoubleProperty(0.5);

    /*
     * WARNING - void declaration
     */
    public final void onUpdate(double tpf) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.activeMusic;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Music it = (Music)element$iv$iv;
            if (!it.reachedEnd$fxgl()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            this.log.debug("Stopping music: " + it);
            it.stop$fxgl();
        }
        this.activeSounds.removeIf(onUpdate.3.INSTANCE);
        this.activeMusic.removeIf(onUpdate.4.INSTANCE);
    }

    @NotNull
    public final DoubleProperty globalMusicVolumeProperty() {
        return (DoubleProperty)this.globalMusicVolume;
    }

    @NotNull
    public final DoubleProperty globalSoundVolumeProperty() {
        return (DoubleProperty)this.globalSoundVolume;
    }

    public final void onNotificationEvent(@NotNull NotificationEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event), (String)"event");
        this.playSound(FXGLAssets.SOUND_NOTIFICATION);
    }

    public final double getGlobalMusicVolume() {
        return this.globalMusicVolumeProperty().get();
    }

    public final void setGlobalMusicVolume(double volume) {
        this.globalMusicVolumeProperty().set(volume);
    }

    public final double getGlobalSoundVolume() {
        return this.globalSoundVolumeProperty().get();
    }

    public final void setGlobalSoundVolume(double volume) {
        this.globalSoundVolumeProperty().set(volume);
    }

    public final void playSound(@NotNull String assetName) {
        Intrinsics.checkParameterIsNotNull((Object)assetName, (String)"assetName");
        this.playSound(FXGL.Companion.getAssetLoader().loadSound(assetName));
    }

    public final void playPositionalSound(@NotNull String assetName, @NotNull Point2D soundPosition, @NotNull Point2D earPosition, double maxDistance) {
        Intrinsics.checkParameterIsNotNull((Object)assetName, (String)"assetName");
        Intrinsics.checkParameterIsNotNull((Object)soundPosition, (String)"soundPosition");
        Intrinsics.checkParameterIsNotNull((Object)earPosition, (String)"earPosition");
        this.playPositionalSound(FXGL.Companion.getAssetLoader().loadSound(assetName), soundPosition, earPosition, maxDistance);
    }

    public final void playSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        if (!this.activeSounds.contains(sound)) {
            this.activeSounds.add(sound);
        }
        sound.getClip$fxgl().volumeProperty().bind((ObservableValue)this.globalSoundVolumeProperty());
        sound.getClip$fxgl().play();
    }

    public final void playPositionalSound(@NotNull Sound sound, @NotNull Point2D soundPosition, @NotNull Point2D earPosition, double maxDistance) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        Intrinsics.checkParameterIsNotNull((Object)soundPosition, (String)"soundPosition");
        Intrinsics.checkParameterIsNotNull((Object)earPosition, (String)"earPosition");
        double rawBalance = earPosition.distance(soundPosition) / maxDistance;
        sound.setBalance(soundPosition.getX() > earPosition.getX() ? rawBalance : -rawBalance);
        this.playSound(sound);
    }

    public final void stopSound(@NotNull Sound sound) {
        Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
        this.activeSounds.remove(sound);
        sound.getClip$fxgl().stop();
    }

    public final void stopAllSounds() {
        this.log.debug("Stopping all sounds");
        Iterator<Sound> it = this.activeSounds.iterator();
        while (it.hasNext()) {
            it.next().getClip$fxgl().stop();
            it.remove();
        }
    }

    @NotNull
    public final Music loopBGM(@NotNull String bgmName) {
        Intrinsics.checkParameterIsNotNull((Object)bgmName, (String)"bgmName");
        Music music = FXGL.Companion.getAssetLoader().loadMusic(bgmName);
        music.setCycleCount(Integer.MAX_VALUE);
        this.playMusic(music);
        return music;
    }

    public final void playMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Playing music " + music);
        if (this.activeMusic.contains(music)) {
            throw (Throwable)new IllegalArgumentException("Attempted to play " + music + ", which is already playing / paused");
        }
        this.activeMusic.add(music);
        music.bindVolume$fxgl((DoubleProperty)this.globalMusicVolume);
        music.start$fxgl();
    }

    public final void playMusic(@NotNull String assetName) {
        Intrinsics.checkParameterIsNotNull((Object)assetName, (String)"assetName");
        this.playMusic(FXGL.Companion.getAssetLoader().loadMusic(assetName));
    }

    public final void pauseMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Pausing music " + music);
        if (this.activeMusic.contains(music)) {
            music.pause$fxgl();
        } else {
            this.log.warning("Attempted to pause " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    public final void resumeMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Resuming music " + music);
        if (this.activeMusic.contains(music)) {
            music.resume$fxgl();
        } else {
            this.log.warning("Attempted to resume " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    public final void stopMusic(@NotNull Music music) {
        Intrinsics.checkParameterIsNotNull((Object)music, (String)"music");
        this.log.debug("Stopping music " + music);
        if (this.activeMusic.contains(music)) {
            music.stop$fxgl();
            this.activeMusic.remove(music);
        } else {
            this.log.warning("Attempted to stop " + music + " that is not managed by audio player. Managed music: " + this.activeMusic);
        }
    }

    public final void pauseAllMusic() {
        this.log.debug("Pausing all music");
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.pause$fxgl();
        }
    }

    public final void resumeAllMusic() {
        this.log.debug("Resuming all music");
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.resume$fxgl();
        }
    }

    public final void stopAllMusic() {
        this.log.debug("Stopping all music. Active music size: " + this.activeMusic.size());
        Iterable $receiver$iv = this.activeMusic;
        for (Object element$iv : $receiver$iv) {
            Music it = (Music)element$iv;
            it.stop$fxgl();
        }
    }

    public final void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Saving data to profile");
        Bundle bundle = new Bundle("audio");
        bundle.put("musicVolume", Double.valueOf(this.getGlobalMusicVolume()));
        bundle.put("soundVolume", Double.valueOf(this.getGlobalSoundVolume()));
        bundle.log();
        profile.putBundle(bundle);
    }

    public final void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        this.log.debug("Loading data from profile");
        Bundle bundle = profile.getBundle("audio");
        bundle.log();
        this.setGlobalMusicVolume(((Number)bundle.get("musicVolume")).doubleValue());
        this.setGlobalSoundVolume(((Number)bundle.get("soundVolume")).doubleValue());
    }
}

