/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import kotlin.Metadata;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/core/math/PerlinNoiseGenerator;", "", "()V", "NOISE_MASK", "", "NOISE_TABLE_SIZE", "gx", "", "gy", "p", "", "noise1D", "", "t", "noise2D", "x", "y", "setSeedAndReinitialize", "", "fxgl"})
public final class PerlinNoiseGenerator {
    private static final int NOISE_TABLE_SIZE = 256;
    private static final int NOISE_MASK = 255;
    private static final int[] p;
    private static final float[] gx;
    private static final float[] gy;
    public static final PerlinNoiseGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void setSeedAndReinitialize() {
        int i;
        for (i = 0; i < NOISE_TABLE_SIZE; ++i) {
            PerlinNoiseGenerator.p[i] = i;
        }
        for (i = 0; i < NOISE_TABLE_SIZE; ++i) {
            int j = FXGLMath.random(1, Integer.MAX_VALUE) & NOISE_MASK;
            int nSwap = p[i];
            PerlinNoiseGenerator.p[i] = p[j];
            PerlinNoiseGenerator.p[j] = nSwap;
        }
        int n = 0;
        int n2 = NOISE_TABLE_SIZE - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                Vec2 v = new Vec2();
                v.x = FXGLMath.randomFloat() - 0.5f;
                v.y = FXGLMath.randomFloat() - 0.5f;
                v.normalizeLocal();
                PerlinNoiseGenerator.gx[i2] = v.x;
                PerlinNoiseGenerator.gy[i2] = v.y;
                if (i2 == n2) break;
                ++i2;
            }
        }
    }

    public final double noise1D(double t) {
        int qx0 = (int)Math.floor(t);
        int qx1 = qx0 + 1;
        double tx0 = t - (double)qx0;
        double tx1 = tx0 - 1.0;
        double v0 = (double)gx[qx0 &= NOISE_MASK] * tx0;
        double v1 = (double)gx[qx1 &= NOISE_MASK] * tx1;
        double wx = ((double)3 - (double)2 * tx0) * tx0 * tx0;
        return v0 - wx * (v0 - v1);
    }

    public final double noise2D(double x, double y) {
        int qx0 = (int)Math.floor(x);
        int qx1 = qx0 + 1;
        double tx0 = x - (double)qx0;
        double tx1 = tx0 - 1.0;
        int qy0 = (int)Math.floor(y);
        int qy1 = qy0 + 1;
        double ty0 = y - (double)qy0;
        double ty1 = ty0 - 1.0;
        int q00 = p[(qy0 &= NOISE_MASK) + p[qx0 &= NOISE_MASK] & NOISE_MASK];
        int q01 = p[qy0 + p[qx1 &= NOISE_MASK] & NOISE_MASK];
        int q10 = p[(qy1 &= NOISE_MASK) + p[qx0] & NOISE_MASK];
        int q11 = p[qy1 + p[qx1] & NOISE_MASK];
        double v00 = (double)gx[q00] * tx0 + (double)gy[q00] * ty0;
        double v01 = (double)gx[q01] * tx1 + (double)gy[q01] * ty0;
        double v10 = (double)gx[q10] * tx0 + (double)gy[q10] * ty1;
        double v11 = (double)gx[q11] * tx1 + (double)gy[q11] * ty1;
        double wx = ((double)3 - (double)2 * tx0) * tx0 * tx0;
        double v0 = v00 - wx * (v00 - v01);
        double v1 = v10 - wx * (v10 - v11);
        double wy = ((double)3 - (double)2 * ty0) * ty0 * ty0;
        return v0 - wy * (v0 - v1);
    }

    private PerlinNoiseGenerator() {
    }

    static {
        PerlinNoiseGenerator perlinNoiseGenerator;
        INSTANCE = perlinNoiseGenerator = new PerlinNoiseGenerator();
        NOISE_TABLE_SIZE = 256;
        NOISE_MASK = 255;
        p = new int[NOISE_TABLE_SIZE];
        gx = new float[NOISE_TABLE_SIZE];
        gy = new float[NOISE_TABLE_SIZE];
        perlinNoiseGenerator.setSeedAndReinitialize();
    }
}

