/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.effect;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.effect.Particle;
import com.almasb.fxgl.util.TriFunction;
import java.util.Random;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ParticleEmitter {
    private static final ObjectMap<Color, ObjectMap<Color, Image[]>> IMAGE_CACHE = new ObjectMap();
    private Random random = FXGLMath.getRandom();
    private IntegerProperty numParticles = new SimpleIntegerProperty(25);
    private DoubleProperty emissionRate = new SimpleDoubleProperty(1.0);
    private int maxEmissions = Integer.MAX_VALUE;
    private DoubleProperty minSize = new SimpleDoubleProperty(9.0);
    private DoubleProperty maxSize = new SimpleDoubleProperty(12.0);
    private ObjectProperty<Paint> startColor = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private ObjectProperty<Paint> endColor = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private ObjectProperty<BlendMode> blendMode = new SimpleObjectProperty((Object)BlendMode.SRC_OVER);
    private ObjectProperty<Interpolator> interpolator = new SimpleObjectProperty((Object)Interpolator.LINEAR);
    private Supplier<Point2D> accelerationFunction = () -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> velocityFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> spawnPointFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Point2D> scaleFunction = (i, x, y) -> Point2D.ZERO;
    private TriFunction<Integer, Double, Double, Duration> expireFunction = (i, x, y) -> Duration.seconds((double)1.0);
    private Image sourceImage = null;
    private double rateAC = 1.0;
    private int emissions = 0;
    private Array<Particle> emissionParticles = new UnorderedArray<Particle>(this.getNumParticles());

    private static Image createImage(Node node) {
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        int imageWidth = (int)node.getBoundsInLocal().getWidth();
        int imageHeight = (int)node.getBoundsInLocal().getHeight();
        WritableImage image = new WritableImage(imageWidth, imageHeight);
        Async.startFX(() -> node.snapshot(parameters, image)).await();
        return image;
    }

    private static Image[] preCreateImages(Color startColor, Color endColor) {
        int count = 100;
        double width = count;
        Stop[] stops = new Stop[]{new Stop(0.0, Color.BLACK.deriveColor(1.0, 1.0, 1.0, 0.0)), new Stop(0.3, endColor), new Stop(0.9, startColor), new Stop(1.0, startColor)};
        Rectangle rectangle = new Rectangle(width, 1.0, (Paint)new LinearGradient(0.0, 0.0, width, 0.0, false, CycleMethod.NO_CYCLE, stops));
        Image lookupImage = ParticleEmitter.createImage((Node)rectangle);
        Image[] list = new Image[count];
        double radius = 10.0;
        for (int i = 0; i < count; ++i) {
            Color color = lookupImage.getPixelReader().getColor(i, 0);
            Circle ball = new Circle(radius);
            RadialGradient gradient = new RadialGradient(0.0, 0.0, 0.0, 0.0, radius, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, color.deriveColor(1.0, 1.0, 1.0, 1.0)), new Stop(1.0, color.deriveColor(1.0, 1.0, 1.0, 0.0))});
            ball.setFill((Paint)gradient);
            list[i] = ParticleEmitter.createImage((Node)ball);
        }
        return list;
    }

    static Image getCachedImage(Color startColor, Color endColor, int index) {
        Image[] images;
        ObjectMap<Object, Object> map2 = IMAGE_CACHE.get(startColor);
        if (map2 == null) {
            map2 = new ObjectMap();
            IMAGE_CACHE.put(startColor, map2);
        }
        if ((images = map2.get(endColor)) == null) {
            images = ParticleEmitter.preCreateImages(startColor, endColor);
            map2.put(endColor, images);
        }
        return images[index];
    }

    public IntegerProperty numParticlesProperty() {
        return this.numParticles;
    }

    public final int getNumParticles() {
        return this.numParticles.get();
    }

    public final void setNumParticles(int numParticles) {
        this.numParticles.set(numParticles);
    }

    public final DoubleProperty emissionRateProperty() {
        return this.emissionRate;
    }

    public final double getEmissionRate() {
        return this.emissionRate.get();
    }

    public final void setEmissionRate(double emissionRate) {
        this.emissionRate.set(emissionRate);
    }

    public final int getMaxEmissions() {
        return this.maxEmissions;
    }

    public final void setMaxEmissions(int maxEmissions) {
        this.maxEmissions = maxEmissions;
    }

    public boolean isFinished() {
        return this.emissions == this.maxEmissions;
    }

    public final double getMinSize() {
        return this.minSize.get();
    }

    public final DoubleProperty minSizeProperty() {
        return this.minSize;
    }

    public final void setMinSize(double minSize) {
        this.minSize.set(minSize);
    }

    public final double getMaxSize() {
        return this.maxSize.get();
    }

    public final DoubleProperty maxSizeProperty() {
        return this.maxSize;
    }

    public final void setMaxSize(double maxSize) {
        this.maxSize.set(maxSize);
    }

    public final void setSize(double min, double max) {
        this.setMinSize(min);
        this.setMaxSize(max);
    }

    private double getRandomSize() {
        return this.rand(this.getMinSize(), this.getMaxSize());
    }

    public final Paint getStartColor() {
        return (Paint)this.startColor.get();
    }

    public final ObjectProperty<Paint> startColorProperty() {
        return this.startColor;
    }

    public final void setStartColor(Paint startColor) {
        this.startColor.set((Object)startColor);
    }

    public final Paint getEndColor() {
        return (Paint)this.endColor.get();
    }

    public final ObjectProperty<Paint> endColorProperty() {
        return this.endColor;
    }

    public final void setEndColor(Paint endColor) {
        this.endColor.set((Object)endColor);
    }

    public final void setColor(Paint color) {
        this.setStartColor(color);
        this.setEndColor(color);
    }

    public final BlendMode getBlendMode() {
        return (BlendMode)this.blendMode.get();
    }

    public final ObjectProperty<BlendMode> blendModeProperty() {
        return this.blendMode;
    }

    public final void setBlendMode(BlendMode blendMode) {
        this.blendMode.set((Object)blendMode);
    }

    public final Interpolator getInterpolator() {
        return (Interpolator)this.interpolator.get();
    }

    public final ObjectProperty<Interpolator> interpolatorProperty() {
        return this.interpolator;
    }

    public final void setInterpolator(Interpolator interpolator) {
        this.interpolator.set((Object)interpolator);
    }

    public final Supplier<Point2D> getAccelerationFunction() {
        return this.accelerationFunction;
    }

    public final void setAccelerationFunction(Supplier<Point2D> gravityFunction) {
        this.accelerationFunction = gravityFunction;
    }

    public final void setVelocityFunction(TriFunction<Integer, Double, Double, Point2D> velocityFunction) {
        this.velocityFunction = velocityFunction;
    }

    public final void setSpawnPointFunction(TriFunction<Integer, Double, Double, Point2D> spawnPointFunction) {
        this.spawnPointFunction = spawnPointFunction;
    }

    public final void setScaleFunction(TriFunction<Integer, Double, Double, Point2D> scaleFunction) {
        this.scaleFunction = scaleFunction;
    }

    public final void setExpireFunction(TriFunction<Integer, Double, Double, Duration> expireFunction) {
        this.expireFunction = expireFunction;
    }

    public void setSourceImage(Image sourceImage) {
        this.sourceImage = sourceImage;
    }

    protected final double rand() {
        return this.random.nextDouble();
    }

    protected final double rand(double min, double max) {
        return this.rand() * (max - min) + min;
    }

    final Array<Particle> emit(double x, double y) {
        double rate = this.getEmissionRate();
        this.rateAC += rate;
        if (this.rateAC < 1.0 || rate == 0.0 || this.isFinished()) {
            return Array.empty();
        }
        this.rateAC = 0.0;
        ++this.emissions;
        this.emissionParticles.clear();
        int num = this.getNumParticles();
        for (int i = 0; i < num; ++i) {
            this.emissionParticles.add(this.emit(i, x, y));
        }
        return this.emissionParticles;
    }

    private Particle emit(int i, double x, double y) {
        Particle particle = Pools.obtain(Particle.class);
        particle.init(this.sourceImage, this.spawnPointFunction.apply(i, x, y), this.velocityFunction.apply(i, x, y), this.accelerationFunction.get(), this.getRandomSize(), this.scaleFunction.apply(i, x, y), this.expireFunction.apply(i, x, y), this.getStartColor(), this.getEndColor(), this.getBlendMode(), this.getInterpolator());
        return particle;
    }
}

