/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.component;

import com.almasb.fxgl.entity.Component;
import com.almasb.fxgl.entity.serialization.SerializableComponent;
import com.almasb.fxgl.io.serialization.Bundle;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.jetbrains.annotations.NotNull;

public abstract class IntegerComponent
extends Component
implements SerializableComponent {
    private IntegerProperty property;

    public IntegerComponent() {
        this(0);
    }

    public IntegerComponent(int initialValue) {
        this.property = new SimpleIntegerProperty(initialValue);
    }

    public final IntegerProperty valueProperty() {
        return this.property;
    }

    public final int getValue() {
        return this.property.get();
    }

    public final void setValue(int value) {
        this.property.set(value);
    }

    @Override
    public void write(@NotNull Bundle bundle) {
        bundle.put("value", Integer.valueOf(this.getValue()));
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        this.setValue((Integer)bundle.get("value"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + this.getValue() + "]";
    }
}

