/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.gameplay;

import com.almasb.fxgl.io.serialization.Bundle;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.saving.UserProfileSavable;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/gameplay/GameplayStats;", "Lcom/almasb/fxgl/saving/UserProfileSavable;", "()V", "playtime", "Ljavafx/beans/property/ReadOnlyLongWrapper;", "getPlaytime", "", "getPlaytimeHours", "getPlaytimeMinutes", "getPlaytimeSeconds", "load", "", "profile", "Lcom/almasb/fxgl/saving/UserProfile;", "onUpdate", "tpf", "", "playtimeProperty", "Ljavafx/beans/property/ReadOnlyLongProperty;", "save", "secondsToNanos", "seconds", "fxgl"})
public final class GameplayStats
implements UserProfileSavable {
    private final ReadOnlyLongWrapper playtime = new ReadOnlyLongWrapper();

    @NotNull
    public final ReadOnlyLongProperty playtimeProperty() {
        ReadOnlyLongProperty readOnlyLongProperty = this.playtime.getReadOnlyProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)readOnlyLongProperty, (String)"playtime.readOnlyProperty");
        return readOnlyLongProperty;
    }

    public final long getPlaytime() {
        return this.playtimeProperty().get();
    }

    public final long getPlaytimeHours() {
        return (long)((double)this.getPlaytime() / 1.0E9 / 3600.0);
    }

    public final long getPlaytimeMinutes() {
        return (long)((double)this.getPlaytime() / 1.0E9 / 60.0) % (long)60;
    }

    public final long getPlaytimeSeconds() {
        return (long)((double)this.getPlaytime() / 1.0E9) % (long)60;
    }

    public final void onUpdate(double tpf) {
        ReadOnlyLongWrapper readOnlyLongWrapper = this.playtime;
        readOnlyLongWrapper.setValue((Number)(readOnlyLongWrapper.getValue() + this.secondsToNanos(tpf)));
    }

    @Override
    public void save(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Bundle bundle = new Bundle("gameplayStats");
        Long l = this.playtime.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"playtime.value");
        bundle.put("playtime", l);
        bundle.log();
        profile.putBundle(bundle);
    }

    @Override
    public void load(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        Bundle bundle = profile.getBundle("gameplayStats");
        bundle.log();
        this.playtime.setValue((Number)bundle.get("playtime"));
    }

    private final long secondsToNanos(double seconds) {
        return (long)(seconds * (double)1000000000L);
    }
}

