/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.box2d.callbacks.RayCastCallback;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/physics/EdgeCallback;", "Lcom/almasb/fxgl/physics/box2d/callbacks/RayCastCallback;", "()V", "<set-?>", "", "bestFraction", "getBestFraction", "()F", "setBestFraction", "(F)V", "Lcom/almasb/fxgl/physics/box2d/dynamics/Fixture;", "fixture", "getFixture", "()Lcom/almasb/fxgl/physics/box2d/dynamics/Fixture;", "setFixture", "(Lcom/almasb/fxgl/physics/box2d/dynamics/Fixture;)V", "Lcom/almasb/fxgl/core/math/Vec2;", "point", "getPoint", "()Lcom/almasb/fxgl/core/math/Vec2;", "setPoint", "(Lcom/almasb/fxgl/core/math/Vec2;)V", "reportFixture", "normal", "fraction", "reset", "", "fxgl"})
public final class EdgeCallback
implements RayCastCallback {
    @Nullable
    private Fixture fixture;
    @Nullable
    private Vec2 point;
    private float bestFraction = 1.0f;

    @Nullable
    public final Fixture getFixture() {
        return this.fixture;
    }

    private final void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    @Nullable
    public final Vec2 getPoint() {
        return this.point;
    }

    private final void setPoint(Vec2 vec2) {
        this.point = vec2;
    }

    public final float getBestFraction() {
        return this.bestFraction;
    }

    private final void setBestFraction(float f) {
        this.bestFraction = f;
    }

    @Override
    public float reportFixture(@NotNull Fixture fixture, @NotNull Vec2 point, @Nullable Vec2 normal, float fraction) {
        Intrinsics.checkParameterIsNotNull((Object)fixture, (String)"fixture");
        Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
        Body body = fixture.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)body, (String)"fixture.getBody()");
        Object object = body.getUserData();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.entity.Entity");
        }
        Entity e = (Entity)object;
        PhysicsComponent physicsComponent = e.getComponent(PhysicsComponent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)physicsComponent, (String)"e.getComponent(PhysicsComponent::class.java)");
        if (physicsComponent.isRaycastIgnored()) {
            return 1.0f;
        }
        if (fraction < this.bestFraction) {
            this.fixture = fixture;
            this.point = point.clone();
            this.bestFraction = fraction;
        }
        return this.bestFraction;
    }

    public final void reset() {
        this.fixture = null;
        this.point = null;
        this.bestFraction = 1.0f;
    }
}

