/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ai.btree.utils;

import com.almasb.fxgl.ai.btree.BehaviorTree;
import com.almasb.fxgl.ai.btree.Task;
import com.almasb.fxgl.ai.btree.utils.BehaviorTreeParser;
import com.almasb.fxgl.core.collection.ObjectMap;

public class BehaviorTreeLibrary {
    protected ObjectMap<String, BehaviorTree<?>> repository = new ObjectMap();
    protected BehaviorTreeParser<?> parser;

    public BehaviorTreeLibrary() {
        this(0);
    }

    private BehaviorTreeLibrary(int parseDebugLevel) {
        this.parser = new BehaviorTreeParser(parseDebugLevel);
    }

    public <T> Task<T> createRootTask(String treeReference) {
        return this.retrieveArchetypeTree(treeReference).getChild(0).cloneTask();
    }

    public <T> BehaviorTree<T> createBehaviorTree(String treeReference) {
        return this.createBehaviorTree(treeReference, null);
    }

    public <T> BehaviorTree<T> createBehaviorTree(String treeReference, T blackboard) {
        BehaviorTree bt = (BehaviorTree)this.retrieveArchetypeTree(treeReference).cloneTask();
        bt.setEntity(blackboard);
        return bt;
    }

    protected BehaviorTree<?> retrieveArchetypeTree(String treeReference) {
        throw new UnsupportedOperationException("Archetype retrieve not supported!");
    }

    public void registerArchetypeTree(String treeReference, BehaviorTree<?> archetypeTree) {
        if (archetypeTree == null) {
            throw new IllegalArgumentException("The registered archetype must not be null.");
        }
        this.repository.put(treeReference, archetypeTree);
    }

    public boolean hasArchetypeTree(String treeReference) {
        return this.repository.containsKey(treeReference);
    }
}

