/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.algorithm;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.math.FXGLMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/algorithm/PlatformerLevelGenerator;", "", "()V", "randoms", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "", "Ljava/util/Random;", "dist", "", "params", "Lcom/almasb/fxgl/algorithm/PlatformerLevelGenerator$Params;", "make", "", "Ljavafx/geometry/Rectangle2D;", "pLength", "Params", "fxgl"})
public final class PlatformerLevelGenerator {
    private static final ObjectMap<Long, Random> randoms;
    public static final PlatformerLevelGenerator INSTANCE;

    @NotNull
    public final List<Rectangle2D> make(@NotNull Params params) {
        int pLength;
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (!randoms.containsKey(params.getRandomSeed())) {
            randoms.put(params.getRandomSeed(), FXGLMath.getRandom(params.getRandomSeed()));
        }
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>();
        for (int length = 0; length < params.getLevelLength() && length + (pLength = this.pLength(params)) <= params.getLevelLength(); length += pLength + this.dist(params)) {
            result.add(new Rectangle2D((double)length, 0.0, (double)pLength, 1.0));
        }
        return result;
    }

    private final int pLength(Params params) {
        int offset = randoms.get(params.getRandomSeed()).nextInt(params.getMaxPlatformLength() - params.getMinPlatformLength() + 1);
        return params.getMinPlatformLength() + offset;
    }

    private final int dist(Params params) {
        int offset = randoms.get(params.getRandomSeed()).nextInt(params.getMaxPlatformDistance() - params.getMinPlatformDistance() + 1);
        return params.getMinPlatformDistance() + offset;
    }

    private PlatformerLevelGenerator() {
    }

    static {
        PlatformerLevelGenerator platformerLevelGenerator;
        INSTANCE = platformerLevelGenerator = new PlatformerLevelGenerator();
        randoms = new ObjectMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/algorithm/PlatformerLevelGenerator$Params;", "", "levelLength", "", "randomSeed", "", "minPlatformLength", "maxPlatformLength", "minPlatformDistance", "maxPlatformDistance", "(IJIIII)V", "getLevelLength", "()I", "getMaxPlatformDistance", "getMaxPlatformLength", "getMinPlatformDistance", "getMinPlatformLength", "getRandomSeed", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "fxgl"})
    public static final class Params {
        private final int levelLength;
        private final long randomSeed;
        private final int minPlatformLength;
        private final int maxPlatformLength;
        private final int minPlatformDistance;
        private final int maxPlatformDistance;

        public final int getLevelLength() {
            return this.levelLength;
        }

        public final long getRandomSeed() {
            return this.randomSeed;
        }

        public final int getMinPlatformLength() {
            return this.minPlatformLength;
        }

        public final int getMaxPlatformLength() {
            return this.maxPlatformLength;
        }

        public final int getMinPlatformDistance() {
            return this.minPlatformDistance;
        }

        public final int getMaxPlatformDistance() {
            return this.maxPlatformDistance;
        }

        public Params(int levelLength, long randomSeed, int minPlatformLength, int maxPlatformLength, int minPlatformDistance, int maxPlatformDistance) {
            this.levelLength = levelLength;
            this.randomSeed = randomSeed;
            this.minPlatformLength = minPlatformLength;
            this.maxPlatformLength = maxPlatformLength;
            this.minPlatformDistance = minPlatformDistance;
            this.maxPlatformDistance = maxPlatformDistance;
        }

        public final int component1() {
            return this.levelLength;
        }

        public final long component2() {
            return this.randomSeed;
        }

        public final int component3() {
            return this.minPlatformLength;
        }

        public final int component4() {
            return this.maxPlatformLength;
        }

        public final int component5() {
            return this.minPlatformDistance;
        }

        public final int component6() {
            return this.maxPlatformDistance;
        }

        @NotNull
        public final Params copy(int levelLength, long randomSeed, int minPlatformLength, int maxPlatformLength, int minPlatformDistance, int maxPlatformDistance) {
            return new Params(levelLength, randomSeed, minPlatformLength, maxPlatformLength, minPlatformDistance, maxPlatformDistance);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, int n, long l, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = params.levelLength;
            }
            if ((n6 & 2) != 0) {
                l = params.randomSeed;
            }
            if ((n6 & 4) != 0) {
                n2 = params.minPlatformLength;
            }
            if ((n6 & 8) != 0) {
                n3 = params.maxPlatformLength;
            }
            if ((n6 & 0x10) != 0) {
                n4 = params.minPlatformDistance;
            }
            if ((n6 & 0x20) != 0) {
                n5 = params.maxPlatformDistance;
            }
            return params.copy(n, l, n2, n3, n4, n5);
        }

        public String toString() {
            return "Params(levelLength=" + this.levelLength + ", randomSeed=" + this.randomSeed + ", minPlatformLength=" + this.minPlatformLength + ", maxPlatformLength=" + this.maxPlatformLength + ", minPlatformDistance=" + this.minPlatformDistance + ", maxPlatformDistance=" + this.maxPlatformDistance + ")";
        }

        public int hashCode() {
            long l = this.randomSeed;
            return ((((this.levelLength * 31 + (int)(l ^ l >>> 32)) * 31 + this.minPlatformLength) * 31 + this.maxPlatformLength) * 31 + this.minPlatformDistance) * 31 + this.maxPlatformDistance;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!(this.levelLength == params.levelLength) || !(this.randomSeed == params.randomSeed) || !(this.minPlatformLength == params.minPlatformLength) || !(this.maxPlatformLength == params.maxPlatformLength) || !(this.minPlatformDistance == params.minPlatformDistance) || !(this.maxPlatformDistance == params.maxPlatformDistance)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

