/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AppState;
import com.almasb.fxgl.app.LoadingState;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.app.StateChangeListener;
import com.almasb.fxgl.app.SubState;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.saving.DataFile;
import java.util.ArrayDeque;
import java.util.Deque;

public final class AppStateMachine {
    private static final Logger log = Logger.get(AppStateMachine.class);
    private Array<StateChangeListener> listeners = new Array();
    private final AppState loading;
    private final AppState play;
    private final State dialog;
    private final AppState intro;
    private final AppState mainMenu;
    private final AppState gameMenu;
    private AppState appState;
    private Deque<SubState> subStates = new ArrayDeque<SubState>();

    AppStateMachine(AppState loading, AppState play, State dialog2, AppState intro, AppState mainMenu, AppState gameMenu, AppState initial) {
        this.loading = loading;
        this.play = play;
        this.dialog = dialog2;
        this.intro = intro;
        this.mainMenu = mainMenu;
        this.gameMenu = gameMenu;
        this.appState = initial;
    }

    public void addListener(StateChangeListener listener2) {
        this.listeners.add(listener2);
    }

    public void removeListener(StateChangeListener listener2) {
        this.listeners.removeValueByIdentity(listener2);
    }

    private void setState(AppState newState) {
        if (!this.subStates.isEmpty()) {
            log.warning("Cannot change states with active substates");
            return;
        }
        AppState prevState = this.appState;
        prevState.exit();
        for (StateChangeListener listener2 : this.listeners) {
            listener2.beforeExit(prevState);
        }
        for (StateChangeListener listener2 : this.listeners) {
            listener2.beforeEnter(newState);
        }
        this.appState = newState;
        log.debug(prevState + " -> " + newState);
        for (StateChangeListener listener2 : this.listeners) {
            listener2.exited(prevState);
        }
        for (StateChangeListener listener2 : this.listeners) {
            listener2.entered(newState);
        }
        this.appState.enter(prevState);
    }

    void onUpdate(double tpf) {
        this.getCurrentState().update(tpf);
    }

    public void pushState(SubState newState) {
        log.debug("Push state: " + newState);
        State prevState = this.getCurrentState();
        prevState.getInput().clearAll();
        log.debug(prevState + " -> " + newState);
        for (StateChangeListener listener2 : this.listeners) {
            listener2.beforeEnter(newState);
        }
        this.subStates.push(newState);
        for (StateChangeListener listener2 : this.listeners) {
            listener2.entered(newState);
        }
        newState.enter(prevState);
    }

    public void popState() {
        if (this.subStates.isEmpty()) {
            throw new IllegalStateException("Cannot pop state: Substates are empty!");
        }
        SubState prevState = this.subStates.getFirst();
        log.debug("Pop state: " + prevState);
        prevState.exit();
        for (StateChangeListener listener2 : this.listeners) {
            listener2.beforeExit(prevState);
        }
        this.subStates.pop();
        for (StateChangeListener listener2 : this.listeners) {
            listener2.exited(prevState);
        }
        log.debug(this.getCurrentState() + " <- " + prevState);
    }

    public State getCurrentState() {
        return this.subStates.isEmpty() ? this.appState : (State)this.subStates.peek();
    }

    public State getIntroState() {
        if (this.intro == AppState.EMPTY) {
            throw new IllegalStateException("Intro is not enabled");
        }
        return this.intro;
    }

    public State getLoadingState() {
        return this.loading;
    }

    public State getMainMenuState() {
        if (this.mainMenu == AppState.EMPTY) {
            throw new IllegalStateException("Menu is not enabled");
        }
        return this.mainMenu;
    }

    public State getGameMenuState() {
        if (this.gameMenu == AppState.EMPTY) {
            throw new IllegalStateException("Menu is not enabled");
        }
        return this.gameMenu;
    }

    public State getPlayState() {
        return this.play;
    }

    public State getDialogState() {
        return this.dialog;
    }

    void startIntro() {
        this.setState(this.intro);
    }

    void startLoad(DataFile dataFile) {
        if (this.loading instanceof LoadingState) {
            ((LoadingState)this.loading).setDataFile(dataFile);
        }
        this.setState(this.loading);
    }

    void startGameMenu() {
        this.setState(this.gameMenu);
    }

    void startMainMenu() {
        this.setState(this.mainMenu);
    }

    void startPlay() {
        this.setState(this.play);
    }

    public boolean isInPlay() {
        return this.getCurrentState() == this.getPlayState();
    }

    public boolean isInGameMenu() {
        return this.getCurrentState() == this.getGameMenuState();
    }
}

