/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio;

import com.almasb.fxgl.core.Disposable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u001fH\u0016J\r\u0010$\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u000200H\u0016R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00062"}, d2={"Lcom/almasb/fxgl/audio/Music;", "Lcom/almasb/fxgl/core/Disposable;", "media", "Ljavafx/scene/media/Media;", "(Ljavafx/scene/media/Media;)V", "balance", "", "getBalance", "()D", "setBalance", "(D)V", "count", "", "cycleCount", "getCycleCount", "()I", "setCycleCount", "(I)V", "mediaPlayer", "Ljavafx/scene/media/MediaPlayer;", "rate", "getRate", "setRate", "<set-?>", "Lcom/almasb/fxgl/audio/Music$Status;", "status", "getStatus$fxgl", "()Lcom/almasb/fxgl/audio/Music$Status;", "setStatus", "(Lcom/almasb/fxgl/audio/Music$Status;)V", "bindVolume", "", "volume", "Ljavafx/beans/property/DoubleProperty;", "bindVolume$fxgl", "dispose", "pause", "pause$fxgl", "reachedEnd", "", "reachedEnd$fxgl", "resume", "resume$fxgl", "start", "start$fxgl", "stop", "stop$fxgl", "toString", "", "Status", "fxgl"})
public final class Music
implements Disposable {
    private final MediaPlayer mediaPlayer;
    @NotNull
    private Status status;

    @NotNull
    public final Status getStatus$fxgl() {
        return this.status;
    }

    private final void setStatus(Status status) {
        this.status = status;
    }

    public final boolean reachedEnd$fxgl() {
        return Intrinsics.areEqual((Object)this.mediaPlayer.getCurrentTime(), (Object)this.mediaPlayer.getCycleDuration()) && this.mediaPlayer.getCurrentCount() >= this.mediaPlayer.getCycleCount();
    }

    public final void start$fxgl() {
        if (Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)Status.STOPPED))) {
            this.status = Status.PLAYING;
            this.mediaPlayer.play();
        }
    }

    public final void pause$fxgl() {
        if (Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)Status.PLAYING))) {
            this.status = Status.PAUSED;
            this.mediaPlayer.pause();
        }
    }

    public final void resume$fxgl() {
        if (Intrinsics.areEqual((Object)((Object)this.status), (Object)((Object)Status.PAUSED))) {
            this.status = Status.PLAYING;
            this.mediaPlayer.play();
        }
    }

    public final void stop$fxgl() {
        this.status = Status.STOPPED;
        this.mediaPlayer.stop();
    }

    public final void bindVolume$fxgl(@NotNull DoubleProperty volume) {
        Intrinsics.checkParameterIsNotNull((Object)volume, (String)"volume");
        this.mediaPlayer.volumeProperty().bind((ObservableValue)volume);
    }

    public final double getBalance() {
        return this.mediaPlayer.getBalance();
    }

    public final void setBalance(double balance) {
        this.mediaPlayer.setBalance(balance);
    }

    public final double getRate() {
        return this.mediaPlayer.getRate();
    }

    public final void setRate(double rate) {
        this.mediaPlayer.setRate(rate);
    }

    public final int getCycleCount() {
        return this.mediaPlayer.getCycleCount();
    }

    public final void setCycleCount(int count) {
        this.mediaPlayer.setCycleCount(count);
    }

    @Override
    public void dispose() {
        this.stop$fxgl();
        this.mediaPlayer.dispose();
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Music [balance=");
        builder.append(this.getBalance());
        builder.append(", volume=");
        builder.append(this.mediaPlayer.getVolume());
        builder.append(", rate=");
        builder.append(this.getRate());
        builder.append(", cycleCount=");
        builder.append(this.getCycleCount());
        builder.append("]");
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public Music(@NotNull Media media) {
        Intrinsics.checkParameterIsNotNull((Object)media, (String)"media");
        this.status = Status.STOPPED;
        this.mediaPlayer = new MediaPlayer(media);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/almasb/fxgl/audio/Music$Status;", "", "(Ljava/lang/String;I)V", "PAUSED", "PLAYING", "STOPPED", "fxgl"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status PAUSED;
        public static final /* enum */ Status PLAYING;
        public static final /* enum */ Status STOPPED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[3];
            Status[] statusArray2 = statusArray;
            statusArray[0] = PAUSED = new Status();
            statusArray[1] = PLAYING = new Status();
            statusArray[2] = STOPPED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }
    }
}

