/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.collection;

import com.almasb.fxgl.util.TriConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class Grid<T> {
    private T[][] data;

    public Grid(int width, int height) {
        this(width, height, (x, y) -> null);
    }

    public Grid(int width, int height, BiFunction<Integer, Integer, T> initFunction) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Cannot create grid with 0 or negative size");
        }
        this.data = new Object[width][height];
        this.populate(initFunction);
    }

    public void populate(BiFunction<Integer, Integer, T> populateFunction) {
        for (int y = 0; y < this.data[0].length; ++y) {
            for (int x = 0; x < this.data.length; ++x) {
                this.set(x, y, populateFunction.apply(x, y));
            }
        }
    }

    public T get(int x, int y) {
        return this.data[x][y];
    }

    public void set(int x, int y, T node) {
        this.data[x][y] = node;
    }

    public void forEach(Consumer<T> function) {
        for (int y = 0; y < this.data[0].length; ++y) {
            for (int x = 0; x < this.data.length; ++x) {
                function.accept(this.get(x, y));
            }
        }
    }

    public void forEach(TriConsumer<T, Integer, Integer> function) {
        for (int y = 0; y < this.data[0].length; ++y) {
            for (int x = 0; x < this.data.length; ++x) {
                function.accept(this.get(x, y), x, y);
            }
        }
    }
}

