/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.BezierSpline;
import com.almasb.fxgl.core.math.ClosedBezierSplineFactory;
import com.almasb.fxgl.core.math.PerlinNoiseGenerator;
import com.almasb.fxgl.core.math.RandomXS128;
import com.almasb.fxgl.core.math.Vec2;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.paint.Color;

public final class FXGLMath {
    public static final double EPSILON = 1.1920928955078125E-7;
    public static final double PI = Math.PI;
    public static final double PI2 = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double E = Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final double radFull = Math.PI * 2;
    private static final double degFull = 360.0;
    private static final double radToIndex = 2607.5945876176133;
    private static final double degToIndex = 45.51111111111111;
    private static final double radiansToDegrees = 57.29577951308232;
    private static final double degreesToRadians = Math.PI / 180;
    private static final Random random = new RandomXS128();
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    private FXGLMath() {
    }

    public static double sin(double radians) {
        return Sin.table[(int)(radians * 2607.5945876176133) & 0x3FFF];
    }

    public static double cos(double radians) {
        return Sin.table[(int)((radians + 1.5707963267948966) * 2607.5945876176133) & 0x3FFF];
    }

    public static double sinDeg(double degrees) {
        return Sin.table[(int)(degrees * 45.51111111111111) & 0x3FFF];
    }

    public static double cosDeg(double degrees) {
        return Sin.table[(int)((degrees + 90.0) * 45.51111111111111) & 0x3FFF];
    }

    public static double toDegrees(double radians) {
        return 57.29577951308232 * radians;
    }

    public static double toRadians(double degrees) {
        return Math.PI / 180 * degrees;
    }

    public static double atan2(double y, double x) {
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (Math.abs(z) < 1.0) {
            double atan = z / (1.0 + 0.28 * z * z);
            if (x < 0.0) {
                return atan + (y < 0.0 ? -Math.PI : Math.PI);
            }
            return atan;
        }
        double atan = 1.5707963267948966 - z / (z * z + 0.28);
        return y < 0.0 ? atan - Math.PI : atan;
    }

    public static double atan2Deg(double y, double x) {
        return FXGLMath.toDegrees(FXGLMath.atan2(y, x));
    }

    public static Random getRandom() {
        return random;
    }

    public static Random getRandom(long seed) {
        return new RandomXS128(seed);
    }

    public static int random(int range) {
        return random.nextInt(range + 1);
    }

    public static int random(int start2, int end) {
        return start2 + random.nextInt(end - start2 + 1);
    }

    public static long random(long range) {
        return (long)(random.nextDouble() * (double)range);
    }

    public static long random(long start2, long end) {
        return start2 + (long)(random.nextDouble() * (double)(end - start2));
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(double chance) {
        return FXGLMath.random() < chance;
    }

    public static double random() {
        return random.nextDouble();
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static double random(double range) {
        return random.nextDouble() * range;
    }

    public static double random(double start2, double end) {
        return start2 + random.nextDouble() * (end - start2);
    }

    public static int randomSign() {
        return 1 | random.nextInt() >> 31;
    }

    public static double randomTriangular() {
        return random.nextDouble() - random.nextDouble();
    }

    public static double randomTriangular(double max) {
        return (random.nextDouble() - random.nextDouble()) * max;
    }

    public static double randomTriangular(double min, double max) {
        return FXGLMath.randomTriangular(min, max, (min + max) * 0.5);
    }

    public static double randomTriangular(double min, double max, double mode) {
        double d;
        double u = random.nextDouble();
        if (u <= (mode - min) / (d = max - min)) {
            return min + Math.sqrt(u * d * (mode - min));
        }
        return max - Math.sqrt((1.0 - u) * d * (max - mode));
    }

    public static Point2D randomPoint(Rectangle2D bounds) {
        return new Point2D(FXGLMath.random(bounds.getMinX(), bounds.getMaxX()), FXGLMath.random(bounds.getMinY(), bounds.getMaxY()));
    }

    public static Vec2 randomVec2() {
        return new Vec2(FXGLMath.random(-1.0, 1.0), FXGLMath.random(-1.0, 1.0)).normalizeLocal();
    }

    public static Point2D randomPoint2D() {
        double y;
        double x = FXGLMath.random(-1.0, 1.0);
        double length = Math.sqrt(x * x + (y = FXGLMath.random(-1.0, 1.0)) * y);
        if (length < 1.1920928955078125E-7) {
            return Point2D.ZERO;
        }
        return new Point2D(x / length, y / length);
    }

    public static Color randomColor() {
        return Color.color((double)FXGLMath.random(), (double)FXGLMath.random(), (double)FXGLMath.random());
    }

    public static <T> Optional<T> random(T[] array) {
        if (array.length == 0) {
            return Optional.empty();
        }
        return Optional.of(array[FXGLMath.random(0, array.length - 1)]);
    }

    public static <T> Optional<T> random(List<T> list) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.get(FXGLMath.random(0, list.size() - 1)));
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double map(double value, double currentRangeStart, double currentRangeStop, double targetRangeStart, double targetRangeStop) {
        return targetRangeStart + (targetRangeStop - targetRangeStart) * ((value - currentRangeStart) / (currentRangeStop - currentRangeStart));
    }

    public static double lerp(double fromValue, double toValue, double progress) {
        return Interpolator.LINEAR.interpolate(fromValue, toValue, progress);
    }

    public static Point2D lerp(double fromX, double fromY, double toX, double toY, double progress) {
        return new Point2D(FXGLMath.lerp(fromX, toX, progress), FXGLMath.lerp(fromY, toY, progress));
    }

    public static double interpolate(double fromValue, double toValue, double progress, Interpolator interpolator) {
        return interpolator.interpolate(fromValue, toValue, progress);
    }

    public static Point2D interpolate(Point2D fromValue, Point2D toValue, double progress, Interpolator interpolator) {
        double x = FXGLMath.interpolate(fromValue.getX(), toValue.getX(), progress, interpolator);
        double y = FXGLMath.interpolate(fromValue.getY(), toValue.getY(), progress, interpolator);
        return new Point2D(x, y);
    }

    public static double lerpAngle(double fromRadians, double toRadians, double progress) {
        double delta = (toRadians - fromRadians + Math.PI * 2 + Math.PI) % (Math.PI * 2) - Math.PI;
        return (fromRadians + delta * progress + Math.PI * 2) % (Math.PI * 2);
    }

    public static double lerpAngleDeg(double fromDegrees, double toDegrees, double progress) {
        double delta = (toDegrees - fromDegrees + 360.0 + 180.0) % 360.0 - 180.0;
        return (fromDegrees + delta * progress + 360.0) % 360.0;
    }

    public static float abs(float value) {
        return value > 0.0f ? value : -value;
    }

    public static double abs(double value) {
        return value > 0.0 ? value : -value;
    }

    public static double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static double max(double a, double b) {
        return a >= b ? a : b;
    }

    public static int floor(double value) {
        return (int)(value + 16384.0) - 16384;
    }

    public static int floorPositive(double value) {
        return (int)value;
    }

    public static int ceil(double value) {
        return (int)(value + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(double value) {
        return (int)(value + 0.9999999);
    }

    public static int round(double value) {
        return (int)(value + 16384.5) - 16384;
    }

    public static int roundPositive(double value) {
        return (int)(value + 0.5);
    }

    public static boolean isCloseToZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isClose(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static double log(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static double log2(double value) {
        return FXGLMath.log(2.0, value);
    }

    public static Point2D bezier(Point2D p1, Point2D p2, Point2D p3, double t) {
        double x = (1.0 - t) * (1.0 - t) * p1.getX() + 2.0 * (1.0 - t) * t * p2.getX() + t * t * p3.getX();
        double y = (1.0 - t) * (1.0 - t) * p1.getY() + 2.0 * (1.0 - t) * t * p2.getY() + t * t * p3.getY();
        return new Point2D(x, y);
    }

    public static Point2D bezier(Point2D p1, Point2D p2, Point2D p3, Point2D p4, double t) {
        double x = Math.pow(1.0 - t, 3.0) * p1.getX() + 3.0 * t * Math.pow(1.0 - t, 2.0) * p2.getX() + 3.0 * t * t * (1.0 - t) * p3.getX() + t * t * t * p4.getX();
        double y = Math.pow(1.0 - t, 3.0) * p1.getY() + 3.0 * t * Math.pow(1.0 - t, 2.0) * p2.getY() + 3.0 * t * t * (1.0 - t) * p3.getY() + t * t * t * p4.getY();
        return new Point2D(x, y);
    }

    public static BezierSpline closedBezierSpline(Vec2[] points) {
        return ClosedBezierSplineFactory.newBezierSpline(points);
    }

    public static double noise1D(double t) {
        return PerlinNoiseGenerator.INSTANCE.noise1D(t) + 0.5;
    }

    public static double noise2D(double x, double y) {
        double noise = PerlinNoiseGenerator.INSTANCE.noise2D(x, y) + 0.5;
        if (noise < 0.0) {
            return 0.0;
        }
        if (noise >= 1.0) {
            return 0.99999999;
        }
        return noise;
    }

    private static class Sin {
        static final double[] table;

        private Sin() {
        }

        static {
            int i;
            table = new double[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = Math.sin((double)(((float)i + 0.5f) / 16384.0f) * (Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((double)i * 45.51111111111111) & 0x3FFF] = Math.sin(FXGLMath.toRadians(i));
            }
        }
    }
}

