/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.Component;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.RenderLayer;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.animation.AnimationBuilder;
import com.almasb.fxgl.parser.tiled.Layer;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.Tileset;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import java.io.Serializable;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;

public final class Entities {
    private Entities() {
    }

    public static Entity makeScreenBounds(double thickness) {
        double w = FXGL.getSettings().getWidth();
        double h = FXGL.getSettings().getHeight();
        Entity bounds = new Entity();
        bounds.getBoundingBoxComponent().addHitBox(new HitBox("LEFT", new Point2D(-thickness, 0.0), BoundingShape.box(thickness, h)));
        bounds.getBoundingBoxComponent().addHitBox(new HitBox("RIGHT", new Point2D(w, 0.0), BoundingShape.box(thickness, h)));
        bounds.getBoundingBoxComponent().addHitBox(new HitBox("TOP", new Point2D(0.0, -thickness), BoundingShape.box(w, thickness)));
        bounds.getBoundingBoxComponent().addHitBox(new HitBox("BOT", new Point2D(0.0, h), BoundingShape.box(w, thickness)));
        bounds.addComponent(new PhysicsComponent());
        return bounds;
    }

    public static EntityBuilder builder() {
        return new EntityBuilder();
    }

    public static AnimationBuilder animationBuilder() {
        return new AnimationBuilder();
    }

    private static Tileset findTileset(int gid, List<Tileset> tilesets) {
        return tilesets.stream().filter(tileset -> gid >= tileset.getFirstgid() && gid < tileset.getFirstgid() + tileset.getTilecount()).findAny().orElseThrow(() -> new IllegalArgumentException("Tileset for gid=" + gid + " not found"));
    }

    private static Image loadTilesetImage(Tileset tileset) {
        String imageName = tileset.getImage();
        imageName = imageName.substring(imageName.lastIndexOf("/") + 1);
        return tileset.getTransparentcolor().isEmpty() ? FXGL.getAssetLoader().loadTexture(imageName).getImage() : FXGL.getAssetLoader().loadTexture(imageName, Color.web((String)tileset.getTransparentcolor())).getImage();
    }

    public static class EntityBuilder {
        private Entity entity = new Entity();

        public EntityBuilder from(SpawnData data) {
            this.at(data.getX(), data.getY());
            data.getData().forEach(entry -> this.entity.setProperty((String)entry.key, entry.value));
            return this;
        }

        public EntityBuilder type(Enum<?> type) {
            this.entity.setType((Serializable)((Object)type));
            return this;
        }

        public EntityBuilder at(double x, double y) {
            this.entity.setPosition(x, y);
            return this;
        }

        public EntityBuilder at(Point2D position2) {
            return this.at(position2.getX(), position2.getY());
        }

        public EntityBuilder at(Vec2 position2) {
            return this.at(position2.x, position2.y);
        }

        public EntityBuilder rotate(double angle) {
            this.entity.setRotation(angle);
            return this;
        }

        public EntityBuilder bbox(HitBox box) {
            this.entity.getBoundingBoxComponent().addHitBox(box);
            return this;
        }

        public EntityBuilder viewFromNode(Node view) {
            this.entity.getViewComponent().setView(view);
            return this;
        }

        public EntityBuilder viewFromNodeWithBBox(Node view) {
            this.entity.getViewComponent().setView(view, true);
            return this;
        }

        public EntityBuilder viewFromTexture(String textureName) {
            this.entity.getViewComponent().setTexture(textureName);
            return this;
        }

        public EntityBuilder viewFromTextureWithBBox(String textureName) {
            this.entity.getViewComponent().setTexture(textureName, true);
            return this;
        }

        public EntityBuilder renderLayer(RenderLayer layer) {
            this.entity.getViewComponent().setRenderLayer(layer);
            return this;
        }

        public EntityBuilder viewFromTiles(TiledMap map2, String layerName) {
            return this.viewFromTiles(map2, layerName, RenderLayer.DEFAULT);
        }

        public EntityBuilder viewFromTiles(TiledMap map2, String layerName, RenderLayer renderLayer) {
            this.entity.getViewComponent().setView(this.tilesToView(map2, layerName), false);
            this.entity.getViewComponent().setRenderLayer(renderLayer);
            return this;
        }

        private Node tilesToView(TiledMap map2, String layerName) {
            Layer layer = map2.getLayerByName(layerName);
            WritableImage buffer = new WritableImage(layer.getWidth() * map2.getTilewidth(), layer.getHeight() * map2.getTileheight());
            for (int i = 0; i < layer.getData().size(); ++i) {
                int gid = layer.getData().get(i);
                if (gid == 0) continue;
                Tileset tileset = Entities.findTileset(gid, map2.getTilesets());
                int tilex = (gid -= tileset.getFirstgid()) % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                int x = i % layer.getWidth();
                int y = i / layer.getWidth();
                int w = map2.getTilewidth();
                int h = map2.getTileheight();
                Image sourceImage = Entities.loadTilesetImage(tileset);
                buffer.getPixelWriter().setPixels(x * w, y * h, w, h, sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing());
            }
            return new ImageView((Image)buffer);
        }

        public EntityBuilder with(Component ... components) {
            for (Component c : components) {
                this.entity.addComponent(c);
            }
            return this;
        }

        public EntityBuilder with(Control ... controls) {
            for (Control c : controls) {
                this.entity.addControl(c);
            }
            return this;
        }

        public EntityBuilder with(String propertyKey, Object propertyValue) {
            this.entity.setProperty(propertyKey, propertyValue);
            return this;
        }

        public Entity build() {
            return this.entity;
        }

        public Entity buildAndAttach() {
            return this.buildAndAttach(FXGL.getApp().getGameWorld());
        }

        public Entity buildAndAttach(GameWorld world) {
            world.addEntity(this.entity);
            return this.entity;
        }
    }
}

