/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.entity.Entity;
import java.util.Optional;
import javafx.beans.NamedArg;
import javafx.event.Event;
import javafx.event.EventType;

public final class EntityEvent
extends Event {
    public static final EventType<EntityEvent> ANY = new EventType(Event.ANY, "ENTITY_EVENT");
    public static final EventType<EntityEvent> ACTIVATE = new EventType(ANY, "ACTIVATE");
    public static final EventType<EntityEvent> DEATH = new EventType(ANY, "DEATH");
    public static final EventType<EntityEvent> REVIVE = new EventType(ANY, "REVIVE");
    private ObjectMap<String, Object> data = new ObjectMap();
    private Entity triggerEntity;
    private Entity targetEntity;
    private static final Object NULL = new Object();

    public ObjectMap<String, Object> getData() {
        return this.data;
    }

    public Entity getTriggerEntity() {
        return this.triggerEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public EntityEvent(@NamedArg(value="eventType") EventType<? extends Event> eventType, Entity triggerEntity, Entity targetEntity) {
        super(eventType);
        this.triggerEntity = triggerEntity;
        this.targetEntity = targetEntity;
    }

    public EntityEvent(@NamedArg(value="eventType") EventType<? extends Event> eventType, Entity triggerEntity) {
        this(eventType, triggerEntity, triggerEntity);
    }

    public final void setData(String key, Object value) {
        this.data.put(key, value);
    }

    public final <T> T getData(String key) {
        Object value = this.data.get(key, NULL);
        if (value == NULL) {
            return null;
        }
        return (T)value;
    }

    public final <T> Optional<T> getDataOptional(String key) {
        Object value = this.data.get(key, null);
        return Optional.ofNullable(value);
    }

    public String toString() {
        return "EntityEvent[trigger=" + this.triggerEntity + ",target=" + this.targetEntity + "]";
    }
}

