/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.RenderLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\rJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0017\u001a\u00020\u0018J1\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u00042\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\"\u0006\u0012\u0002\b\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/entity/GameWorldQuery;", "", "entities", "", "Lcom/almasb/fxgl/entity/Entity;", "(Ljava/util/List;)V", "getCollidingEntities", "entity", "getEntitiesAt", "position", "Ljavafx/geometry/Point2D;", "getEntitiesByLayer", "layer", "Lcom/almasb/fxgl/entity/RenderLayer;", "getEntitiesByType", "types", "", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "Ljava/util/function/Predicate;", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "isOneOfTypes", "", "(Lcom/almasb/fxgl/entity/Entity;[Ljava/lang/Enum;)Z", "fxgl"})
public final class GameWorldQuery {
    private final List<Entity> entities;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Object[] objectArray = types;
        if (objectArray.length == 0) {
            return new ArrayList(this.entities);
        }
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        boolean bl;
        block1: {
            for (Object element$iv : (Object[])types) {
                Enum it = (Enum)element$iv;
                if (!entity.isType(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!it.getBoundingBoxComponent().isWithin(selection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!(it.isColliding(entity) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByLayer(@NotNull RenderLayer layer) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)layer, (String)"layer");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!(it.getRenderLayer().index() == layer.index())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesAt(@NotNull Point2D position2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getPosition(), (Object)position2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public GameWorldQuery(@NotNull List<? extends Entity> entities) {
        Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
        this.entities = entities;
    }
}

