/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.control;

import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import javafx.geometry.Point2D;

public class ProjectileControl
extends Control {
    private Point2D velocity;
    private double speed;

    public ProjectileControl(Point2D direction, double speed) {
        this.velocity = direction.normalize().multiply(speed);
        this.speed = speed;
    }

    public Point2D getVelocity() {
        return this.velocity;
    }

    public Point2D getDirection() {
        return this.velocity.normalize();
    }

    public void setDirection(Point2D direction) {
        this.velocity = direction.normalize().multiply(this.speed);
        this.getEntity().rotateToVector(this.velocity);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
        this.velocity = this.velocity.normalize().multiply(speed);
        this.getEntity().rotateToVector(this.velocity);
    }

    @Override
    public void onAdded(Entity entity) {
        entity.rotateToVector(this.velocity);
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        entity.translate(this.velocity.multiply(tpf));
    }
}

