/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser.tiled;

import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.parser.tiled.Layer;
import com.almasb.fxgl.parser.tiled.TMXParserKt;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.TiledObject;
import com.almasb.fxgl.parser.tiled.Tileset;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/parser/tiled/TMXParser;", "", "()V", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "parse", "Lcom/almasb/fxgl/parser/tiled/TiledMap;", "inputStream", "Ljava/io/InputStream;", "parseData", "", "layer", "Lcom/almasb/fxgl/parser/tiled/Layer;", "data", "", "start", "Ljavax/xml/stream/events/StartElement;", "parseImage", "tileset", "Lcom/almasb/fxgl/parser/tiled/Tileset;", "parseMap", "map", "parseObject", "obj", "Lcom/almasb/fxgl/parser/tiled/TiledObject;", "parseObjectGroupLayer", "parseObjectProperty", "parseTileLayer", "parseTileset", "fxgl"})
public final class TMXParser {
    private final Logger log = Logger.Companion.get(TMXParser.class);

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final TiledMap parse(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        try {
            inputFactory = XMLInputFactory.newInstance();
            eventReader = inputFactory.createXMLEventReader(inputStream);
            map = new TiledMap(0, 0, 0, 0, null, null, null, null, null, 0, 0, null, null, false, 16383, null);
            layers = new ArrayList<Layer>();
            tilesets = new ArrayList<Tileset>();
            currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
            currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
            currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, null, null, 4095, null);
            while (eventReader.hasNext()) {
                block26: {
                    block18: {
                        block22: {
                            block25: {
                                block24: {
                                    block20: {
                                        block23: {
                                            block19: {
                                                block21: {
                                                    v0 = event = eventReader.nextEvent();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"event");
                                                    if (!v0.isStartElement()) break block18;
                                                    v1 = start = event.asStartElement();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"start");
                                                    v2 = v1.getName();
                                                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"start.name");
                                                    v3 = var12_13 = v2.getLocalPart();
                                                    if (v3 == null) break block18;
                                                    switch (v3.hashCode()) {
                                                        case 100313435: {
                                                            if (!var12_13.equals("image")) ** break;
                                                            break block19;
                                                        }
                                                        case 3076010: {
                                                            if (!var12_13.equals("data")) ** break;
                                                            break block20;
                                                        }
                                                        case -1314831628: {
                                                            if (!var12_13.equals("tileset")) ** break;
                                                            break block21;
                                                        }
                                                        case -993141291: {
                                                            if (!var12_13.equals("property")) ** break;
                                                            break block22;
                                                        }
                                                        case 107868: {
                                                            if (!var12_13.equals("map")) ** break;
                                                            break;
                                                        }
                                                        case 102749521: {
                                                            if (!var12_13.equals("layer")) ** break;
                                                            break block23;
                                                        }
                                                        case -1269857632: {
                                                            if (!var12_13.equals("objectgroup")) ** break;
                                                            break block24;
                                                        }
                                                        case -1023368385: {
                                                            if (!var12_13.equals("object")) ** break;
                                                            break block25;
                                                        }
                                                    }
                                                    this.parseMap(map, start);
                                                    ** break;
                                                }
                                                currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
                                                this.parseTileset(currentTileset, start);
                                                ** break;
                                            }
                                            this.parseImage(currentTileset, start);
                                            ** break;
                                        }
                                        currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                                        this.parseTileLayer(currentLayer, start);
                                        ** break;
                                    }
                                    v4 = eventReader;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"eventReader");
                                    v5 = v4.getElementText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"eventReader.elementText");
                                    this.parseData(currentLayer, v5, start);
                                    ** break;
                                }
                                currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                                this.parseObjectGroupLayer(currentLayer, start);
                                ** break;
                            }
                            currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, null, null, 4095, null);
                            this.parseObject(currentLayer, currentObject, start);
                            ** break;
                        }
                        this.parseObjectProperty(currentObject, start);
                    }
                    if (!event.isEndElement()) continue;
                    v6 = endElement = event.asEndElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"endElement");
                    v7 = v6.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"endElement.name");
                    v8 = var12_13 = v7.getLocalPart();
                    if (v8 == null) continue;
                    switch (v8.hashCode()) {
                        case -1314831628: {
                            if (!var12_13.equals("tileset")) ** break;
                            break;
                        }
                        case 102749521: {
                            if (!var12_13.equals("layer")) ** break;
                            break block26;
                        }
                        case -1269857632: {
                            if (!var12_13.equals("objectgroup")) ** break;
                            break block26;
                        }
                    }
                    tilesets.add(currentTileset);
                    ** break;
                }
                layers.add(currentLayer);
lbl101:
                // 6 sources

            }
            map.setLayers((List<Layer>)layers);
            map.setTilesets((List<Tileset>)tilesets);
            return map;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Cannot parse tmx file: " + e);
        }
    }

    private final void parseMap(TiledMap map2, StartElement start2) {
        map2.setWidth(TMXParserKt.access$getInt(start2, "width"));
        map2.setHeight(TMXParserKt.access$getInt(start2, "height"));
        map2.setTilewidth(TMXParserKt.access$getInt(start2, "tilewidth"));
        map2.setTileheight(TMXParserKt.access$getInt(start2, "tileheight"));
        map2.setNextobjectid(TMXParserKt.access$getInt(start2, "nextobjectid"));
        map2.setType("map");
        map2.setVersion(1);
        map2.setInfinite(TMXParserKt.access$getInt(start2, "infinite") == 1);
        map2.setBackgroundcolor(TMXParserKt.access$getString(start2, "backgroundcolor"));
        map2.setOrientation(TMXParserKt.access$getString(start2, "orientation"));
        map2.setRenderorder(TMXParserKt.access$getString(start2, "renderorder"));
        map2.setTiledversion(TMXParserKt.access$getString(start2, "tiledversion"));
        if (Intrinsics.areEqual((Object)map2.getTiledversion(), (Object)"1.1.2") ^ true) {
            this.log.warning("TiledMap generated from " + map2.getTiledversion() + ". Supported version: 1.1.2. Some features may not be parsed fully.");
        }
    }

    private final void parseTileset(Tileset tileset, StartElement start2) {
        tileset.setFirstgid(TMXParserKt.access$getInt(start2, "firstgid"));
        tileset.setName(TMXParserKt.access$getString(start2, "name"));
        tileset.setTilewidth(TMXParserKt.access$getInt(start2, "tilewidth"));
        tileset.setTileheight(TMXParserKt.access$getInt(start2, "tileheight"));
        tileset.setSpacing(TMXParserKt.access$getInt(start2, "spacing"));
        tileset.setTilecount(TMXParserKt.access$getInt(start2, "tilecount"));
        tileset.setColumns(TMXParserKt.access$getInt(start2, "columns"));
    }

    private final void parseImage(Tileset tileset, StartElement start2) {
        tileset.setImage(TMXParserKt.access$getString(start2, "source"));
        tileset.setImagewidth(TMXParserKt.access$getInt(start2, "width"));
        tileset.setImageheight(TMXParserKt.access$getInt(start2, "height"));
        tileset.setTransparentcolor(TMXParserKt.access$getString(start2, "trans"));
    }

    private final void parseTileLayer(Layer layer, StartElement start2) {
        layer.setType("tilelayer");
        layer.setName(TMXParserKt.access$getString(start2, "name"));
        layer.setWidth(TMXParserKt.access$getInt(start2, "width"));
        layer.setHeight(TMXParserKt.access$getInt(start2, "height"));
        layer.setOpacity(TMXParserKt.access$getFloat(start2, "opacity"));
        layer.setVisible(TMXParserKt.access$getInt(start2, "visible") == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseData(Layer layer, String data, StartElement start2) {
        switch (TMXParserKt.access$getString(start2, "encoding")) {
            case "csv": {
                Collection<Integer> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)data, (String)"\n", (String)"", (boolean)false, (int)4, null), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                Layer layer2 = layer;
                void var6_9 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    void var12_28 = it;
                    Integer n = Integer.parseInt((String)var12_28);
                    collection.add(n);
                }
                collection = (List)destination$iv$iv;
                layer2.setData((List<Integer>)collection);
                break;
            }
            case "base64": {
                String $receiver$iv$iv = data;
                Base64.Decoder decoder = Base64.getDecoder();
                String string = $receiver$iv$iv;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                byte[] bytes = decoder.decode(string2);
                switch (TMXParserKt.access$getString(start2, "compression")) {
                    case "zlib": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Closeable closeable = new InflaterInputStream(new ByteArrayInputStream(bytes));
                        Throwable throwable = null;
                        try {
                            InflaterInputStream it22 = (InflaterInputStream)closeable;
                            long it22 = ByteStreamsKt.copyTo$default((InputStream)it22, (OutputStream)baos, (int)0, (int)2, null);
                        }
                        catch (Throwable it22) {
                            throwable = it22;
                            throw it22;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        bytes = baos.toByteArray();
                        break;
                    }
                    case "gzip": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Closeable closeable = new GZIPInputStream(new ByteArrayInputStream(bytes));
                        Throwable throwable = null;
                        try {
                            GZIPInputStream it = (GZIPInputStream)closeable;
                            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)baos, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        bytes = baos.toByteArray();
                    }
                }
                IntBuffer ints = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                int[] intArray = new int[ints.limit()];
                ints.get(intArray);
                layer.setData(ArraysKt.toList((int[])intArray));
            }
        }
    }

    private final void parseObjectGroupLayer(Layer layer, StartElement start2) {
        layer.setType("objectgroup");
        layer.setName(TMXParserKt.access$getString(start2, "name"));
    }

    private final void parseObject(Layer layer, TiledObject obj, StartElement start2) {
        obj.setName(TMXParserKt.access$getString(start2, "name"));
        obj.setType(TMXParserKt.access$getString(start2, "type"));
        obj.setId(TMXParserKt.access$getInt(start2, "id"));
        obj.setX(TMXParserKt.access$getInt(start2, "x"));
        obj.setY(TMXParserKt.access$getInt(start2, "y"));
        obj.setWidth(TMXParserKt.access$getInt(start2, "width"));
        obj.setHeight(TMXParserKt.access$getInt(start2, "height"));
        List<TiledObject> list = layer.getObjects();
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<com.almasb.fxgl.parser.tiled.TiledObject>");
        }
        TypeIntrinsics.asMutableList(list).add(obj);
    }

    private final void parseObjectProperty(TiledObject obj, StartElement start2) {
        Map<String, Object> map2 = obj.getProperties();
        if (map2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        Map map3 = TypeIntrinsics.asMutableMap(map2);
        String string = TMXParserKt.access$getString(start2, "name");
        String string2 = TMXParserKt.access$getString(start2, "value");
        map3.put(string, string2);
        Map<String, String> map4 = obj.getPropertytypes();
        if (map4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        }
        map3 = TypeIntrinsics.asMutableMap(map4);
        string = TMXParserKt.access$getString(start2, "name");
        string2 = TMXParserKt.access$getString(start2, "type");
        map3.put(string, string2);
    }
}

