/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.parser.tiled;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.asset.AssetLoader;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.parser.tiled.Layer;
import com.almasb.fxgl.parser.tiled.TiledMap;
import com.almasb.fxgl.parser.tiled.Tileset;
import com.almasb.fxgl.scene.GameScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.texture.ColoredTexture;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/parser/tiled/TiledLayerView;", "Lcom/almasb/fxgl/entity/view/EntityView;", "map", "Lcom/almasb/fxgl/parser/tiled/TiledMap;", "layer", "Lcom/almasb/fxgl/parser/tiled/Layer;", "(Lcom/almasb/fxgl/parser/tiled/TiledMap;Lcom/almasb/fxgl/parser/tiled/Layer;)V", "buffer", "Ljavafx/scene/image/WritableImage;", "image", "Ljavafx/scene/image/Image;", "getLayer", "()Lcom/almasb/fxgl/parser/tiled/Layer;", "getMap", "()Lcom/almasb/fxgl/parser/tiled/TiledMap;", "sx", "", "sy", "transparentBuffer", "doRedraw", "", "findTileset", "Lcom/almasb/fxgl/parser/tiled/Tileset;", "gid", "", "tilesets", "", "loadTilesetImage", "tileset", "overlap", "Ljavafx/geometry/Rectangle2D;", "rect1", "rect2", "redraw", "fxgl"})
public final class TiledLayerView
extends EntityView {
    private Image image;
    private final WritableImage buffer;
    private final Image transparentBuffer;
    private double sx;
    private double sy;
    @NotNull
    private final TiledMap map;
    @NotNull
    private final Layer layer;

    /*
     * WARNING - void declaration
     */
    private final void doRedraw() {
        GameScene gameScene2 = FXGL.Companion.getApp().getGameScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameScene2, (String)"FXGL.getApp().gameScene");
        Rectangle2D area = gameScene2.getViewport().getVisibleArea();
        PixelWriter writer = this.buffer.getPixelWriter();
        int n = 0;
        int n2 = this.layer.getData().size();
        while (n < n2) {
            void i;
            int gid = ((Number)this.layer.getData().get((int)i)).intValue();
            if (gid != 0) {
                Image sourceImage;
                Tileset tileset = this.findTileset(gid, this.map.getTilesets());
                int tilex = (gid -= tileset.getFirstgid()) % tileset.getColumns();
                int tiley = gid / tileset.getColumns();
                void x = i % this.layer.getWidth();
                void y = i / this.layer.getWidth();
                int w = this.map.getTilewidth();
                int h = this.map.getTileheight();
                if (this.image == null) {
                    this.image = this.loadTilesetImage(tileset);
                }
                if (this.image == null) {
                    Intrinsics.throwNpe();
                }
                void dstX = x * w;
                void dstY = y * h;
                int offsetX = (int)this.sx % w;
                int offsetY = (int)this.sy % h;
                if (area.contains((double)dstX * 1.0, (double)dstY * 1.0) && area.contains((double)dstX + (double)w, (double)dstY) && area.contains((double)dstX + (double)w, (double)dstY + (double)h) && area.contains((double)dstX, (double)dstY + (double)h)) {
                    writer.setPixels((int)(dstX - (int)this.sx), (int)(dstY - (int)this.sy), w, h, sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing());
                } else if (offsetX != 0 || offsetY != 0) {
                    Rectangle2D result;
                    if (area.contains((double)dstX * 1.0 + 1.0, (double)dstY * 1.0 + 1.0)) {
                        result = this.overlap(area, new Rectangle2D((double)dstX, (double)dstY, (double)w, (double)h));
                        writer.setPixels((int)(dstX - (int)this.sx), (int)(dstY - (int)this.sy), (int)result.getWidth(), (int)result.getHeight(), sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing());
                    } else if (area.contains((double)dstX * 1.0 + (double)w - 1.0, (double)dstY * 1.0 + 1.0)) {
                        result = this.overlap(area, new Rectangle2D((double)dstX, (double)dstY, (double)w, (double)h));
                        writer.setPixels((int)(dstX - (int)this.sx + w - (int)result.getWidth()), (int)(dstY - (int)this.sy), (int)result.getWidth(), (int)result.getHeight(), sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing() + w - (int)result.getWidth(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing());
                    } else if (area.contains((double)dstX * 1.0 + 1.0, (double)dstY * 1.0 + (double)h - 1.0)) {
                        result = this.overlap(area, new Rectangle2D((double)dstX, (double)dstY, (double)w, (double)h));
                        writer.setPixels((int)(dstX - (int)this.sx), (int)(dstY - (int)this.sy + h - (int)result.getHeight()), (int)result.getWidth(), (int)result.getHeight(), sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing() + h - (int)result.getHeight());
                    } else if (area.contains((double)dstX * 1.0 + (double)w - 1.0, (double)dstY * 1.0 + (double)h - 1.0)) {
                        result = this.overlap(area, new Rectangle2D((double)dstX, (double)dstY, (double)w, (double)h));
                        writer.setPixels((int)(dstX - (int)this.sx + w - (int)result.getWidth()), (int)(dstY - (int)this.sy + h - (int)result.getHeight()), (int)result.getWidth(), (int)result.getHeight(), sourceImage.getPixelReader(), tilex * w + tileset.getMargin() + tilex * tileset.getSpacing() + w - (int)result.getWidth(), tiley * h + tileset.getMargin() + tiley * tileset.getSpacing() + h - (int)result.getHeight());
                    }
                }
            }
            ++i;
        }
    }

    private final Rectangle2D overlap(Rectangle2D rect1, Rectangle2D rect2) {
        Rectangle2D rectangle2D;
        double d = rect1.getMinX();
        double d2 = rect2.getMinX();
        double x = Math.max(d, d2);
        d2 = rect1.getMinY();
        double d3 = rect2.getMinY();
        double y = Math.max(d2, d3);
        d2 = rect1.getMaxX();
        d3 = rect2.getMaxX();
        double d4 = y;
        double d5 = x;
        Rectangle2D rectangle2D2 = rectangle2D;
        Rectangle2D rectangle2D3 = rectangle2D;
        double d6 = Math.min(d2, d3);
        d2 = rect1.getMaxY();
        d3 = rect2.getMaxY();
        double d7 = Math.min(d2, d3);
        rectangle2D2(d5, d4, d6 -= x, d7 - y);
        return rectangle2D3;
    }

    private final Tileset findTileset(int gid, List<Tileset> tilesets) {
        Object e = tilesets.stream().filter((Predicate)new Predicate<Tileset>(gid){
            final /* synthetic */ int $gid;

            public final boolean test(Tileset tileset) {
                return this.$gid >= tileset.getFirstgid() && this.$gid < tileset.getFirstgid() + tileset.getTilecount();
            }
            {
                this.$gid = n;
            }
        }).findAny().orElseThrow(new Supplier<X>(gid){
            final /* synthetic */ int $gid;

            @NotNull
            public final IllegalArgumentException get() {
                return new IllegalArgumentException("Tileset for gid=" + this.$gid + " not found");
            }
            {
                this.$gid = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"tilesets.stream()\n      \u2026or gid=$gid not found\") }");
        return (Tileset)e;
    }

    private final Image loadTilesetImage(Tileset tileset) {
        Image image;
        String imageName = tileset.getImage();
        CharSequence charSequence = imageName;
        int n = StringsKt.lastIndexOf$default((CharSequence)imageName, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        imageName = string2;
        charSequence = tileset.getTransparentcolor();
        if (charSequence.length() == 0) {
            Image image2 = FXGL.Companion.getAssetLoader().loadTexture(imageName).getImage();
            image = image2;
            Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"FXGL.getAssetLoader().loadTexture(imageName).image");
        } else {
            AssetLoader assetLoader = FXGL.Companion.getAssetLoader();
            Color color = Color.web((String)tileset.getTransparentcolor());
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.web(tileset.transparentcolor)");
            Image image3 = assetLoader.loadTexture(imageName, color).getImage();
            image = image3;
            Intrinsics.checkExpressionValueIsNotNull((Object)image3, (String)"FXGL.getAssetLoader().lo\u2026.transparentcolor)).image");
        }
        return image;
    }

    private final void redraw() {
        long start2 = System.nanoTime();
        start2 = System.nanoTime();
        this.doRedraw();
    }

    @NotNull
    public final TiledMap getMap() {
        return this.map;
    }

    @NotNull
    public final Layer getLayer() {
        return this.layer;
    }

    public TiledLayerView(@NotNull TiledMap map2, @NotNull Layer layer) {
        Intrinsics.checkParameterIsNotNull((Object)map2, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)layer, (String)"layer");
        this.map = map2;
        this.layer = layer;
        GameScene gameScene2 = FXGL.Companion.getApp().getGameScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)gameScene2, (String)"FXGL.getApp().gameScene");
        Viewport viewport = gameScene2.getViewport();
        this.buffer = new WritableImage((int)viewport.getWidth(), (int)viewport.getHeight());
        int n = (int)viewport.getWidth();
        int n2 = (int)viewport.getHeight();
        Color color = Color.TRANSPARENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.TRANSPARENT");
        Image image = new ColoredTexture(n, n2, color).getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"ColoredTexture(viewport.\u2026 Color.TRANSPARENT).image");
        this.transparentBuffer = image;
        viewport.xProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number x) {
                if (x.intValue() < 0) {
                    throw (Throwable)new IllegalStateException("Background x cannot be < 0");
                }
                sx = x.doubleValue();
                this.redraw();
            }
        });
        viewport.yProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number y) {
                if (y.intValue() < 0) {
                    throw (Throwable)new IllegalStateException("Background y cannot be < 0");
                }
                sy = y.doubleValue();
                this.redraw();
            }
        });
        this.addNode((Node)new ImageView((Image)this.buffer));
        this.redraw();
    }

    public static final /* synthetic */ double access$getSx$p(TiledLayerView $this) {
        return $this.sx;
    }

    public static final /* synthetic */ double access$getSy$p(TiledLayerView $this) {
        return $this.sy;
    }
}

