/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.entity.Control;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import javafx.geometry.Point2D;

@Required(value=PhysicsComponent.class)
public class PhysicsControl
extends Control {
    private Body body;
    private PhysicsWorld physicsWorld;
    private Vec2 minMeters = Pools.obtain(Vec2.class);

    PhysicsControl(PhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
    }

    @Override
    public void onAdded(Entity entity) {
        this.body = entity.getComponent(PhysicsComponent.class).body;
    }

    @Override
    public void onUpdate(Entity entity, double tpf) {
        this.minMeters.set(this.body.getPosition().x - this.physicsWorld.toMetersF(entity.getWidth() / 2.0), this.body.getPosition().y + this.physicsWorld.toMetersF(entity.getHeight() / 2.0));
        Point2D minWorld = this.physicsWorld.toPoint(this.minMeters);
        entity.setX(Math.round(minWorld.getX() - entity.getBoundingBoxComponent().getMinXLocal()));
        entity.setY(Math.round(minWorld.getY() - entity.getBoundingBoxComponent().getMinYLocal()));
        entity.setRotation(-Math.toDegrees(this.body.getAngle()));
    }

    @Override
    public void onRemoved(Entity entity) {
        Pools.free(this.minMeters);
    }

    public void reposition(Point2D point) {
        double w = this.getEntity().getWidth();
        double h = this.getEntity().getHeight();
        Vec2 positionMeters = this.physicsWorld.toPoint(new Point2D(point.getX() + w / 2.0, point.getY() + h / 2.0));
        this.body.setTransform(positionMeters, this.body.getAngle());
    }
}

