/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.effect.ParticleControl;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.physics.PhysicsParticle;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.particle.ParticleGroup;
import com.almasb.fxgl.physics.box2d.particle.ParticleSystem;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/physics/PhysicsParticleControl;", "Lcom/almasb/fxgl/effect/ParticleControl;", "group", "Lcom/almasb/fxgl/physics/box2d/particle/ParticleGroup;", "color", "Ljavafx/scene/paint/Color;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "(Lcom/almasb/fxgl/physics/box2d/particle/ParticleGroup;Ljavafx/scene/paint/Color;Lcom/almasb/fxgl/physics/PhysicsWorld;)V", "radiusMeters", "", "radiusPixels", "", "onRemoved", "", "entity", "Lcom/almasb/fxgl/entity/Entity;", "onUpdate", "tpf", "fxgl"})
public final class PhysicsParticleControl
extends ParticleControl {
    private final float radiusMeters;
    private final double radiusPixels;
    private final ParticleGroup group;
    private final Color color;
    private final PhysicsWorld physicsWorld;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.particles.clear();
        World world = this.physicsWorld.getJBox2DWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"physicsWorld.jBox2DWorld");
        ParticleSystem particleSystem = world.getParticleSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)particleSystem, (String)"physicsWorld.jBox2DWorld.particleSystem");
        Vec2[] centers = particleSystem.getParticlePositionBuffer();
        Vec2 pointPhysics = Pools.obtain(Vec2.class);
        int n = this.group.getBufferIndex();
        int n2 = this.group.getBufferIndex() + this.group.getParticleCount();
        while (n < n2) {
            Point2D pointPixels;
            void i;
            Vec2 center = centers[i];
            pointPhysics.set(center.x - this.radiusMeters, center.y + this.radiusMeters);
            Point2D point2D = pointPixels = this.physicsWorld.toPoint(pointPhysics);
            Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"pointPixels");
            this.particles.add(new PhysicsParticle(point2D, this.radiusPixels, (Paint)this.color));
            ++i;
        }
        Pools.free(pointPhysics);
    }

    @Override
    public void onRemoved(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.physicsWorld.getJBox2DWorld().destroyParticlesInGroup(this.group);
        super.onRemoved(entity);
    }

    public PhysicsParticleControl(@NotNull ParticleGroup group, @NotNull Color color, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)physicsWorld, (String)"physicsWorld");
        this.group = group;
        this.color = color;
        this.physicsWorld = physicsWorld;
        World world = this.physicsWorld.getJBox2DWorld();
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"physicsWorld.jBox2DWorld");
        ParticleSystem particleSystem = world.getParticleSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)particleSystem, (String)"physicsWorld.jBox2DWorld.particleSystem");
        this.radiusMeters = particleSystem.getParticleRadius();
        this.radiusPixels = this.physicsWorld.toPixels(this.radiusMeters);
    }
}

