/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.broadphase;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.PairCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeRayCastCallback;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhaseStrategy;
import com.almasb.fxgl.physics.box2d.collision.broadphase.Pair;
import java.util.Arrays;

public class DefaultBroadPhaseBuffer
implements TreeCallback,
BroadPhase {
    private final BroadPhaseStrategy tree;
    private int proxyCount = 0;
    private int m_moveCapacity = 16;
    private int[] m_moveBuffer = new int[this.m_moveCapacity];
    private int m_moveCount = 0;
    private int m_pairCapacity = 16;
    private Pair[] m_pairBuffer = new Pair[this.m_pairCapacity];
    private int m_pairCount = 0;
    private int m_queryProxyId = -1;

    public DefaultBroadPhaseBuffer(BroadPhaseStrategy strategy) {
        for (int i = 0; i < this.m_pairCapacity; ++i) {
            this.m_pairBuffer[i] = new Pair();
        }
        this.tree = strategy;
    }

    @Override
    public final int createProxy(AABB aabb, Object userData) {
        int proxyId = this.tree.createProxy(aabb, userData);
        ++this.proxyCount;
        this.bufferMove(proxyId);
        return proxyId;
    }

    @Override
    public final void destroyProxy(int proxyId) {
        this.unbufferMove(proxyId);
        --this.proxyCount;
        this.tree.destroyProxy(proxyId);
    }

    @Override
    public final void moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        boolean buffer = this.tree.moveProxy(proxyId, aabb, displacement);
        if (buffer) {
            this.bufferMove(proxyId);
        }
    }

    @Override
    public void touchProxy(int proxyId) {
        this.bufferMove(proxyId);
    }

    @Override
    public Object getUserData(int proxyId) {
        return this.tree.getUserData(proxyId);
    }

    @Override
    public AABB getFatAABB(int proxyId) {
        return this.tree.getFatAABB(proxyId);
    }

    @Override
    public boolean testOverlap(int proxyIdA, int proxyIdB) {
        AABB a = this.tree.getFatAABB(proxyIdA);
        AABB b = this.tree.getFatAABB(proxyIdB);
        return AABB.testOverlap(a, b);
    }

    @Override
    public final int getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public final void updatePairs(PairCallback callback) {
        int i;
        this.m_pairCount = 0;
        for (i = 0; i < this.m_moveCount; ++i) {
            this.m_queryProxyId = this.m_moveBuffer[i];
            if (this.m_queryProxyId == -1) continue;
            AABB fatAABB = this.tree.getFatAABB(this.m_queryProxyId);
            this.tree.query(this, fatAABB);
        }
        this.m_moveCount = 0;
        Arrays.sort(this.m_pairBuffer, 0, this.m_pairCount);
        i = 0;
        block1: while (i < this.m_pairCount) {
            Pair primaryPair = this.m_pairBuffer[i];
            Object userDataA = this.tree.getUserData(primaryPair.proxyIdA);
            Object userDataB = this.tree.getUserData(primaryPair.proxyIdB);
            callback.addPair(userDataA, userDataB);
            ++i;
            while (i < this.m_pairCount) {
                Pair pair = this.m_pairBuffer[i];
                if (pair.proxyIdA != primaryPair.proxyIdA || pair.proxyIdB != primaryPair.proxyIdB) continue block1;
                ++i;
            }
        }
    }

    @Override
    public final void query(TreeCallback callback, AABB aabb) {
        this.tree.query(callback, aabb);
    }

    @Override
    public final void raycast(TreeRayCastCallback callback, RayCastInput input) {
        this.tree.raycast(callback, input);
    }

    @Override
    public final int getTreeHeight() {
        return this.tree.getHeight();
    }

    @Override
    public int getTreeBalance() {
        return this.tree.getMaxBalance();
    }

    @Override
    public float getTreeQuality() {
        return this.tree.getAreaRatio();
    }

    protected final void bufferMove(int proxyId) {
        if (this.m_moveCount == this.m_moveCapacity) {
            int[] old = this.m_moveBuffer;
            this.m_moveCapacity *= 2;
            this.m_moveBuffer = new int[this.m_moveCapacity];
            System.arraycopy(old, 0, this.m_moveBuffer, 0, old.length);
        }
        this.m_moveBuffer[this.m_moveCount] = proxyId;
        ++this.m_moveCount;
    }

    protected final void unbufferMove(int proxyId) {
        for (int i = 0; i < this.m_moveCount; ++i) {
            if (this.m_moveBuffer[i] != proxyId) continue;
            this.m_moveBuffer[i] = -1;
        }
    }

    @Override
    public final boolean treeCallback(int proxyId) {
        if (proxyId == this.m_queryProxyId) {
            return true;
        }
        if (this.m_pairCount == this.m_pairCapacity) {
            Pair[] oldBuffer = this.m_pairBuffer;
            this.m_pairCapacity *= 2;
            this.m_pairBuffer = new Pair[this.m_pairCapacity];
            System.arraycopy(oldBuffer, 0, this.m_pairBuffer, 0, oldBuffer.length);
            for (int i = oldBuffer.length; i < this.m_pairCapacity; ++i) {
                this.m_pairBuffer[i] = new Pair();
            }
        }
        if (proxyId < this.m_queryProxyId) {
            this.m_pairBuffer[this.m_pairCount].proxyIdA = proxyId;
            this.m_pairBuffer[this.m_pairCount].proxyIdB = this.m_queryProxyId;
        } else {
            this.m_pairBuffer[this.m_pairCount].proxyIdA = this.m_queryProxyId;
            this.m_pairBuffer[this.m_pairCount].proxyIdB = proxyId;
        }
        ++this.m_pairCount;
        return true;
    }
}

