/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.shapes;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Transform;

public final class CircleShape
extends Shape {
    public final Vec2 m_p = new Vec2();

    public CircleShape() {
        super(ShapeType.CIRCLE, 0.0f);
    }

    @Override
    public Shape clone() {
        CircleShape shape = new CircleShape();
        shape.m_p.x = this.m_p.x;
        shape.m_p.y = this.m_p.y;
        shape.setRadius(this.getRadius());
        return shape;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public boolean testPoint(Transform transform, Vec2 p) {
        Rotation q = transform.q;
        Vec2 tp = transform.p;
        float centerx = -(q.c * this.m_p.x - q.s * this.m_p.y + tp.x - p.x);
        float centery = -(q.s * this.m_p.x + q.c * this.m_p.y + tp.y - p.y);
        return centerx * centerx + centery * centery <= this.getRadius() * this.getRadius();
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        Rotation xfq = xf.q;
        float centerx = xfq.c * this.m_p.x - xfq.s * this.m_p.y + xf.p.x;
        float centery = xfq.s * this.m_p.x + xfq.c * this.m_p.y + xf.p.y;
        float dx = p.x - centerx;
        float dy = p.y - centery;
        float d1 = JBoxUtils.sqrt(dx * dx + dy * dy);
        normalOut.x = dx * 1.0f / d1;
        normalOut.y = dy * 1.0f / d1;
        return d1 - this.getRadius();
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform transform, int childIndex) {
        Vec2 inputp1 = input.p1;
        Vec2 inputp2 = input.p2;
        Rotation tq = transform.q;
        Vec2 tp = transform.p;
        float positionx = tq.c * this.m_p.x - tq.s * this.m_p.y + tp.x;
        float sx = inputp1.x - positionx;
        float rx = inputp2.x - inputp1.x;
        float positiony = tq.s * this.m_p.x + tq.c * this.m_p.y + tp.y;
        float sy = inputp1.y - positiony;
        float ry = inputp2.y - inputp1.y;
        float c = sx * rx + sy * ry;
        float rr = rx * rx + ry * ry;
        float b = sx * sx + sy * sy - this.getRadius() * this.getRadius();
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return false;
        }
        float a = -(c + JBoxUtils.sqrt(sigma));
        if (0.0f <= a && a <= input.maxFraction * rr) {
            output.fraction = a /= rr;
            output.normal.x = rx * a + sx;
            output.normal.y = ry * a + sy;
            output.normal.getLengthAndNormalize();
            return true;
        }
        return false;
    }

    @Override
    public void computeAABB(AABB aabb, Transform transform, int childIndex) {
        Rotation tq = transform.q;
        Vec2 tp = transform.p;
        float px = tq.c * this.m_p.x - tq.s * this.m_p.y + tp.x;
        float py = tq.s * this.m_p.x + tq.c * this.m_p.y + tp.y;
        aabb.lowerBound.x = px - this.getRadius();
        aabb.lowerBound.y = py - this.getRadius();
        aabb.upperBound.x = px + this.getRadius();
        aabb.upperBound.y = py + this.getRadius();
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = density * (float)Math.PI * this.getRadius() * this.getRadius();
        massData.center.x = this.m_p.x;
        massData.center.y = this.m_p.y;
        massData.I = massData.mass * (0.5f * this.getRadius() * this.getRadius() + (this.m_p.x * this.m_p.x + this.m_p.y * this.m_p.y));
    }

    public int getSupport(Vec2 d) {
        return 0;
    }

    public Vec2 getSupportVertex(Vec2 d) {
        return this.m_p;
    }

    public int getVertexCount() {
        return 1;
    }

    public Vec2 getVertex(int index) {
        assert (index == 0);
        return this.m_p;
    }
}

