/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.common;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;

public class JBoxUtils {
    public static final float PI = (float)Math.PI;
    public static final float TWOPI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float[] sinLUT = new float[JBoxSettings.SINCOS_LUT_LENGTH];

    public static final float sin(float x) {
        if (JBoxSettings.SINCOS_LUT_ENABLED) {
            return JBoxUtils.sinLUT(x);
        }
        return (float)StrictMath.sin(x);
    }

    public static final float sinLUT(float x) {
        if ((x %= (float)Math.PI * 2) < 0.0f) {
            x += (float)Math.PI * 2;
        }
        if (JBoxSettings.SINCOS_LUT_LERP) {
            int index = (int)(x /= 1.1E-4f);
            if (index != 0) {
                x %= (float)index;
            }
            if (index == JBoxSettings.SINCOS_LUT_LENGTH - 1) {
                return (1.0f - x) * sinLUT[index] + x * sinLUT[0];
            }
            return (1.0f - x) * sinLUT[index] + x * sinLUT[index + 1];
        }
        return sinLUT[JBoxUtils.round(x / 1.1E-4f) % JBoxSettings.SINCOS_LUT_LENGTH];
    }

    public static final float cos(float x) {
        if (JBoxSettings.SINCOS_LUT_ENABLED) {
            return JBoxUtils.sinLUT(1.5707964f - x);
        }
        return (float)StrictMath.cos(x);
    }

    public static final float abs(float x) {
        if (JBoxSettings.FAST_ABS) {
            return x > 0.0f ? x : -x;
        }
        return StrictMath.abs(x);
    }

    public static final int abs(int x) {
        int y = x >> 31;
        return (x ^ y) - y;
    }

    public static final int floor(float x) {
        if (JBoxSettings.FAST_FLOOR) {
            return JBoxUtils.fastFloor(x);
        }
        return (int)StrictMath.floor(x);
    }

    public static final int fastFloor(float x) {
        int y = (int)x;
        if (x < (float)y) {
            return y - 1;
        }
        return y;
    }

    public static final int round(float x) {
        if (JBoxSettings.FAST_ROUND) {
            return JBoxUtils.floor(x + 0.5f);
        }
        return StrictMath.round(x);
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final float map(float val, float fromMin, float fromMax, float toMin, float toMax) {
        float mult = (val - fromMin) / (fromMax - fromMin);
        return toMin + mult * (toMax - toMin);
    }

    public static final float clamp(float a, float low, float high) {
        return JBoxUtils.max(low, JBoxUtils.min(a, high));
    }

    public static final Vec2 clamp(Vec2 a, Vec2 low, Vec2 high) {
        Vec2 min = new Vec2();
        min.x = a.x < high.x ? a.x : high.x;
        min.y = a.y < high.y ? a.y : high.y;
        min.x = low.x > min.x ? low.x : min.x;
        min.y = low.y > min.y ? low.y : min.y;
        return min;
    }

    public static final float atan2(float y, float x) {
        if (JBoxSettings.FAST_ATAN2) {
            return JBoxUtils.fastAtan2(y, x);
        }
        return (float)StrictMath.atan2(y, x);
    }

    public static final float fastAtan2(float y, float x) {
        float atan;
        if (x == 0.0f) {
            if (y > 0.0f) {
                return 1.5707964f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float z = y / x;
        if (JBoxUtils.abs(z) < 1.0f) {
            atan = z / (1.0f + 0.28f * z * z);
            if (x < 0.0f) {
                if (y < 0.0f) {
                    return atan - (float)Math.PI;
                }
                return atan + (float)Math.PI;
            }
        } else {
            atan = 1.5707964f - z / (z * z + 0.28f);
            if (y < 0.0f) {
                return atan - (float)Math.PI;
            }
        }
        return atan;
    }

    public static final float sqrt(float x) {
        return (float)StrictMath.sqrt(x);
    }

    public static final float distanceSquared(Vec2 v1, Vec2 v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        return dx * dx + dy * dy;
    }

    public static final float distance(Vec2 v1, Vec2 v2) {
        return JBoxUtils.sqrt(JBoxUtils.distanceSquared(v1, v2));
    }

    static {
        for (int i = 0; i < JBoxSettings.SINCOS_LUT_LENGTH; ++i) {
            JBoxUtils.sinLUT[i] = (float)Math.sin((float)i * 1.1E-4f);
        }
    }
}

