/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.Filter;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;

public final class Fixture {
    private final Filter filter = new Filter();
    private final Body body;
    private final Shape shape;
    private Object userData;
    private float density;
    private float friction;
    private float restitution;
    private boolean isSensor;
    private FixtureProxy[] proxies;
    private int proxyCount = 0;
    private final AABB pool1 = new AABB();
    private final AABB pool2 = new AABB();
    private final Vec2 displacement = new Vec2();

    Fixture(Body body, FixtureDef def) {
        this.body = body;
        this.shape = def.getShape().clone();
        this.userData = def.getUserData();
        this.density = def.getDensity();
        this.friction = def.getFriction();
        this.restitution = def.getRestitution();
        this.isSensor = def.isSensor();
        this.filter.set(def.getFilter());
        int childCount = this.shape.getChildCount();
        this.proxies = new FixtureProxy[childCount];
        for (int i = 0; i < childCount; ++i) {
            this.proxies[i] = new FixtureProxy();
        }
        if (this.proxies.length < childCount) {
            throw new RuntimeException("BUG Fixture()");
        }
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ShapeType getType() {
        return this.shape.getType();
    }

    public Filter getFilterData() {
        return this.filter;
    }

    public void setFilterData(Filter filter) {
        this.filter.set(filter);
        this.refilter();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float density) {
        this.density = density;
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void setRestitution(float restitution) {
        this.restitution = restitution;
    }

    public boolean isSensor() {
        return this.isSensor;
    }

    public void setSensor(boolean sensor) {
        if (sensor != this.isSensor) {
            this.body.setAwake(true);
            this.isSensor = sensor;
        }
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    public int getProxyId(int index) {
        return this.proxies[index].proxyId;
    }

    public void refilter() {
        ContactEdge edge = this.body.getContactList();
        while (edge != null) {
            Contact contact = edge.contact;
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            if (fixtureA == this || fixtureB == this) {
                contact.flagForFiltering();
            }
            edge = edge.next;
        }
        World world = this.body.getWorld();
        if (world == null) {
            return;
        }
        BroadPhase broadPhase = world.getContactManager().broadPhase;
        for (int i = 0; i < this.proxyCount; ++i) {
            broadPhase.touchProxy(this.proxies[i].proxyId);
        }
    }

    public boolean containsPoint(Vec2 p) {
        return this.shape.testPoint(this.body.m_xf, p);
    }

    public boolean raycast(RayCastOutput output, RayCastInput input, int childIndex) {
        return this.shape.raycast(output, input, this.body.m_xf, childIndex);
    }

    public void getMassData(MassData massData) {
        this.shape.computeMass(massData, this.density);
    }

    public AABB getAABB(int childIndex) {
        return this.proxies[childIndex].aabb;
    }

    public float computeDistance(Vec2 p, int childIndex, Vec2 normalOut) {
        return this.shape.computeDistanceToOut(this.body.getTransform(), p, childIndex, normalOut);
    }

    void createProxies(BroadPhase broadPhase, Transform xf) {
        this.proxyCount = this.shape.getChildCount();
        int i = 0;
        while (i < this.proxyCount) {
            FixtureProxy proxy = this.proxies[i];
            this.shape.computeAABB(proxy.aabb, xf, i);
            proxy.proxyId = broadPhase.createProxy(proxy.aabb, proxy);
            proxy.fixture = this;
            proxy.childIndex = i++;
        }
    }

    void destroyProxies(BroadPhase broadPhase) {
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.proxies[i];
            broadPhase.destroyProxy(proxy.proxyId);
            proxy.proxyId = -1;
        }
        this.proxyCount = 0;
    }

    void synchronize(BroadPhase broadPhase, Transform transform1, Transform transform2) {
        if (this.proxyCount == 0) {
            return;
        }
        for (int i = 0; i < this.proxyCount; ++i) {
            FixtureProxy proxy = this.proxies[i];
            AABB aabb1 = this.pool1;
            AABB aabb2 = this.pool2;
            this.shape.computeAABB(aabb1, transform1, proxy.childIndex);
            this.shape.computeAABB(aabb2, transform2, proxy.childIndex);
            proxy.aabb.combine(aabb1, aabb2);
            this.displacement.x = transform2.p.x - transform1.p.x;
            this.displacement.y = transform2.p.y - transform1.p.y;
            broadPhase.moveProxy(proxy.proxyId, proxy.aabb, this.displacement);
        }
    }

    void destroy() {
        this.proxies = null;
    }

    static class FixtureProxy {
        final AABB aabb = new AABB();
        Fixture fixture = null;
        int proxyId = -1;
        int childIndex;

        private FixtureProxy() {
        }
    }
}

