/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.app.AppStateMachine;
import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.State;
import com.almasb.fxgl.app.listener.StateListener;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.Texture;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0004J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u001aR(\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0005R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/almasb/fxgl/texture/AnimatedTexture;", "Lcom/almasb/fxgl/texture/Texture;", "Lcom/almasb/fxgl/app/listener/StateListener;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "(Lcom/almasb/fxgl/texture/AnimationChannel;)V", "value", "animationChannel", "getAnimationChannel", "()Lcom/almasb/fxgl/texture/AnimationChannel;", "setAnimationChannel", "counter", "", "currentFrame", "", "playingChannel", "", "<set-?>", "started", "getStarted", "()Z", "setStarted", "(Z)V", "state", "Lcom/almasb/fxgl/app/State;", "dispose", "", "onUpdate", "tpf", "playAnimationChannel", "channel", "reset", "start", "stop", "fxgl"})
public final class AnimatedTexture
extends Texture
implements StateListener {
    private int currentFrame;
    private double counter;
    private boolean playingChannel;
    @Nullable
    private AnimationChannel animationChannel;
    private State state;
    private boolean started;

    @Nullable
    public final AnimationChannel getAnimationChannel() {
        return this.animationChannel;
    }

    public final void setAnimationChannel(@Nullable AnimationChannel value) {
        if (this.animationChannel != value && !this.playingChannel) {
            this.reset();
            this.animationChannel = value;
        }
    }

    public final void playAnimationChannel(@NotNull AnimationChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.setAnimationChannel(channel);
        this.playingChannel = true;
    }

    public final boolean getStarted() {
        return this.started;
    }

    private final void setStarted(boolean bl) {
        this.started = bl;
    }

    public final void start(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (this.started) {
            return;
        }
        this.state = state;
        state.addStateListener(this);
        this.started = true;
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        State state = this.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        state.removeStateListener(this);
        this.reset();
        this.started = false;
    }

    @Override
    public void onUpdate(double tpf) {
        block2: {
            AnimationChannel animationChannel = this.animationChannel;
            if (animationChannel == null) break block2;
            AnimationChannel animationChannel2 = animationChannel;
            AnimationChannel it = animationChannel2;
            if (this.counter >= it.getFrameDuration$fxgl()) {
                if (this.currentFrame == it.getSequence$fxgl().size() - 1 && this.playingChannel) {
                    this.playingChannel = false;
                }
                this.currentFrame = (this.currentFrame + 1) % it.getSequence$fxgl().size();
                this.counter = 0.0;
            }
            this.counter += tpf;
            int framesPerRow = it.getFramesPerRow();
            double frameWidth = it.getFrameWidth();
            double frameHeight = it.getFrameHeight();
            int row = ((Number)it.getSequence$fxgl().get(this.currentFrame)).intValue() / framesPerRow;
            int col = ((Number)it.getSequence$fxgl().get(this.currentFrame)).intValue() % framesPerRow;
            this.setImage(it.getImage());
            this.setFitWidth(frameWidth);
            this.setFitHeight(frameHeight);
            this.setViewport(new Rectangle2D((double)col * frameWidth, (double)row * frameHeight, frameWidth, frameHeight));
        }
    }

    private final void reset() {
        this.currentFrame = 0;
        this.counter = 0.0;
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    public AnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkParameterIsNotNull((Object)defaultChannel, (String)"defaultChannel");
        super(defaultChannel.getImage());
        this.setAnimationChannel(defaultChannel);
        this.onUpdate(0.0);
        AppStateMachine appStateMachine = FXGL.Companion.getApp().getStateMachine();
        Intrinsics.checkExpressionValueIsNotNull((Object)appStateMachine, (String)"FXGL.getApp().stateMachine");
        State state = appStateMachine.getPlayState();
        Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"FXGL.getApp().stateMachine.playState");
        this.start(state);
    }
}

