/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.Disposable;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.texture.AnimatedTexture;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Pixel;
import com.almasb.fxgl.texture.Texture;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010'\u001a\u00020)J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0016\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u00103\u001a\u00020\u0000J\b\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u00067"}, d2={"Lcom/almasb/fxgl/texture/Texture;", "Ljavafx/scene/image/ImageView;", "Lcom/almasb/fxgl/core/Disposable;", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;)V", "()V", "height", "", "getHeight", "()D", "width", "getWidth", "blend", "background", "Ljavafx/scene/Node;", "blendMode", "Ljavafx/scene/effect/BlendMode;", "brighter", "copy", "darker", "desaturate", "discolor", "dispose", "", "invert", "multiplyColor", "color", "Ljavafx/scene/paint/Color;", "replaceColor", "oldColor", "newColor", "saturate", "set", "other", "subTexture", "area", "Ljavafx/geometry/Rectangle2D;", "superTexture", "direction", "Ljavafx/geometry/HorizontalDirection;", "Ljavafx/geometry/VerticalDirection;", "toAnimatedTexture", "Lcom/almasb/fxgl/texture/AnimatedTexture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "frames", "", "duration", "Ljavafx/util/Duration;", "toColor", "toGrayscale", "toString", "", "transparentColor", "fxgl"})
public class Texture
extends ImageView
implements Disposable {
    public final double getWidth() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return image.getWidth();
    }

    public final double getHeight() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return image.getHeight();
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(int frames, @NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
        int n = (int)image2.getWidth() / frames;
        Image image3 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image3, (String)"image");
        return this.toAnimatedTexture(new AnimationChannel(image, frames, n, (int)image3.getHeight(), duration, 0, frames - 1));
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkParameterIsNotNull((Object)defaultChannel, (String)"defaultChannel");
        return new AnimatedTexture(defaultChannel);
    }

    @NotNull
    public final Texture copy() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(image);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture subTexture(@NotNull Rectangle2D area) {
        Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
        int minX = (int)area.getMinX();
        int minY = (int)area.getMinY();
        int maxX = (int)area.getMaxX();
        int maxY = (int)area.getMaxY();
        if (minX < 0) {
            throw (Throwable)new IllegalArgumentException("minX value of sub-texture cannot be negative");
        }
        if (minY < 0) {
            throw (Throwable)new IllegalArgumentException("minY value of sub-texture cannot be negative");
        }
        double d = maxX;
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        if (d > image.getWidth()) {
            throw (Throwable)new IllegalArgumentException("maxX value of sub-texture cannot be greater than image width");
        }
        double d2 = maxY;
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
        if (d2 > image2.getHeight()) {
            throw (Throwable)new IllegalArgumentException("maxY value of sub-texture cannot be greater than image height");
        }
        Image image3 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image3, (String)"image");
        PixelReader pixelReader = image3.getPixelReader();
        WritableImage image4 = new WritableImage(maxX - minX, maxY - minY);
        PixelWriter pixelWriter = image4.getPixelWriter();
        int n = minY;
        int n2 = maxY;
        while (n < n2) {
            void y;
            int n3 = minX;
            int n4 = maxX;
            while (n3 < n4) {
                void x;
                Color color = pixelReader.getColor((int)x, (int)y);
                pixelWriter.setColor((int)(x - minX), (int)(y - minY), color);
                ++x;
            }
            ++y;
        }
        return new Texture((Image)image4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull HorizontalDirection direction) {
        Image rightImage;
        Image leftImage;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        if (Intrinsics.areEqual((Object)direction, (Object)HorizontalDirection.LEFT)) {
            Image image = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"other.image");
            leftImage = image;
            Image image2 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"this.image");
            rightImage = image2;
        } else {
            Image image = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"this.image");
            leftImage = image;
            Image image3 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image3, (String)"other.image");
            rightImage = image3;
        }
        int width = (int)(leftImage.getWidth() + rightImage.getWidth());
        int height = (int)Math.max(leftImage.getHeight(), rightImage.getHeight());
        PixelReader leftReader = leftImage.getPixelReader();
        PixelReader rightReader = rightImage.getPixelReader();
        WritableImage image = new WritableImage(width, height);
        PixelWriter pixelWriter = image.getPixelWriter();
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                Color color;
                void x;
                if ((double)x < leftImage.getWidth()) {
                    if ((double)y < leftImage.getHeight()) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)leftReader.getColor((int)x, (int)y), (String)"leftReader.getColor(x, y)");
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)Color.TRANSPARENT, (String)"Color.TRANSPARENT");
                    }
                } else if ((double)y < rightImage.getHeight()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)rightReader.getColor((int)(x - (int)leftImage.getWidth()), (int)y), (String)"rightReader.getColor(x -\u2026ftImage.width.toInt(), y)");
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)Color.TRANSPARENT, (String)"Color.TRANSPARENT");
                }
                pixelWriter.setColor((int)x, (int)y, color);
                ++x;
            }
            ++y;
        }
        return new Texture((Image)image);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull VerticalDirection direction) {
        Image bottomImage;
        Image topImage;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        if (Intrinsics.areEqual((Object)direction, (Object)VerticalDirection.DOWN)) {
            Image image = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"this.image");
            topImage = image;
            Image image2 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"other.image");
            bottomImage = image2;
        } else {
            Image image = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"other.image");
            topImage = image;
            Image image3 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image3, (String)"this.image");
            bottomImage = image3;
        }
        int width = (int)Math.max(topImage.getWidth(), bottomImage.getWidth());
        int height = (int)(topImage.getHeight() + bottomImage.getHeight());
        PixelReader topReader = topImage.getPixelReader();
        PixelReader bottomReader = bottomImage.getPixelReader();
        WritableImage image = new WritableImage(width, height);
        PixelWriter pixelWriter = image.getPixelWriter();
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                Color color;
                void x;
                if ((double)y < topImage.getHeight()) {
                    if ((double)x < topImage.getWidth()) {
                        Intrinsics.checkExpressionValueIsNotNull((Object)topReader.getColor((int)x, (int)y), (String)"topReader.getColor(x, y)");
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)Color.TRANSPARENT, (String)"Color.TRANSPARENT");
                    }
                } else if ((double)x < bottomImage.getWidth()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)bottomReader.getColor((int)x, (int)(y - (int)topImage.getHeight())), (String)"bottomReader.getColor(x,\u2026 topImage.height.toInt())");
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)Color.TRANSPARENT, (String)"Color.TRANSPARENT");
                }
                pixelWriter.setColor((int)x, (int)y, color);
                ++x;
            }
            ++y;
        }
        return new Texture((Image)image);
    }

    @NotNull
    public final Texture toGrayscale() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)toGrayscale.1.INSTANCE)));
    }

    @NotNull
    public final Texture invert() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)invert.1.INSTANCE)));
    }

    @NotNull
    public final Texture brighter() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)brighter.1.INSTANCE)));
    }

    @NotNull
    public final Texture darker() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)darker.1.INSTANCE)));
    }

    @NotNull
    public final Texture saturate() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)saturate.1.INSTANCE)));
    }

    @NotNull
    public final Texture desaturate() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)desaturate.1.INSTANCE)));
    }

    @NotNull
    public final Texture discolor() {
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)discolor.1.INSTANCE)));
    }

    @NotNull
    public final Texture multiplyColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        return new Texture(ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)new Function1<Pixel, Pixel>(color){
            final /* synthetic */ Color $color;

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Color color = Color.color((double)(it.getR() * this.$color.getRed()), (double)(it.getG() * this.$color.getGreen()), (double)(it.getB() * this.$color.getBlue()), (double)(it.getA() * this.$color.getOpacity()));
                Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.color(\n           \u2026* color.opacity\n        )");
                return it.copy(color);
            }
            {
                this.$color = color;
                super(1);
            }
        })));
    }

    @NotNull
    public final Texture toColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Texture discolored = this.discolor();
        Texture colored = discolored.multiplyColor(color);
        discolored.dispose();
        return colored;
    }

    @NotNull
    public final Texture replaceColor(@NotNull Color oldColor, @NotNull Color newColor) {
        Intrinsics.checkParameterIsNotNull((Object)oldColor, (String)"oldColor");
        Intrinsics.checkParameterIsNotNull((Object)newColor, (String)"newColor");
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        Image newImage2 = ImagesKt.map(image, (Function1<? super Pixel, Pixel>)((Function1)new Function1<Pixel, Pixel>(oldColor, newColor){
            final /* synthetic */ Color $oldColor;
            final /* synthetic */ Color $newColor;

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Color c = Intrinsics.areEqual((Object)it.getColor(), (Object)this.$oldColor) ? this.$newColor : it.getColor();
                return it.copy(c);
            }
            {
                this.$oldColor = color;
                this.$newColor = color2;
                super(1);
            }
        }));
        return new Texture(newImage2);
    }

    @NotNull
    public final Texture transparentColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Color color2 = Color.TRANSPARENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"Color.TRANSPARENT");
        return this.replaceColor(color, color2);
    }

    @NotNull
    public final Texture blend(@NotNull Node background, @NotNull BlendMode blendMode) {
        Intrinsics.checkParameterIsNotNull((Object)background, (String)"background");
        Intrinsics.checkParameterIsNotNull((Object)blendMode, (String)"blendMode");
        if (background.getParent() != null) {
            throw (Throwable)new IllegalArgumentException("The blend background must not be attached to a parent.");
        }
        Image image = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"image");
        int w = (int)image.getWidth();
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image2, (String)"image");
        int h = (int)image2.getHeight();
        WritableImage bgImage = new WritableImage(w, h);
        Async.startFX(new Runnable(background, bgImage){
            final /* synthetic */ Node $background;
            final /* synthetic */ WritableImage $bgImage;

            public final void run() {
                SnapshotParameters params = new SnapshotParameters();
                params.setFill((Paint)Color.TRANSPARENT);
                this.$background.snapshot(params, this.$bgImage);
            }
            {
                this.$background = node;
                this.$bgImage = writableImage;
            }
        }).await();
        Image image3 = (Image)bgImage;
        Image image4 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image4, (String)"image");
        return new Texture(ImagesKt.map(image3, image4, ImagesKt.operation(blendMode)));
    }

    public final void set(@NotNull Texture other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        this.setFitWidth(other.getFitWidth());
        this.setFitHeight(other.getFitHeight());
        this.setImage(other.getImage());
    }

    @Override
    public void dispose() {
        this.setImage(null);
    }

    @NotNull
    public String toString() {
        return "Texture [fitWidth=" + this.getFitWidth() + ", fitHeight=" + this.getFitHeight() + ']';
    }

    public Texture(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        super(image);
    }

    protected Texture() {
    }
}

