/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ai.pathfinding;

import com.almasb.fxgl.extra.ai.pathfinding.AStarLogic;
import com.almasb.fxgl.extra.ai.pathfinding.AStarNode;
import com.almasb.fxgl.extra.ai.pathfinding.NodeState;
import com.almasb.fxgl.util.Optional;
import com.almasb.fxgl.util.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AStarGrid {
    private AStarLogic logic = new AStarLogic();
    private AStarNode[][] grid;

    public AStarGrid(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width and height cannot < 1");
        }
        this.grid = new AStarNode[width][height];
        for (int y = 0; y < this.grid[0].length; ++y) {
            for (int x = 0; x < this.grid.length; ++x) {
                this.grid[x][y] = new AStarNode(x, y, NodeState.WALKABLE);
            }
        }
    }

    public final int getWidth() {
        return this.grid.length;
    }

    public final int getHeight() {
        return this.grid[0].length;
    }

    public final boolean isWithin(int x, int y) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight();
    }

    public final void setStateForAllNodes(NodeState state) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.getNode(x, y).setState(state);
            }
        }
    }

    public final void setNodeState(int x, int y, NodeState state) {
        this.getNode(x, y).setState(state);
    }

    public final NodeState getNodeState(int x, int y) {
        return this.getNode(x, y).getState();
    }

    public final List<AStarNode> getPath(int startX, int startY, int targetX, int targetY) {
        return this.logic.getPath(this.grid, this.getNode(startX, startY), this.getNode(targetX, targetY), new AStarNode[0]);
    }

    public final AStarNode getNode(int x, int y) {
        return this.grid[x][y];
    }

    public final AStarNode getRandomNode() {
        int x = (int)(Math.random() * (double)this.getWidth());
        int y = (int)(Math.random() * (double)this.getHeight());
        return this.getNode(x, y);
    }

    public final Optional<AStarNode> getRandomNode(Predicate<AStarNode> predicate) {
        List filtered = this.getNodes().stream().filter(arg_0 -> predicate.test(arg_0)).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return Optional.empty();
        }
        int index = (int)(Math.random() * (double)filtered.size());
        return Optional.of(filtered.get(index));
    }

    public final AStarNode[][] getGrid() {
        return this.grid;
    }

    public final List<AStarNode> getNodes() {
        ArrayList<AStarNode> nodes = new ArrayList<AStarNode>();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                nodes.add(this.getNode(x, y));
            }
        }
        return nodes;
    }
}

