/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ai.pathfinding.maze;

import com.almasb.fxgl.extra.ai.pathfinding.AStarGrid;
import com.almasb.fxgl.extra.ai.pathfinding.AStarNode;
import com.almasb.fxgl.extra.ai.pathfinding.maze.MazeCell;
import com.almasb.fxgl.extra.ai.pathfinding.maze.MazeSolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Maze {
    private final int width;
    private final int height;
    private final int[][] maze;
    private MazeCell[][] mazeCells;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public MazeCell[][] getMaze() {
        return this.mazeCells;
    }

    public MazeCell getMazeCell(int x, int y) {
        return this.mazeCells[x][y];
    }

    public Maze(int width, int height) {
        this.width = width;
        this.height = height;
        this.maze = new int[width][height];
        this.mazeCells = new MazeCell[width][height];
        this.generateMaze(0, 0);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                MazeCell cell2 = new MazeCell(j, i);
                if ((this.maze[j][i] & 1) == 0) {
                    cell2.setTopWall(true);
                }
                if ((this.maze[j][i] & 8) == 0) {
                    cell2.setLeftWall(true);
                }
                this.mazeCells[j][i] = cell2;
            }
        }
    }

    public List<MazeCell> getPath(int startX, int startY, int targetX, int targetY) {
        AStarGrid grid = new AStarGrid(this.width, this.height);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                grid.getNode(x, y).setUserData(this.getMazeCell(x, y));
            }
        }
        return new MazeSolver().getPath(grid.getGrid(), grid.getNode(startX, startY), grid.getNode(targetX, targetY), new AStarNode[0]).stream().map(node -> (MazeCell)node.getUserData()).collect(Collectors.toList());
    }

    private void generateMaze(int cx, int cy) {
        DIR[] dirs = DIR.values();
        Collections.shuffle(Arrays.asList(dirs));
        for (DIR dir : dirs) {
            int nx = cx + dir.dx;
            int ny = cy + dir.dy;
            if (!Maze.between(nx, this.width) || !Maze.between(ny, this.height) || this.maze[nx][ny] != 0) continue;
            int[] nArray = this.maze[cx];
            int n = cy;
            nArray[n] = nArray[n] | dir.bit;
            int[] nArray2 = this.maze[nx];
            int n2 = ny;
            nArray2[n2] = nArray2[n2] | dir.opposite.bit;
            this.generateMaze(nx, ny);
        }
    }

    private static boolean between(int v, int upper) {
        return v >= 0 && v < upper;
    }

    private static enum DIR {
        N(1, 0, -1),
        S(2, 0, 1),
        E(4, 1, 0),
        W(8, -1, 0);

        private final int bit;
        private final int dx;
        private final int dy;
        private DIR opposite;

        private DIR(int bit, int dx, int dy) {
            this.bit = bit;
            this.dx = dx;
            this.dy = dy;
        }

        static {
            DIR.N.opposite = S;
            DIR.S.opposite = N;
            DIR.E.opposite = W;
            DIR.W.opposite = E;
        }
    }
}

