/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.entity.state;

import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.extra.entity.state.State;

public abstract class StateComponent
extends Component {
    private boolean allowStateReentrance = false;
    private State state;

    public StateComponent(State state) {
        this.state = state;
    }

    public StateComponent() {
    }

    public boolean isAllowStateReentrance() {
        return this.allowStateReentrance;
    }

    public void setAllowStateReentrance(boolean allowStateReentrance) {
        this.allowStateReentrance = allowStateReentrance;
    }

    protected void preUpdate(double tpf) {
    }

    public final void onUpdate(double tpf) {
        this.preUpdate(tpf);
        this.state.onUpdate(tpf);
    }

    public final void setState(State state) {
        if (!this.allowStateReentrance && this.getState() == state) {
            return;
        }
        State prevState = this.state;
        if (prevState != null) {
            prevState.onExit();
        }
        this.state = state;
        this.state.onEnter(prevState);
    }

    public final State getState() {
        return this.state;
    }
}

