/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ai.goap;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.entity.components.PositionComponent;
import com.almasb.fxgl.extra.ai.goap.FSM;
import com.almasb.fxgl.extra.ai.goap.FSMState;
import com.almasb.fxgl.extra.ai.goap.GoapAction;
import com.almasb.fxgl.extra.ai.goap.GoapAgent;
import com.almasb.fxgl.extra.ai.goap.GoapPlanner;
import com.almasb.fxgl.extra.ai.goap.State;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Required(value=PositionComponent.class)
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bJ\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\b0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/almasb/fxgl/extra/ai/goap/GoapControl;", "Lcom/almasb/fxgl/entity/component/Component;", "agent", "Lcom/almasb/fxgl/extra/ai/goap/GoapAgent;", "moveSpeed", "", "actions", "", "Lcom/almasb/fxgl/extra/ai/goap/GoapAction;", "(Lcom/almasb/fxgl/extra/ai/goap/GoapAgent;DLjava/util/Set;)V", "availableActions", "Ljava/util/HashSet;", "kotlin.jvm.PlatformType", "currentActions", "Ljava/util/Queue;", "idleState", "Lcom/almasb/fxgl/extra/ai/goap/FSMState;", "moveToState", "performActionState", "position", "Lcom/almasb/fxgl/entity/components/PositionComponent;", "stateMachine", "Lcom/almasb/fxgl/extra/ai/goap/FSM;", "tpf", "addAction", "", "action", "createIdleState", "createMoveToState", "createPerformActionState", "hasActionPlan", "", "moveAgent", "nextAction", "onUpdate", "removeAction", "fxgl"})
public final class GoapControl
extends Component {
    private final FSM stateMachine;
    private final FSMState idleState;
    private final FSMState moveToState;
    private final FSMState performActionState;
    private final HashSet<GoapAction> availableActions;
    private Queue<GoapAction> currentActions;
    private PositionComponent position;
    private double tpf;
    private final GoapAgent agent;
    private final double moveSpeed;

    public void onUpdate(double tpf) {
        this.tpf = tpf;
        Entity entity = this.entity;
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"entity");
        this.stateMachine.update(entity);
    }

    public final void addAction(@NotNull GoapAction action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.availableActions.add(action);
    }

    public final void removeAction(@NotNull GoapAction action) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        this.availableActions.remove(action);
    }

    private final boolean hasActionPlan() {
        Collection collection = this.currentActions;
        return !collection.isEmpty();
    }

    private final boolean moveAgent(GoapAction nextAction) {
        if (nextAction.getTarget() == null) {
            throw (Throwable)new IllegalArgumentException("GoapAction: " + nextAction + " has no target");
        }
        Entity entity = nextAction.getTarget();
        if (entity == null) {
            Intrinsics.throwNpe();
        }
        PositionComponent positionComponent = (PositionComponent)entity.getComponent(PositionComponent.class);
        if (positionComponent == null) {
            throw (Throwable)new IllegalArgumentException("GoapAction: " + nextAction + " has target without PositionComponent");
        }
        PositionComponent targetPosition = positionComponent;
        double moveDistance = this.moveSpeed * this.tpf;
        PositionComponent positionComponent2 = this.position;
        if (positionComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        if (positionComponent2.distance(targetPosition) >= moveDistance) {
            PositionComponent positionComponent3 = this.position;
            if (positionComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"position");
            }
            Point2D point2D = targetPosition.getValue();
            PositionComponent positionComponent4 = this.position;
            if (positionComponent4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"position");
            }
            positionComponent3.translate(point2D.subtract(positionComponent4.getValue()).normalize().multiply(moveDistance));
            return false;
        }
        nextAction.setInRange(true);
        return true;
    }

    private final FSMState createIdleState() {
        return new FSMState(this){
            final /* synthetic */ GoapControl this$0;

            public void update(@NotNull FSM fsm, @NotNull Entity entity) {
                Intrinsics.checkParameterIsNotNull((Object)fsm, (String)"fsm");
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                State worldState = GoapControl.access$getAgent$p(this.this$0).obtainWorldState(entity);
                State goal = GoapControl.access$getAgent$p(this.this$0).createGoalState(entity);
                Queue<GoapAction> plan = GoapPlanner.INSTANCE.plan(entity, GoapControl.access$getAvailableActions$p(this.this$0), worldState, goal);
                if (!plan.isEmpty()) {
                    GoapControl.access$setCurrentActions$p(this.this$0, plan);
                    GoapControl.access$getAgent$p(this.this$0).planFound(entity, goal, plan);
                    fsm.popState();
                    fsm.pushState(GoapControl.access$getPerformActionState$p(this.this$0));
                } else {
                    GoapControl.access$getAgent$p(this.this$0).planFailed(entity, goal);
                    fsm.popState();
                    fsm.pushState(GoapControl.access$getIdleState$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final FSMState createMoveToState() {
        return new FSMState(this){
            final /* synthetic */ GoapControl this$0;

            public void update(@NotNull FSM fsm, @NotNull Entity entity) {
                Intrinsics.checkParameterIsNotNull((Object)fsm, (String)"fsm");
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                GoapAction action = (GoapAction)GoapControl.access$getCurrentActions$p(this.this$0).peek();
                if (action.requiresInRange() && action.getTarget() == null) {
                    fsm.popState();
                    fsm.popState();
                    fsm.pushState(GoapControl.access$getIdleState$p(this.this$0));
                    return;
                }
                GoapAction goapAction = action;
                Intrinsics.checkExpressionValueIsNotNull((Object)goapAction, (String)"action");
                if (GoapControl.access$moveAgent(this.this$0, goapAction)) {
                    fsm.popState();
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    private final FSMState createPerformActionState() {
        return new FSMState(this){
            final /* synthetic */ GoapControl this$0;

            public void update(@NotNull FSM fsm, @NotNull Entity entity) {
                Intrinsics.checkParameterIsNotNull((Object)fsm, (String)"fsm");
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                if (!GoapControl.access$hasActionPlan(this.this$0)) {
                    fsm.popState();
                    fsm.pushState(GoapControl.access$getIdleState$p(this.this$0));
                    GoapControl.access$getAgent$p(this.this$0).actionsFinished(entity);
                    return;
                }
                GoapAction action = (GoapAction)GoapControl.access$getCurrentActions$p(this.this$0).peek();
                if (action.isDone()) {
                    GoapControl.access$getCurrentActions$p(this.this$0).remove();
                }
                if (GoapControl.access$hasActionPlan(this.this$0)) {
                    boolean inRange;
                    action = (GoapAction)GoapControl.access$getCurrentActions$p(this.this$0).peek();
                    boolean bl = inRange = action.requiresInRange() ? action.isInRange() : true;
                    if (inRange) {
                        boolean success = action.perform(entity);
                        if (!success) {
                            fsm.popState();
                            fsm.pushState(GoapControl.access$getIdleState$p(this.this$0));
                            GoapAgent goapAgent = GoapControl.access$getAgent$p(this.this$0);
                            GoapAction goapAction = action;
                            Intrinsics.checkExpressionValueIsNotNull((Object)goapAction, (String)"action");
                            goapAgent.planAborted(entity, goapAction);
                        }
                    } else {
                        fsm.pushState(GoapControl.access$getMoveToState$p(this.this$0));
                    }
                } else {
                    fsm.popState();
                    fsm.pushState(GoapControl.access$getIdleState$p(this.this$0));
                    GoapControl.access$getAgent$p(this.this$0).actionsFinished(entity);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public GoapControl(@NotNull GoapAgent agent, double moveSpeed, @NotNull Set<? extends GoapAction> actions) {
        Intrinsics.checkParameterIsNotNull((Object)agent, (String)"agent");
        Intrinsics.checkParameterIsNotNull(actions, (String)"actions");
        this.agent = agent;
        this.moveSpeed = moveSpeed;
        this.stateMachine = new FSM();
        this.availableActions = new HashSet(actions);
        this.currentActions = new ArrayDeque();
        this.idleState = this.createIdleState();
        this.moveToState = this.createMoveToState();
        this.performActionState = this.createPerformActionState();
        this.stateMachine.pushState(this.idleState);
    }

    @NotNull
    public static final /* synthetic */ GoapAgent access$getAgent$p(GoapControl $this) {
        return $this.agent;
    }

    @NotNull
    public static final /* synthetic */ HashSet access$getAvailableActions$p(GoapControl $this) {
        return $this.availableActions;
    }

    @NotNull
    public static final /* synthetic */ Queue access$getCurrentActions$p(GoapControl $this) {
        return $this.currentActions;
    }

    public static final /* synthetic */ void access$setCurrentActions$p(GoapControl $this, @NotNull Queue queue) {
        $this.currentActions = queue;
    }

    @NotNull
    public static final /* synthetic */ FSMState access$getPerformActionState$p(GoapControl $this) {
        return $this.performActionState;
    }

    @NotNull
    public static final /* synthetic */ FSMState access$getIdleState$p(GoapControl $this) {
        return $this.idleState;
    }

    public static final /* synthetic */ boolean access$moveAgent(GoapControl $this, @NotNull GoapAction nextAction) {
        return $this.moveAgent(nextAction);
    }

    public static final /* synthetic */ boolean access$hasActionPlan(GoapControl $this) {
        return $this.hasActionPlan();
    }

    @NotNull
    public static final /* synthetic */ FSMState access$getMoveToState$p(GoapControl $this) {
        return $this.moveToState;
    }
}

