/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ai.pathfinding;

import com.almasb.fxgl.extra.ai.pathfinding.AStarNode;
import com.almasb.fxgl.extra.ai.pathfinding.NodeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AStarLogic {
    public final List<AStarNode> getPath(AStarNode[][] grid, AStarNode start, AStarNode target, AStarNode ... busyNodes) {
        if (target.getState() == NodeState.NOT_WALKABLE) {
            return Collections.emptyList();
        }
        for (int y = 0; y < grid[0].length; ++y) {
            for (int x = 0; x < grid.length; ++x) {
                grid[x][y].setHCost(Math.abs(target.getX() - x) + Math.abs(target.getY() - y));
            }
        }
        ArrayList<AStarNode> open = new ArrayList<AStarNode>();
        ArrayList<AStarNode> closed = new ArrayList<AStarNode>();
        AStarNode current = start;
        boolean found = false;
        while (!found && !closed.contains(target)) {
            for (AStarNode neighbor : this.getValidNeighbors(current, grid, busyNodes)) {
                if (neighbor == target) {
                    target.setParent(current);
                    found = true;
                    closed.add(target);
                    break;
                }
                if (closed.contains(neighbor)) continue;
                if (open.contains(neighbor)) {
                    int newG = current.getGCost() + 10;
                    if (newG >= neighbor.getGCost()) continue;
                    neighbor.setParent(current);
                    neighbor.setGCost(newG);
                    continue;
                }
                neighbor.setParent(current);
                neighbor.setGCost(current.getGCost() + 10);
                open.add(neighbor);
            }
            if (found) continue;
            closed.add(current);
            open.remove(current);
            if (open.isEmpty()) {
                return Collections.emptyList();
            }
            AStarNode acc = (AStarNode)open.get(0);
            for (AStarNode a : open) {
                acc = a.getFCost() < acc.getFCost() ? a : acc;
            }
            current = acc;
        }
        return this.buildPath(start, target);
    }

    private List<AStarNode> buildPath(AStarNode start, AStarNode target) {
        ArrayList<AStarNode> path = new ArrayList<AStarNode>();
        AStarNode tmp = target;
        do {
            path.add(tmp);
        } while ((tmp = tmp.getParent()) != start);
        Collections.reverse(path);
        return path;
    }

    protected List<AStarNode> getValidNeighbors(AStarNode node, AStarNode[][] grid, AStarNode ... busyNodes) {
        int x = node.getX();
        int y = node.getY();
        int[] points = new int[]{x - 1, y, x + 1, y, x, y - 1, x, y + 1};
        ArrayList<AStarNode> result = new ArrayList<AStarNode>();
        for (int i = 0; i < points.length; ++i) {
            int x1 = points[i];
            int y1 = points[++i];
            if (x1 < 0 || x1 >= grid.length || y1 < 0 || y1 >= grid[0].length || grid[x1][y1].getState() != NodeState.WALKABLE || this.contains(x1, y1, busyNodes)) continue;
            result.add(grid[x1][y1]);
        }
        return result;
    }

    private boolean contains(int x, int y, AStarNode ... nodes) {
        for (AStarNode n : nodes) {
            if (n.getX() != x || n.getY() != y) continue;
            return true;
        }
        return false;
    }
}

