/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.entity.components;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.time.TimerAction;
import javafx.util.Duration;

public class ExpireCleanComponent
extends Component {
    private Duration expire;
    private boolean animate = false;
    private TimerAction timerAction;
    private double time = 0.0;

    public ExpireCleanComponent(Duration expire) {
        this.expire = expire;
    }

    public void onAdded() {
        this.entity.activeProperty().addListener((observable, oldValue, isActive) -> {
            if (isActive.booleanValue()) {
                this.timerAction = FXGL.getMasterTimer().runOnceAfter(() -> ((Entity)this.entity).removeFromWorld(), this.expire);
            } else {
                this.timerAction.expire();
            }
        });
    }

    public void onUpdate(double tpf) {
        if (this.timerAction == null) {
            this.timerAction = FXGL.getMasterTimer().runOnceAfter(() -> ((Entity)this.entity).removeFromWorld(), this.expire);
        } else if (this.animate) {
            this.updateOpacity(tpf);
        }
    }

    private void updateOpacity(double tpf) {
        this.time += tpf;
        this.getEntity().getView().setOpacity(this.time >= this.expire.toSeconds() ? 0.0 : 1.0 - this.time / this.expire.toSeconds());
    }

    public ExpireCleanComponent animateOpacity() {
        this.animate = true;
        return this;
    }
}

