/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.scene.menu;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.menu.MenuType;
import com.almasb.fxgl.util.Supplier;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class GTAVMenu
extends FXGLMenu {
    private VBox vbox = new VBox(50.0);
    private Node menuBody;

    public GTAVMenu(GameApplication app, MenuType type) {
        super(app, type);
        this.menuBody = type == MenuType.MAIN_MENU ? this.createMenuBodyMainMenu() : this.createMenuBodyGameMenu();
        this.vbox.getChildren().addAll((Object[])new Node[]{new Pane(), new Pane()});
        this.vbox.setTranslateX(50.0);
        this.vbox.setTranslateY(50.0);
        this.contentRoot.setTranslateX(280.0);
        this.contentRoot.setTranslateY(130.0);
        this.menuRoot.getChildren().add((Object)this.vbox);
        this.contentRoot.getChildren().add((Object)this.EMPTY);
        this.vbox.getChildren().set(0, (Object)this.makeMenuBar());
        this.activeProperty().addListener((observable, wasActive, isActive) -> {
            if (!isActive.booleanValue()) {
                this.switchMenuTo(this.menuBody);
                this.switchMenuContentTo((Node)this.EMPTY);
            }
        });
    }

    protected Node createBackground(double width, double height) {
        return new Rectangle((double)this.app.getWidth(), (double)this.app.getHeight(), (Paint)Color.BROWN);
    }

    protected Node createTitleView(String title) {
        Text titleView = FXGL.getUIFactory().newText(this.app.getSettings().getTitle(), 18.0);
        titleView.setTranslateY(30.0);
        return titleView;
    }

    protected Node createVersionView(String version) {
        Text view = FXGL.getUIFactory().newText(version, 16.0);
        view.setTranslateX((double)this.app.getWidth() - view.getLayoutBounds().getWidth());
        view.setTranslateY(20.0);
        return view;
    }

    protected Node createProfileView(String profileName) {
        Text view = FXGL.getUIFactory().newText(profileName, 24.0);
        view.setTranslateX((double)this.app.getWidth() - view.getLayoutBounds().getWidth());
        view.setTranslateY(50.0);
        return view;
    }

    protected void switchMenuTo(Node menuBox) {
        this.vbox.getChildren().set(1, (Object)menuBox);
    }

    protected void switchMenuContentTo(Node content) {
        this.contentRoot.getChildren().set(0, (Object)content);
    }

    private HBox makeMenuBar() {
        ToggleButton tb1 = new ToggleButton("MAIN MENU");
        ToggleButton tb2 = new ToggleButton("OPTIONS");
        ToggleButton tb3 = new ToggleButton("EXTRA");
        tb1.textProperty().bind((ObservableValue)FXGL.localizedStringProperty((String)"menu.mainMenu"));
        tb2.textProperty().bind((ObservableValue)FXGL.localizedStringProperty((String)"menu.options"));
        tb3.textProperty().bind((ObservableValue)FXGL.localizedStringProperty((String)"menu.extra"));
        tb1.setFont(FXGL.getUIFactory().newFont(18.0));
        tb2.setFont(FXGL.getUIFactory().newFont(18.0));
        tb3.setFont(FXGL.getUIFactory().newFont(18.0));
        ToggleGroup group = new ToggleGroup();
        tb1.setToggleGroup(group);
        tb2.setToggleGroup(group);
        tb3.setToggleGroup(group);
        tb1.setUserData((Object)this.menuBody);
        tb2.setUserData((Object)this.makeOptionsMenu());
        tb3.setUserData((Object)this.makeExtraMenu());
        group.selectedToggleProperty().addListener((obs, old, newToggle) -> {
            if (newToggle == null) {
                group.selectToggle(old);
                return;
            }
            this.switchMenuTo((Node)newToggle.getUserData());
        });
        group.selectToggle((Toggle)tb1);
        HBox hbox = new HBox(10.0, new Node[]{tb1, tb2, tb3});
        hbox.setAlignment(Pos.TOP_CENTER);
        return hbox;
    }

    private VBox createMenuBodyMainMenu() {
        Button btnContinue = this.createActionButton(FXGL.localizedStringProperty((String)"menu.continue"), () -> ((GTAVMenu)this).fireContinue());
        Button btnNew = this.createActionButton(FXGL.localizedStringProperty((String)"menu.newGame"), () -> ((GTAVMenu)this).fireNewGame());
        Button btnLoad = this.createContentButton(FXGL.localizedStringProperty((String)"menu.load"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentLoad()));
        Button btnLogout = this.createActionButton(FXGL.localizedStringProperty((String)"menu.logout"), () -> ((GTAVMenu)this).fireLogout());
        Button btnExit = this.createActionButton(FXGL.localizedStringProperty((String)"menu.exit"), () -> ((GTAVMenu)this).fireExit());
        btnContinue.disableProperty().bind((ObservableValue)this.listener.hasSavesProperty().not());
        return new VBox(10.0, new Node[]{btnContinue, btnNew, btnLoad, btnLogout, btnExit});
    }

    private VBox createMenuBodyGameMenu() {
        Button btnResume = this.createActionButton(FXGL.localizedStringProperty((String)"menu.resume"), () -> ((GTAVMenu)this).fireResume());
        Button btnSave = this.createActionButton(FXGL.localizedStringProperty((String)"menu.save"), () -> ((GTAVMenu)this).fireSave());
        Button btnLoad = this.createContentButton(FXGL.localizedStringProperty((String)"menu.load"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentLoad()));
        Button btnExit = this.createActionButton(FXGL.localizedStringProperty((String)"menu.exit"), () -> ((GTAVMenu)this).fireExitToMainMenu());
        return new VBox(10.0, new Node[]{btnResume, btnSave, btnLoad, btnExit});
    }

    private VBox makeOptionsMenu() {
        Button btnGameplay = this.createContentButton(FXGL.localizedStringProperty((String)"menu.gameplay"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentGameplay()));
        Button btnControls = this.createContentButton(FXGL.localizedStringProperty((String)"menu.controls"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentControls()));
        Button btnVideo = this.createContentButton(FXGL.localizedStringProperty((String)"menu.video"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentVideo()));
        Button btnAudio = this.createContentButton(FXGL.localizedStringProperty((String)"menu.audio"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentAudio()));
        return new VBox(10.0, new Node[]{btnGameplay, btnControls, btnVideo, btnAudio});
    }

    private VBox makeExtraMenu() {
        Button btnCredits = this.createContentButton(FXGL.localizedStringProperty((String)"menu.credits"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentCredits()));
        Button btnTrophies = this.createContentButton(FXGL.localizedStringProperty((String)"menu.trophies"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((GTAVMenu)this).createContentAchievements()));
        return new VBox(10.0, new Node[]{btnCredits, btnTrophies});
    }

    protected final Button createActionButton(String name, Runnable action) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setOnAction(e -> action.run());
        return btn;
    }

    protected final Button createActionButton(StringBinding name, Runnable action) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setOnAction(e -> action.run());
        return btn;
    }

    protected final Button createContentButton(String name, Supplier<FXGLMenu.MenuContent> contentSupplier) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setUserData(contentSupplier);
        btn.setOnAction(e -> this.switchMenuContentTo((Node)((Supplier)btn.getUserData()).get()));
        return btn;
    }

    protected final Button createContentButton(StringBinding name, Supplier<FXGLMenu.MenuContent> contentSupplier) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setUserData(contentSupplier);
        btn.setOnAction(e -> this.switchMenuContentTo((Node)((Supplier)btn.getUserData()).get()));
        return btn;
    }
}

