/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.entity.action;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.extra.entity.action.Action;
import com.almasb.fxgl.util.Optional;
import java.util.ArrayDeque;
import java.util.Deque;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ActionComponent<T extends Entity>
extends Component {
    private Deque<Action<T>> actions = new ArrayDeque<Action<T>>();
    private ObservableList<Action<T>> actionsObservable = FXCollections.observableArrayList();
    private Action<T> currentAction = null;
    private T thisEntity = null;

    public void onAdded() {
        this.thisEntity = this.entity;
    }

    public void onUpdate(double tpf) {
        this.updateActions(tpf);
    }

    public void onRemoved() {
        this.clearActions();
        this.thisEntity = null;
    }

    private void updateActions(double tpf) {
        if (this.currentAction != null) {
            if (this.currentAction.isComplete()) {
                this.removeCurrentAction();
            } else {
                this.currentAction.onUpdate(this.thisEntity, tpf);
            }
        } else if (this.hasNextActions()) {
            this.currentAction = this.actions.pollFirst();
            this.currentAction.setEntity(this.thisEntity);
        }
    }

    public ObservableList<Action<T>> actionsProperty() {
        return FXCollections.unmodifiableObservableList(this.actionsObservable);
    }

    public boolean hasNextActions() {
        return !this.actions.isEmpty();
    }

    public void addAction(Action action) {
        this.actions.add(action);
        this.actionsObservable.add((Object)action);
    }

    public void removeCurrentAction() {
        if (this.currentAction != null) {
            this.actionsObservable.remove(this.currentAction);
            this.currentAction.setEntity(null);
            this.currentAction = null;
        }
    }

    public void removeLastAction() {
        Action<T> a = this.actions.pollLast();
        if (a != null) {
            this.actionsObservable.remove(a);
        }
    }

    public void removeAction(Action action) {
        if (action == this.currentAction) {
            this.removeCurrentAction();
        } else {
            this.actions.remove(action);
            this.actionsObservable.remove((Object)action);
        }
    }

    public void clearActions() {
        this.removeCurrentAction();
        this.actions.clear();
        this.actionsObservable.clear();
    }

    public Optional<Action<T>> getCurrentAction() {
        return Optional.ofNullable(this.currentAction);
    }

    public Optional<Action<T>> getNextAction() {
        return Optional.ofNullable(this.actions.peekFirst());
    }

    public Optional<Action<T>> getLastAction() {
        return Optional.ofNullable(this.actions.peekLast());
    }
}

