/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.scene.menu;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.scene.FXGLMenu;
import com.almasb.fxgl.scene.menu.MenuType;
import com.almasb.fxgl.util.Supplier;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class CCTRMenu
extends FXGLMenu {
    public CCTRMenu(GameApplication app, MenuType type) {
        super(app, type);
        Node menuBody = type == MenuType.MAIN_MENU ? this.createMenuBodyMainMenu() : this.createMenuBodyGameMenu();
        this.contentRoot.setTranslateX((double)(app.getWidth() / 2 - 50));
        this.contentRoot.setTranslateY((double)(app.getHeight() / 2 - 100));
        this.menuRoot.getChildren().add((Object)menuBody);
        this.contentRoot.getChildren().add((Object)this.EMPTY);
        this.activeProperty().addListener((observable, wasActive, isActive) -> {
            if (!isActive.booleanValue()) {
                this.switchMenuTo(menuBody);
                this.switchMenuContentTo((Node)this.EMPTY);
            }
        });
    }

    protected Node createBackground(double width, double height) {
        return new Rectangle(width, height, (Paint)Color.BLUEVIOLET);
    }

    protected Node createTitleView(String title) {
        Text titleView = FXGL.getUIFactory().newText(this.app.getSettings().getTitle(), 18.0);
        titleView.setTranslateY(30.0);
        return titleView;
    }

    protected Node createVersionView(String version) {
        Text view = FXGL.getUIFactory().newText(version, 16.0);
        view.setTranslateX((double)this.app.getWidth() - view.getLayoutBounds().getWidth());
        view.setTranslateY(20.0);
        return view;
    }

    protected Node createProfileView(String profileName) {
        Text view = FXGL.getUIFactory().newText(profileName, 24.0);
        view.setTranslateX((double)this.app.getWidth() - view.getLayoutBounds().getWidth());
        view.setTranslateY(50.0);
        return view;
    }

    protected Node createMenuBodyMainMenu() {
        double midY = this.app.getHeight() / 2;
        double distance = midY - 50.0;
        Button btnContinue = this.createActionButton(FXGL.localizedStringProperty((String)"menu.continue"), () -> ((CCTRMenu)this).fireContinue());
        Button btn1 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.newGame"), () -> ((CCTRMenu)this).fireNewGame());
        Button btn2 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.load"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentLoad()));
        Button btn3 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.options"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> new FXGLMenu.MenuContent(new Node[]{this.makeOptionsMenu()})));
        Button btn4 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.extra"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> new FXGLMenu.MenuContent(new Node[]{this.makeExtraMenu()})));
        Button btn5 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.online"), () -> ((CCTRMenu)this).fireMultiplayer());
        Button btn6 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.logout"), () -> ((CCTRMenu)this).fireLogout());
        Button btn7 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.exit"), () -> ((CCTRMenu)this).fireExit());
        Group group = new Group(new Node[]{btnContinue, btn1, btn2, btn3, btn4, btn5, btn6, btn7});
        double dtheta = Math.PI / (double)(group.getChildren().size() - 1);
        double angle = 1.5707963267948966;
        int i = 0;
        for (Node n : group.getChildren()) {
            Point2D vector = new Point2D(Math.cos(angle), -Math.sin(angle)).normalize().multiply(distance).add(0.0, midY);
            n.setTranslateX(vector.getX() - (double)(i == 0 || i == 7 ? 0 : 100));
            n.setTranslateY(vector.getY());
            angle -= dtheta;
            if (i == 0 || i == group.getChildren().size() - 2) {
                angle -= dtheta / 2.0;
            } else if (i == 2 || i == 4) {
                angle += dtheta / 4.0;
            } else if (i == 3) {
                angle += dtheta / 2.0;
            }
            ++i;
        }
        btnContinue.disableProperty().bind((ObservableValue)this.listener.hasSavesProperty().not());
        return group;
    }

    protected Node createMenuBodyGameMenu() {
        double midY = this.app.getHeight() / 2;
        double distance = midY - 50.0;
        Button btnContinue = this.createActionButton(FXGL.localizedStringProperty((String)"menu.resume"), () -> ((CCTRMenu)this).fireResume());
        Button btn1 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.save"), () -> ((CCTRMenu)this).fireSave());
        Button btn2 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.load"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentLoad()));
        Button btn3 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.options"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> new FXGLMenu.MenuContent(new Node[]{this.makeOptionsMenu()})));
        Button btn4 = this.createContentButton(FXGL.localizedStringProperty((String)"menu.extra"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> new FXGLMenu.MenuContent(new Node[]{this.makeExtraMenu()})));
        Button btn5 = this.createActionButton(FXGL.localizedStringProperty((String)"menu.mainMenu"), () -> ((CCTRMenu)this).fireExitToMainMenu());
        Group group = new Group(new Node[]{btnContinue, btn1, btn2, btn3, btn4, btn5});
        double dtheta = Math.PI / (double)(group.getChildren().size() - 1);
        double angle = 1.5707963267948966;
        int i = 0;
        for (Node n : group.getChildren()) {
            Point2D vector = new Point2D(Math.cos(angle), -Math.sin(angle)).normalize().multiply(distance).add(0.0, midY);
            n.setTranslateX(vector.getX() - (double)(i == 0 || i == 5 ? 0 : 100));
            n.setTranslateY(vector.getY());
            angle -= dtheta;
            ++i;
        }
        return group;
    }

    private VBox makeOptionsMenu() {
        Button btnGameplay = this.createContentButton(FXGL.localizedStringProperty((String)"menu.gameplay"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentGameplay()));
        Button btnControls = this.createContentButton(FXGL.localizedStringProperty((String)"menu.controls"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentControls()));
        Button btnVideo = this.createContentButton(FXGL.localizedStringProperty((String)"menu.video"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentVideo()));
        Button btnAudio = this.createContentButton(FXGL.localizedStringProperty((String)"menu.audio"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentAudio()));
        return new VBox(10.0, new Node[]{btnGameplay, btnControls, btnVideo, btnAudio});
    }

    private VBox makeExtraMenu() {
        Button btnCredits = this.createContentButton(FXGL.localizedStringProperty((String)"menu.credits"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentCredits()));
        Button btnTrophies = this.createContentButton(FXGL.localizedStringProperty((String)"menu.trophies"), (Supplier<FXGLMenu.MenuContent>)((Supplier)() -> ((CCTRMenu)this).createContentAchievements()));
        return new VBox(10.0, new Node[]{btnCredits, btnTrophies});
    }

    protected void switchMenuContentTo(Node content) {
        this.contentRoot.getChildren().set(0, (Object)content);
    }

    protected final Button createActionButton(String name, Runnable action) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setOnAction(e -> action.run());
        return btn;
    }

    protected final Button createActionButton(StringBinding name, Runnable action) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setOnAction(e -> action.run());
        return btn;
    }

    protected final Button createContentButton(String name, Supplier<FXGLMenu.MenuContent> contentSupplier) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setUserData(contentSupplier);
        btn.setOnAction(e -> this.switchMenuContentTo((Node)((Supplier)btn.getUserData()).get()));
        return btn;
    }

    protected final Button createContentButton(StringBinding name, Supplier<FXGLMenu.MenuContent> contentSupplier) {
        Button btn = FXGL.getUIFactory().newButton(name);
        btn.setUserData(contentSupplier);
        btn.setOnAction(e -> this.switchMenuContentTo((Node)((Supplier)btn.getUserData()).get()));
        return btn;
    }
}

