/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.algorithm;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.logging.Logger;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.extra.algorithm.voronoi.GraphEdge;
import com.almasb.fxgl.extra.algorithm.voronoi.Voronoi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.Polygon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0002J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002J,\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001b2\u0006\u0010!\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/extra/algorithm/VoronoiSubdivision;", "", "()V", "DUMMY_EDGE", "Lcom/almasb/fxgl/extra/algorithm/voronoi/GraphEdge;", "EDGE_TOLERANCE", "", "bbox", "Ljavafx/geometry/Rectangle2D;", "corners", "", "Ljavafx/geometry/Point2D;", "log", "Lcom/almasb/fxgl/core/logging/Logger;", "divide", "Lcom/almasb/fxgl/core/collection/Array;", "Ljavafx/scene/shape/Polygon;", "rect", "numSamplePoints", "", "minDistance", "makePolygon", "site", "Lcom/almasb/fxgl/extra/algorithm/VoronoiSubdivision$Site;", "makePolygons", "sites", "makeRandomPoints", "Lkotlin/Pair;", "", "size", "makeSites", "edges", "nextEdge", "next", "Site", "fxgl"})
public final class VoronoiSubdivision {
    private static final Logger log;
    private static Rectangle2D bbox;
    private static List<? extends Point2D> corners;
    private static final double EDGE_TOLERANCE = 2.0;
    private static final GraphEdge DUMMY_EDGE;
    public static final VoronoiSubdivision INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Array<Polygon> divide(@NotNull Rectangle2D rect, int numSamplePoints, double minDistance) {
        void pointsX;
        List<GraphEdge> edges;
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        bbox = rect;
        Object[] objectArray = new Point2D[4];
        Rectangle2D rectangle2D = bbox;
        if (rectangle2D == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        double d = rectangle2D.getMinX();
        Rectangle2D rectangle2D2 = bbox;
        if (rectangle2D2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        objectArray[0] = new Point2D(d, rectangle2D2.getMinY());
        Rectangle2D rectangle2D3 = bbox;
        if (rectangle2D3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        double d2 = rectangle2D3.getMaxX();
        Rectangle2D rectangle2D4 = bbox;
        if (rectangle2D4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        objectArray[1] = new Point2D(d2, rectangle2D4.getMinY());
        Rectangle2D rectangle2D5 = bbox;
        if (rectangle2D5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        double d3 = rectangle2D5.getMaxX();
        Rectangle2D rectangle2D6 = bbox;
        if (rectangle2D6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        objectArray[2] = new Point2D(d3, rectangle2D6.getMaxY());
        Rectangle2D rectangle2D7 = bbox;
        if (rectangle2D7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        double d4 = rectangle2D7.getMinX();
        Rectangle2D rectangle2D8 = bbox;
        if (rectangle2D8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
        }
        objectArray[3] = new Point2D(d4, rectangle2D8.getMaxY());
        corners = CollectionsKt.listOf((Object[])objectArray);
        Pair<double[], double[]> pair = INSTANCE.makeRandomPoints(rect, numSamplePoints);
        double[] dArray = (double[])pair.component1();
        double[] pointsY = (double[])pair.component2();
        List<GraphEdge> list = edges = new Voronoi(minDistance).generateVoronoi((double[])pointsX, pointsY, rect.getMinX(), rect.getMaxX(), rect.getMinY(), rect.getMaxY());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"edges");
        List<Site> sites = INSTANCE.makeSites(list);
        return new Array((Collection)INSTANCE.makePolygons(sites));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<double[], double[]> makeRandomPoints(Rectangle2D rect, int size) {
        double[] pointsX = new double[size];
        double[] pointsY = new double[size];
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            double randomX = FXGLMath.random((double)rect.getMinX(), (double)rect.getMaxX());
            double randomY = FXGLMath.random((double)rect.getMinY(), (double)rect.getMaxY());
            pointsX[i] = randomX;
            pointsY[i] = randomY;
            ++i;
        }
        return TuplesKt.to((Object)pointsX, (Object)pointsY);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Site> makeSites(List<? extends GraphEdge> edges) {
        void $receiver$iv$iv;
        ArrayList arrayList;
        HashMap siteMap = new HashMap();
        Object $receiver$iv = edges;
        Object object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            GraphEdge edge = (GraphEdge)element$iv;
            if (FXGLMath.isClose((double)edge.x1, (double)edge.x2, (double)EDGE_TOLERANCE) && FXGLMath.isClose((double)edge.y1, (double)edge.y2, (double)EDGE_TOLERANCE)) continue;
            Object object2 = edge.site1;
            HashMap hashMap = siteMap;
            arrayList = new ArrayList();
            ArrayList<GraphEdge> siteEdges1 = hashMap.getOrDefault(object2, arrayList);
            siteEdges1.add(edge);
            siteMap.put(edge.site1, siteEdges1);
            object2 = edge.site2;
            HashMap hashMap2 = siteMap;
            arrayList = new ArrayList();
            ArrayList<GraphEdge> siteEdges2 = hashMap2.getOrDefault(object2, arrayList);
            siteEdges2.add(edge);
            siteMap.put(edge.site2, siteEdges2);
        }
        object = $receiver$iv = (Map)siteMap;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var6_6 = $receiver$iv$iv;
        for (Map.Entry entry : var6_6.entrySet()) {
            void it;
            arrayList = entry;
            Collection collection = destination$iv$iv;
            Site site = new Site((List)it.getValue());
            collection.add(site);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Polygon> makePolygons(List<Site> sites) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)sites;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Site site = (Site)item$iv$iv;
            Collection collection = destination$iv$iv;
            Polygon polygon = INSTANCE.makePolygon((Site)it);
            collection.add(polygon);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Polygon makePolygon(Site site) {
        Collection collection;
        Polygon polygon = new Polygon();
        GraphEdge firstEdge = site.getEdges().get(0);
        polygon.getPoints().addAll((Object[])new Double[]{firstEdge.x1, firstEdge.y1, firstEdge.x2, firstEdge.y2});
        List leftEdges = CollectionsKt.minus((Iterable)site.getEdges(), (Object)firstEdge);
        Point2D nextVertex = new Point2D(firstEdge.x2, firstEdge.y2);
        while (!(collection = (Collection)leftEdges).isEmpty()) {
            void next;
            Pair<Point2D, GraphEdge> pair;
            if (this.nextEdge(nextVertex, leftEdges) == null) {
                return polygon;
            }
            collection = (Point2D)pair.component1();
            GraphEdge edge = (GraphEdge)pair.component2();
            polygon.getPoints().addAll((Object[])new Double[]{next.getX(), next.getY()});
            nextVertex = next;
            leftEdges = CollectionsKt.minus((Iterable)leftEdges, (Object)edge);
        }
        Double lastPointX = (Double)polygon.getPoints().get(polygon.getPoints().size() - 2);
        Double lastPointY = (Double)polygon.getPoints().get(polygon.getPoints().size() - 1);
        double d = firstEdge.x1;
        Double d2 = lastPointX;
        Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"lastPointX");
        if (!FXGLMath.isClose((double)d, (double)d2, (double)EDGE_TOLERANCE)) {
            double d3 = firstEdge.y1;
            Double d4 = lastPointY;
            Intrinsics.checkExpressionValueIsNotNull((Object)d4, (String)"lastPointY");
            if (!FXGLMath.isClose((double)d3, (double)d4, (double)EDGE_TOLERANCE)) {
                Iterable $receiver$iv;
                List<? extends Point2D> list = corners;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"corners");
                }
                Iterable iterable = $receiver$iv = (Iterable)list;
                Comparator comparator = new Comparator<T>(lastPointX, lastPointY){
                    final /* synthetic */ Double $lastPointX$inlined;
                    final /* synthetic */ Double $lastPointY$inlined;
                    {
                        this.$lastPointX$inlined = d;
                        this.$lastPointY$inlined = d2;
                    }

                    public final int compare(T a, T b) {
                        Point2D it = (Point2D)a;
                        Double d = this.$lastPointX$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"lastPointX");
                        double d2 = d;
                        Double d3 = this.$lastPointY$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"lastPointY");
                        Comparable comparable = Double.valueOf(it.distance(d2, d3.doubleValue()));
                        it = (Point2D)b;
                        Comparable comparable2 = comparable;
                        Double d4 = this.$lastPointX$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)d4, (String)"lastPointX");
                        double d5 = d4;
                        Double d6 = this.$lastPointY$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)d6, (String)"lastPointY");
                        Double d7 = it.distance(d5, d6.doubleValue());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d7);
                    }
                };
                Point2D closest = (Point2D)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
                polygon.getPoints().addAll((Object[])new Double[]{closest.getX(), closest.getY()});
            }
        }
        return polygon;
    }

    private final Pair<Point2D, GraphEdge> nextEdge(Point2D next, List<? extends GraphEdge> edges) {
        Iterable $receiver$iv;
        block22: {
            GraphEdge it;
            Iterable $receiver$iv2;
            block21: {
                block20: {
                    block19: {
                        $receiver$iv2 = edges;
                        for (Object element$iv : $receiver$iv2) {
                            it = (GraphEdge)element$iv;
                            if (FXGLMath.isClose((double)next.getX(), (double)it.x1, (double)EDGE_TOLERANCE) && FXGLMath.isClose((double)next.getY(), (double)it.y1, (double)EDGE_TOLERANCE)) {
                                return TuplesKt.to((Object)new Point2D(it.x2, it.y2), (Object)it);
                            }
                            if (!FXGLMath.isClose((double)next.getX(), (double)it.x2, (double)EDGE_TOLERANCE) || !FXGLMath.isClose((double)next.getY(), (double)it.y2, (double)EDGE_TOLERANCE)) continue;
                            return TuplesKt.to((Object)new Point2D(it.x1, it.y1), (Object)it);
                        }
                        int n = (int)next.getX();
                        Rectangle2D rectangle2D = bbox;
                        if (rectangle2D == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
                        }
                        if (n == (int)rectangle2D.getMinX()) break block19;
                        int n2 = (int)next.getX();
                        Rectangle2D rectangle2D2 = bbox;
                        if (rectangle2D2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
                        }
                        if (n2 != (int)rectangle2D2.getMaxX()) break block20;
                    }
                    $receiver$iv2 = edges;
                    for (Object element$iv : $receiver$iv2) {
                        it = (GraphEdge)element$iv;
                        if (FXGLMath.isClose((double)next.getX(), (double)it.x1, (double)EDGE_TOLERANCE)) {
                            return TuplesKt.to((Object)new Point2D(it.x1, it.y1), (Object)DUMMY_EDGE);
                        }
                        if (!FXGLMath.isClose((double)next.getX(), (double)it.x2, (double)EDGE_TOLERANCE)) continue;
                        return TuplesKt.to((Object)new Point2D(it.x2, it.y2), (Object)DUMMY_EDGE);
                    }
                }
                int n = (int)next.getY();
                Rectangle2D rectangle2D = bbox;
                if (rectangle2D == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
                }
                if (n == (int)rectangle2D.getMinY()) break block21;
                int n3 = (int)next.getY();
                Rectangle2D rectangle2D3 = bbox;
                if (rectangle2D3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"bbox");
                }
                if (n3 != (int)rectangle2D3.getMaxY()) break block22;
            }
            $receiver$iv2 = edges;
            for (Object element$iv : $receiver$iv2) {
                it = (GraphEdge)element$iv;
                if (FXGLMath.isClose((double)next.getY(), (double)it.y1, (double)EDGE_TOLERANCE)) {
                    return TuplesKt.to((Object)new Point2D(it.x1, it.y1), (Object)DUMMY_EDGE);
                }
                if (!FXGLMath.isClose((double)next.getY(), (double)it.y2, (double)EDGE_TOLERANCE)) continue;
                return TuplesKt.to((Object)new Point2D(it.x2, it.y2), (Object)DUMMY_EDGE);
            }
        }
        List<? extends Point2D> list = corners;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"corners");
        }
        if (list.contains(next)) {
            log.warning("Failed to find next edge. Left: " + edges);
            return null;
        }
        List<? extends Point2D> list2 = corners;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"corners");
        }
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Comparator comparator = new Comparator<T>(next){
            final /* synthetic */ Point2D $next$inlined;
            {
                this.$next$inlined = point2D;
            }

            public final int compare(T a, T b) {
                Point2D it = (Point2D)a;
                Comparable comparable = Double.valueOf(it.distance(this.$next$inlined));
                it = (Point2D)b;
                Comparable comparable2 = comparable;
                Double d = it.distance(this.$next$inlined);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        Point2D closest = (Point2D)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator));
        return TuplesKt.to((Object)closest, (Object)DUMMY_EDGE);
    }

    private VoronoiSubdivision() {
    }

    static {
        VoronoiSubdivision voronoiSubdivision;
        INSTANCE = voronoiSubdivision = new VoronoiSubdivision();
        log = Logger.Companion.get(voronoiSubdivision.getClass());
        EDGE_TOLERANCE = 2.0;
        DUMMY_EDGE = new GraphEdge();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/extra/algorithm/VoronoiSubdivision$Site;", "", "edges", "", "Lcom/almasb/fxgl/extra/algorithm/voronoi/GraphEdge;", "(Ljava/util/List;)V", "getEdges", "()Ljava/util/List;", "fxgl"})
    private static final class Site {
        @NotNull
        private final List<GraphEdge> edges;

        @NotNull
        public final List<GraphEdge> getEdges() {
            return this.edges;
        }

        public Site(@NotNull List<? extends GraphEdge> edges) {
            Intrinsics.checkParameterIsNotNull(edges, (String)"edges");
            this.edges = edges;
        }
    }
}

