/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.entity.components;

import com.almasb.fxgl.app.FXGL;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.PositionComponent;
import com.almasb.fxgl.time.LocalTimer;
import javafx.geometry.Rectangle2D;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020!H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/almasb/fxgl/extra/entity/components/RandomMoveComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "speed", "", "xSeed", "ySeed", "bounds", "Ljavafx/geometry/Rectangle2D;", "(DDDLjavafx/geometry/Rectangle2D;)V", "bbox", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "getBounds", "()Ljavafx/geometry/Rectangle2D;", "setBounds", "(Ljavafx/geometry/Rectangle2D;)V", "delay", "Ljavafx/util/Duration;", "kotlin.jvm.PlatformType", "nextPosition", "Lcom/almasb/fxgl/core/math/Vec2;", "position", "Lcom/almasb/fxgl/entity/components/PositionComponent;", "getSpeed", "()D", "setSpeed", "(D)V", "timer", "Lcom/almasb/fxgl/time/LocalTimer;", "getXSeed", "setXSeed", "getYSeed", "setYSeed", "onAdded", "", "onUpdate", "tpf", "updateNextPosition", "fxgl"})
public final class RandomMoveComponent
extends Component {
    private PositionComponent position;
    private BoundingBoxComponent bbox;
    private final Vec2 nextPosition;
    private final LocalTimer timer;
    private final Duration delay;
    private double speed;
    private double xSeed;
    private double ySeed;
    @NotNull
    private Rectangle2D bounds;

    public void onAdded() {
        PositionComponent positionComponent = this.position;
        if (positionComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        this.nextPosition.set(positionComponent.getValue());
        this.timer.capture();
    }

    public void onUpdate(double tpf) {
        this.xSeed += tpf;
        this.ySeed += tpf;
        PositionComponent positionComponent = this.position;
        if (positionComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        double d = positionComponent.getX();
        PositionComponent positionComponent2 = this.position;
        if (positionComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"position");
        }
        if (this.nextPosition.distanceLessThanOrEqual(d, positionComponent2.getY(), this.speed * tpf)) {
            this.updateNextPosition();
        } else {
            PositionComponent positionComponent3 = this.position;
            if (positionComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"position");
            }
            positionComponent3.translateTowards(this.nextPosition.toPoint2D(), this.speed * tpf);
        }
        Duration duration = this.delay;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"delay");
        if (this.timer.elapsed(duration)) {
            this.updateNextPosition();
            this.timer.capture();
        }
    }

    private final void updateNextPosition() {
        BoundingBoxComponent boundingBoxComponent = this.bbox;
        double maxX = this.bounds.getMaxX() - (boundingBoxComponent != null ? boundingBoxComponent.getWidth() : 0.0);
        BoundingBoxComponent boundingBoxComponent2 = this.bbox;
        double maxY = this.bounds.getMaxY() - (boundingBoxComponent2 != null ? boundingBoxComponent2.getHeight() : 0.0);
        float x = (float)FXGLMath.map((double)(FXGLMath.noise1D((double)this.xSeed) * 1.0), (double)0.0, (double)1.0, (double)this.bounds.getMinX(), (double)maxX);
        float y = (float)FXGLMath.map((double)(FXGLMath.noise1D((double)this.ySeed) * 1.0), (double)0.0, (double)1.0, (double)this.bounds.getMinY(), (double)maxY);
        this.nextPosition.set(x, y);
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public final double getXSeed() {
        return this.xSeed;
    }

    public final void setXSeed(double d) {
        this.xSeed = d;
    }

    public final double getYSeed() {
        return this.ySeed;
    }

    public final void setYSeed(double d) {
        this.ySeed = d;
    }

    @NotNull
    public final Rectangle2D getBounds() {
        return this.bounds;
    }

    public final void setBounds(@NotNull Rectangle2D rectangle2D) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle2D, (String)"<set-?>");
        this.bounds = rectangle2D;
    }

    @JvmOverloads
    public RandomMoveComponent(double speed, double xSeed, double ySeed, @NotNull Rectangle2D bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        this.speed = speed;
        this.xSeed = xSeed;
        this.ySeed = ySeed;
        this.bounds = bounds;
        this.nextPosition = new Vec2();
        this.timer = FXGL.Companion.newLocalTimer();
        this.delay = Duration.seconds((double)((double)1500 / this.speed));
    }

    @JvmOverloads
    public /* synthetic */ RandomMoveComponent(double d, double d2, double d3, Rectangle2D rectangle2D, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = FXGLMath.random((int)100, (int)10000);
        }
        if ((n & 4) != 0) {
            d3 = FXGLMath.random((int)10000, (int)100000);
        }
        if ((n & 8) != 0) {
            Rectangle2D rectangle2D2 = FXGL.Companion.getApp().getAppBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D2, (String)"FXGL.getApp().appBounds");
            rectangle2D = rectangle2D2;
        }
        this(d, d2, d3, rectangle2D);
    }

    @JvmOverloads
    public RandomMoveComponent(double speed, double xSeed, double ySeed) {
        this(speed, xSeed, ySeed, null, 8, null);
    }

    @JvmOverloads
    public RandomMoveComponent(double speed, double xSeed) {
        this(speed, xSeed, 0.0, null, 12, null);
    }

    @JvmOverloads
    public RandomMoveComponent(double speed) {
        this(speed, 0.0, 0.0, null, 14, null);
    }
}

