/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.entity.effects;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.view.EntityView;
import com.almasb.fxgl.extra.entity.effect.Effect;
import com.almasb.fxgl.texture.Texture;
import java.util.ArrayList;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0011j\b\u0012\u0004\u0012\u00020\u000f`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/almasb/fxgl/extra/entity/effects/WobbleEffect;", "Lcom/almasb/fxgl/extra/entity/effect/Effect;", "duration", "Ljavafx/util/Duration;", "radius", "", "numChunks", "orientation", "Ljavafx/geometry/Orientation;", "(Ljavafx/util/Duration;IILjavafx/geometry/Orientation;)V", "getNumChunks", "()I", "getOrientation", "()Ljavafx/geometry/Orientation;", "originalTexture", "Lcom/almasb/fxgl/texture/Texture;", "quads", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getRadius", "tick", "onEnd", "", "entity", "Lcom/almasb/fxgl/entity/Entity;", "onStart", "onUpdate", "tpf", "", "fxgl"})
public final class WobbleEffect
extends Effect {
    private final ArrayList<Texture> quads;
    private Texture originalTexture;
    private int tick;
    private final int radius;
    private final int numChunks;
    @NotNull
    private final Orientation orientation;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStart(@NotNull Entity entity) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.tick = 0;
        if (this.originalTexture == null) {
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.TRANSPARENT);
            WritableImage writableImage = entity.getView().snapshot(params, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)writableImage, (String)"entity.view.snapshot(params, null)");
            this.originalTexture = new Texture((Image)writableImage);
        }
        EntityView newView = new EntityView();
        if (this.orientation == Orientation.HORIZONTAL) {
            Texture texture = this.originalTexture;
            if (texture == null) {
                Intrinsics.throwNpe();
            }
            Image image = texture.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"originalTexture!!.image");
            d = image.getHeight() / (double)this.numChunks;
        } else {
            Texture texture = this.originalTexture;
            if (texture == null) {
                Intrinsics.throwNpe();
            }
            Image image = texture.getImage();
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"originalTexture!!.image");
            d = image.getWidth() / (double)this.numChunks;
        }
        double chunkSize = (int)d;
        int n = 0;
        int n2 = this.numChunks;
        while (n < n2) {
            Texture quad;
            void i;
            if (this.orientation == Orientation.HORIZONTAL) {
                Texture texture = this.originalTexture;
                if (texture == null) {
                    Intrinsics.throwNpe();
                }
                double d2 = (double)i * chunkSize;
                Texture texture2 = this.originalTexture;
                if (texture2 == null) {
                    Intrinsics.throwNpe();
                }
                Image image = texture2.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"originalTexture!!.image");
                quad = texture.subTexture(new Rectangle2D(0.0, d2, image.getWidth(), chunkSize));
                quad.setTranslateY((double)i * chunkSize);
                this.quads.add(quad);
                newView.addNode((Node)quad);
            } else {
                Texture texture = this.originalTexture;
                if (texture == null) {
                    Intrinsics.throwNpe();
                }
                double d3 = (double)i * chunkSize;
                Texture texture3 = this.originalTexture;
                if (texture3 == null) {
                    Intrinsics.throwNpe();
                }
                Image image = texture3.getImage();
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"originalTexture!!.image");
                quad = texture.subTexture(new Rectangle2D(d3, 0.0, chunkSize, image.getHeight()));
                quad.setTranslateX((double)i * chunkSize);
                this.quads.add(quad);
                newView.addNode((Node)quad);
            }
            ++i;
        }
        entity.setView((Node)newView);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(@NotNull Entity entity, double tpf) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        ++this.tick;
        Iterable $receiver$iv = this.quads;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void quad;
            int n = index$iv++;
            Texture texture = (Texture)item$iv;
            int index = n;
            if (this.orientation == Orientation.HORIZONTAL) {
                quad.setTranslateX(FXGLMath.sin((double)((double)this.tick + (double)index / 0.5)) * (double)this.radius);
                continue;
            }
            quad.setTranslateY(FXGLMath.sin((double)((double)this.tick + (double)index / 0.5)) * (double)this.radius);
        }
    }

    @Override
    public void onEnd(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        entity.setView((Node)this.originalTexture);
    }

    public final int getRadius() {
        return this.radius;
    }

    public final int getNumChunks() {
        return this.numChunks;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Duration duration, int radius, int numChunks, @NotNull Orientation orientation) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        Intrinsics.checkParameterIsNotNull((Object)orientation, (String)"orientation");
        super(duration);
        this.radius = radius;
        this.numChunks = numChunks;
        this.orientation = orientation;
        this.quads = new ArrayList();
    }

    @JvmOverloads
    public /* synthetic */ WobbleEffect(Duration duration, int n, int n2, Orientation orientation, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 2;
        }
        if ((n3 & 4) != 0) {
            n2 = 5;
        }
        if ((n3 & 8) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        this(duration, n, n2, orientation);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Duration duration, int radius, int numChunks) {
        this(duration, radius, numChunks, null, 8, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Duration duration, int radius) {
        this(duration, radius, 0, null, 12, null);
    }

    @JvmOverloads
    public WobbleEffect(@NotNull Duration duration) {
        this(duration, 0, 0, null, 14, null);
    }
}

