/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ui;

import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class ToggleSwitch
extends Parent {
    private boolean animating = false;
    private ReadOnlyBooleanWrapper switchedOn = new ReadOnlyBooleanWrapper(false);
    private TranslateTransition translateAnimation = new TranslateTransition(Duration.seconds((double)0.25));
    private FillTransition fillAnimation = new FillTransition(Duration.seconds((double)0.25));
    private ParallelTransition animation = new ParallelTransition(new Animation[]{this.translateAnimation, this.fillAnimation});
    private Color colorOn = Color.LIGHTGREEN;

    public ReadOnlyBooleanProperty switchedOnProperty() {
        return this.switchedOn.getReadOnlyProperty();
    }

    public boolean isSwitchedOn() {
        return this.switchedOnProperty().get();
    }

    public ToggleSwitch() {
        Rectangle background = new Rectangle(100.0, 50.0);
        background.setFill((Paint)Color.WHITE);
        background.setStroke((Paint)Color.LIGHTGRAY);
        background.setArcWidth(50.0);
        background.setArcHeight(50.0);
        Circle trigger = new Circle(25.0);
        trigger.setCenterX(25.0);
        trigger.setCenterY(25.0);
        trigger.setFill((Paint)Color.WHITE);
        trigger.setStroke((Paint)Color.LIGHTGRAY);
        this.translateAnimation.setNode((Node)trigger);
        this.fillAnimation.setShape((Shape)background);
        this.getChildren().addAll((Object[])new Node[]{background, trigger});
        this.switchedOnProperty().addListener((obs, oldState, isOn) -> {
            if (this.animating) {
                this.animation.stop();
            }
            this.animating = true;
            this.translateAnimation.setToX(isOn != false ? 50.0 : 0.0);
            this.fillAnimation.setFromValue(isOn != false ? Color.WHITE : this.colorOn);
            this.fillAnimation.setToValue(isOn != false ? this.colorOn : Color.WHITE);
            this.animation.setOnFinished(e -> {
                this.animating = false;
            });
            this.animation.play();
        });
        this.setOnMouseClicked(event -> {
            if (this.animating) {
                return;
            }
            this.switchedOn.set(!this.isSwitchedOn());
        });
    }

    public void setFill(Color colorOn) {
        this.colorOn = colorOn;
    }
}

