/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.extra.ui;

import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public final class Vignette
extends Parent {
    private Rectangle region;
    private double intensity = 1.0;
    private double radius;
    private Color color = Color.BLACK;

    public Vignette(int width, int height, double radius) {
        this.region = new Rectangle((double)width, (double)height);
        this.radius = radius;
        this.applyChanges();
        this.getChildren().add((Object)this.region);
    }

    private void applyChanges() {
        this.region.setFill((Paint)new RadialGradient(0.0, 0.0, this.region.getWidth() / 2.0, this.region.getHeight() / 2.0, this.radius, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.color((double)this.color.getRed(), (double)this.color.getGreen(), (double)this.color.getBlue(), (double)this.intensity))}));
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double intensity) {
        if (intensity < 0.0 || intensity > 1.0) {
            throw new IllegalArgumentException("Intensity must be in range [0..1]. Value: " + intensity);
        }
        this.intensity = intensity;
        this.applyChanges();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.applyChanges();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.applyChanges();
    }
}

