/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AssetLoader;
import com.almasb.fxgl.app.DialogSubState;
import com.almasb.fxgl.app.Engine;
import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.app.GameScene;
import com.almasb.fxgl.app.LoadingScene;
import com.almasb.fxgl.app.LoopRunner;
import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.PauseMenuSubState;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SceneFactory;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.FXGLExecutor;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.local.Language;
import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.event.EventBus;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.io.FS;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.saving.DataFile;
import com.almasb.fxgl.saving.LoadEvent;
import com.almasb.fxgl.saving.SaveEvent;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.saving.SaveLoadManager;
import com.almasb.fxgl.saving.UserProfile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.ProgressDialog;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.ui.Display;
import com.almasb.fxgl.ui.ErrorDialog;
import com.almasb.fxgl.ui.FXGLUIConfig;
import com.almasb.fxgl.ui.FontType;
import com.almasb.fxgl.ui.UIFactory;
import com.almasb.sslogger.Logger;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010R\u001a\u00020SH\u0002J\b\u0010T\u001a\u00020SH\u0002J\b\u0010U\u001a\u00020\u001dH\u0002J\b\u0010V\u001a\u00020SH\u0002J\u0010\u0010W\u001a\u00020S2\u0006\u0010X\u001a\u00020OH\u0002J\b\u0010Y\u001a\u00020SH\u0016J\b\u0010Z\u001a\u00020SH\u0016J\b\u0010[\u001a\u00020SH\u0002J\b\u0010\\\u001a\u00020SH\u0016J\b\u0010]\u001a\u00020SH\u0016J\b\u0010^\u001a\u00020SH\u0016J\b\u0010_\u001a\u00020SH\u0016J\u0010\u0010`\u001a\u00020S2\u0006\u0010a\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020SH\u0002J\b\u0010d\u001a\u00020SH\u0002J\b\u0010e\u001a\u00020SH\u0002J\u0010\u0010f\u001a\u0002022\u0006\u0010g\u001a\u00020\u001dH\u0016J\u0010\u0010h\u001a\u00020S2\u0006\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020SH\u0016J\b\u0010l\u001a\u00020SH\u0002J\b\u0010m\u001a\u00020SH\u0002J\b\u0010n\u001a\u00020OH\u0002J\b\u0010o\u001a\u00020SH\u0002J\u0010\u00109\u001a\u00020S2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010p\u001a\u00020SH\u0016J\b\u0010q\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020S2\u0006\u0010t\u001a\u00020uH\u0016J\b\u0010v\u001a\u00020SH\u0016J\b\u0010w\u001a\u00020SH\u0002J\u0010\u0010x\u001a\u00020S2\u0006\u0010y\u001a\u00020OH\u0016J\b\u0010z\u001a\u00020SH\u0016J\b\u0010{\u001a\u000202H\u0016J\b\u0010|\u001a\u00020SH\u0002J\u0010\u0010}\u001a\u00020S2\u0006\u0010~\u001a\u00020\u007fH\u0002J\u0007\u0010\u0080\u0001\u001a\u00020SJ\t\u0010\u0081\u0001\u001a\u00020SH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0010\u001a\u0004\b\"\u0010#R\u001b\u0010%\u001a\u00020&8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0010\u001a\u0004\b'\u0010(R\u001b\u0010*\u001a\u00020+8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0010\u001a\u0004\b,\u0010-R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010>\u001a\u00020?X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020K8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0014\u0010N\u001a\u00020OX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010Q\u00a8\u0006\u0082\u0001"}, d2={"Lcom/almasb/fxgl/app/Engine;", "Lcom/almasb/fxgl/app/GameController;", "app", "Lcom/almasb/fxgl/app/GameApplication;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "stage", "Ljavafx/stage/Stage;", "(Lcom/almasb/fxgl/app/GameApplication;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;Ljavafx/stage/Stage;)V", "getApp$fxgl", "()Lcom/almasb/fxgl/app/GameApplication;", "assetLoader", "Lcom/almasb/fxgl/app/AssetLoader;", "getAssetLoader$fxgl", "()Lcom/almasb/fxgl/app/AssetLoader;", "assetLoader$delegate", "Lkotlin/Lazy;", "audioPlayer", "Lcom/almasb/fxgl/audio/AudioPlayer;", "getAudioPlayer$fxgl", "()Lcom/almasb/fxgl/audio/AudioPlayer;", "audioPlayer$delegate", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "getBundle$fxgl", "()Lcom/almasb/fxgl/core/serialization/Bundle;", "setBundle$fxgl", "(Lcom/almasb/fxgl/core/serialization/Bundle;)V", "defaultProfile", "Lcom/almasb/fxgl/saving/UserProfile;", "dialogState", "Lcom/almasb/fxgl/app/DialogSubState;", "display", "Lcom/almasb/fxgl/ui/Display;", "getDisplay$fxgl", "()Lcom/almasb/fxgl/ui/Display;", "display$delegate", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "getEventBus$fxgl", "()Lcom/almasb/fxgl/event/EventBus;", "eventBus$delegate", "executor", "Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;", "getExecutor$fxgl", "()Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;", "executor$delegate", "gameMenu", "Lcom/almasb/fxgl/scene/FXGLScene;", "handledOnce", "", "intro", "isFirstRun", "loadState", "Lcom/almasb/fxgl/app/LoadingScene;", "log", "Lcom/almasb/sslogger/Logger;", "loop", "Lcom/almasb/fxgl/app/LoopRunner;", "mainMenu", "mainWindow", "Lcom/almasb/fxgl/app/MainWindow;", "playState", "Lcom/almasb/fxgl/app/GameScene;", "getPlayState$fxgl", "()Lcom/almasb/fxgl/app/GameScene;", "setPlayState$fxgl", "(Lcom/almasb/fxgl/app/GameScene;)V", "profileName", "Ljavafx/beans/property/SimpleStringProperty;", "saveLoadManager", "Lcom/almasb/fxgl/saving/SaveLoadManager;", "getSettings$fxgl", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "tpf", "", "getTpf", "()D", "version", "", "getVersion$fxgl", "()Ljava/lang/String;", "attachEventHandlers", "", "attachPauseResumeListener", "createProfile", "createRequiredDirs", "doSave", "saveFileName", "exit", "fixAspectRatio", "generateDefaultProfile", "gotoGameMenu", "gotoIntro", "gotoMainMenu", "gotoPlay", "handleFatalError", "error", "", "initAppScenes", "initFatalExceptionHandler", "loadDefaultSystemData", "loadFromProfile", "profile", "loadGame", "saveFile", "Lcom/almasb/fxgl/saving/SaveFile;", "loadGameFromLastSave", "loadLocalization", "loadSystemData", "loadVersion", "logVersion", "popSubScene", "profileNameProperty", "Ljavafx/beans/property/StringProperty;", "pushSubScene", "subScene", "Lcom/almasb/fxgl/scene/SubScene;", "restoreDefaultProfileSettings", "runPreInit", "saveGame", "fileName", "saveProfile", "saveScreenshot", "saveSystemData", "startLoadedGame", "dataFile", "Lcom/almasb/fxgl/saving/DataFile;", "startLoop", "startNewGame", "fxgl"})
public final class Engine
implements GameController {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Logger log;
    @NotNull
    private final String version;
    private boolean isFirstRun;
    @NotNull
    public Bundle bundle;
    private MainWindow mainWindow;
    @NotNull
    public GameScene playState;
    private LoadingScene loadState;
    private DialogSubState dialogState;
    private FXGLScene intro;
    private FXGLScene mainMenu;
    private FXGLScene gameMenu;
    private final LoopRunner loop;
    @NotNull
    private final Lazy assetLoader$delegate;
    @NotNull
    private final Lazy eventBus$delegate;
    @NotNull
    private final Lazy audioPlayer$delegate;
    @NotNull
    private final Lazy display$delegate;
    @NotNull
    private final Lazy executor$delegate;
    private final SimpleStringProperty profileName;
    private UserProfile defaultProfile;
    private SaveLoadManager saveLoadManager;
    private boolean handledOnce;
    @NotNull
    private final GameApplication app;
    @NotNull
    private final ReadOnlyGameSettings settings;
    private final Stage stage;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "assetLoader", "getAssetLoader$fxgl()Lcom/almasb/fxgl/app/AssetLoader;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "eventBus", "getEventBus$fxgl()Lcom/almasb/fxgl/event/EventBus;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "audioPlayer", "getAudioPlayer$fxgl()Lcom/almasb/fxgl/audio/AudioPlayer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "display", "getDisplay$fxgl()Lcom/almasb/fxgl/ui/Display;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Engine.class), "executor", "getExecutor$fxgl()Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;"))};
    }

    @NotNull
    public final String getVersion$fxgl() {
        return this.version;
    }

    @NotNull
    public final Bundle getBundle$fxgl() {
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return bundle;
    }

    public final void setBundle$fxgl(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"<set-?>");
        this.bundle = bundle;
    }

    @NotNull
    public final GameScene getPlayState$fxgl() {
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        return gameScene;
    }

    public final void setPlayState$fxgl(@NotNull GameScene gameScene) {
        Intrinsics.checkParameterIsNotNull((Object)gameScene, (String)"<set-?>");
        this.playState = gameScene;
    }

    public final double getTpf() {
        return this.loop.tpf();
    }

    @NotNull
    public final AssetLoader getAssetLoader$fxgl() {
        Lazy lazy = this.assetLoader$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (AssetLoader)lazy.getValue();
    }

    @NotNull
    public final EventBus getEventBus$fxgl() {
        Lazy lazy = this.eventBus$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (EventBus)lazy.getValue();
    }

    @NotNull
    public final AudioPlayer getAudioPlayer$fxgl() {
        Lazy lazy = this.audioPlayer$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (AudioPlayer)lazy.getValue();
    }

    @NotNull
    public final Display getDisplay$fxgl() {
        Lazy lazy = this.display$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[3];
        return (Display)lazy.getValue();
    }

    @NotNull
    public final FXGLExecutor getExecutor$fxgl() {
        Lazy lazy = this.executor$delegate;
        Engine engine = this;
        KProperty kProperty = $$delegatedProperties[4];
        return (FXGLExecutor)lazy.getValue();
    }

    private final String loadVersion() {
        String string = ResourceBundle.getBundle("com.almasb.fxgl.app.system").getString("fxgl.version");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ResourceBundle.getBundle\u2026getString(\"fxgl.version\")");
        return string;
    }

    private final void logVersion() {
        String platform = "DESKTOP" + (FXGL.Companion.isBrowser() ? " BROWSER" : "");
        this.log.info("FXGL-" + this.version + " on " + platform);
        this.log.info("Source code and latest versions at: https://github.com/AlmasB/FXGL");
        this.log.info("             Join the FXGL chat at: https://gitter.im/AlmasB/FXGL");
    }

    public final void startLoop() {
        this.saveLoadManager = new SaveLoadManager(this.profileName.getValue());
        long start = System.nanoTime();
        this.loadLocalization();
        this.log.debug("Registering font factories");
        this.settings.getUIFactory().registerFontFactory(FontType.UI, this.getAssetLoader$fxgl().loadFont(this.settings.getFontUI()));
        this.settings.getUIFactory().registerFontFactory(FontType.GAME, this.getAssetLoader$fxgl().loadFont(this.settings.getFontGame()));
        this.settings.getUIFactory().registerFontFactory(FontType.MONO, this.getAssetLoader$fxgl().loadFont(this.settings.getFontMono()));
        this.settings.getUIFactory().registerFontFactory(FontType.TEXT, this.getAssetLoader$fxgl().loadFont(this.settings.getFontText()));
        this.log.debug("Setting UI factory");
        FXGLUIConfig.setUIFactory((UIFactory)this.settings.getUIFactory());
        FXGLScene startupScene = this.settings.getSceneFactory().newStartup();
        MainWindow mainWindow = this.mainWindow = new MainWindow(this.stage, startupScene, this.settings);
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.show();
        this.initFatalExceptionHandler();
        Async.start((Runnable)new Runnable(this, start){
            final /* synthetic */ Engine this$0;
            final /* synthetic */ long $start;

            public final void run() {
                IOTask.setDefaultExecutor((Executor)((Executor)this.this$0.getExecutor$fxgl()));
                IOTask.setDefaultFailAction((Consumer)((Consumer)new Consumer<Throwable>(this){
                    final /* synthetic */ startLoop.1 this$0;

                    public final void accept(Throwable it) {
                        this.this$0.this$0.getDisplay$fxgl().showErrorBox(it);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                Engine.access$setFirstRun$p(this.this$0, !FS.Companion.exists("system/"));
                if (Engine.access$isFirstRun$p(this.this$0)) {
                    Engine.access$createRequiredDirs(this.this$0);
                    Engine.access$loadDefaultSystemData(this.this$0);
                } else {
                    Engine.access$loadSystemData(this.this$0);
                }
                Engine.access$initAppScenes(this.this$0);
                Engine.access$attachPauseResumeListener(this.this$0);
                Engine.access$attachEventHandlers(this.this$0);
                Async.startFX((Runnable)new Runnable(this){
                    final /* synthetic */ startLoop.1 this$0;

                    public final void run() {
                        Engine.access$runPreInit(this.this$0.this$0);
                        Engine.access$getLog$p(this.this$0.this$0).infof("FXGL initialization took: %.3f sec", new Object[]{(double)(System.nanoTime() - this.this$0.$start) / 1.0E9});
                        Engine.access$getLoop$p(this.this$0.this$0).start();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = engine;
                this.$start = l;
            }
        });
    }

    private final void loadLocalization() {
        Object v0;
        SimpleObjectProperty<Language> simpleObjectProperty;
        block2: {
            this.log.debug("Loading localizations");
            List builtInLangs = CollectionsKt.listOf((Object[])new String[]{"english", "french", "german", "russian", "hungarian"});
            Iterable $receiver$iv = builtInLangs;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Local.addLanguage((String)it, (ResourceBundle)FXGL.Companion.getAssetLoader().loadResourceBundle("languages/" + it + ".properties"));
            }
            Iterable iterable = Local.getLanguages();
            simpleObjectProperty = this.settings.getLanguage();
            Iterable iterable2 = iterable;
            Iterator iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Language it = (Language)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"english")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Object var9_10 = v0;
        simpleObjectProperty.setValue(var9_10);
        Local.selectedLanguageProperty().bind((ObservableValue)this.settings.getLanguage());
    }

    private final void attachPauseResumeListener() {
        if (!FXGL.Companion.isMobile()) {
            this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){
                final /* synthetic */ Engine this$0;

                public final void changed(ObservableValue<? extends Boolean> $noName_0, Boolean $noName_1, Boolean isMinimized) {
                    Boolean bl = isMinimized;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isMinimized");
                    if (bl.booleanValue()) {
                        Engine.access$getLoop$p(this.this$0).pause();
                    } else {
                        Engine.access$getLoop$p(this.this$0).resume();
                    }
                }
                {
                    this.this$0 = engine;
                }
            });
        }
    }

    private final void initAppScenes() {
        this.log.debug("Initializing application scenes");
        SceneFactory sceneFactory = this.settings.getSceneFactory();
        this.loadState = sceneFactory.newLoadingScene();
        this.playState = new GameScene(this.settings.getWidth(), this.settings.getHeight(), new GameState(), new GameWorld(), new PhysicsWorld(this.settings.getHeight(), this.settings.getPixelsPerMeter()));
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        this.dialogState = new DialogSubState((ReadOnlyObjectProperty<FXGLScene>)((ReadOnlyObjectProperty)mainWindow.getCurrentFXGLScene()));
        if (this.settings.isIntroEnabled()) {
            this.intro = sceneFactory.newIntro();
        }
        if (this.settings.isMenuEnabled()) {
            this.mainMenu = sceneFactory.newMainMenu();
            this.gameMenu = sceneFactory.newGameMenu();
        }
        if (this.settings.isMenuEnabled()) {
            EventHandler<KeyEvent> menuKeyHandler2 = new EventHandler<KeyEvent>(this){
                private boolean canSwitchGameMenu;
                final /* synthetic */ Engine this$0;

                private final void onMenuKey(boolean pressed) {
                    if (!pressed) {
                        this.canSwitchGameMenu = true;
                        return;
                    }
                    if (this.canSwitchGameMenu) {
                        if (Engine.access$getMainWindow$p(this.this$0).getCurrentState() == Engine.access$getGameMenu$p(this.this$0)) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoPlay();
                        } else if (Engine.access$getMainWindow$p(this.this$0).getCurrentState() == this.this$0.getPlayState$fxgl()) {
                            this.canSwitchGameMenu = false;
                            this.this$0.gotoGameMenu();
                        }
                    }
                }

                public void handle(@NotNull KeyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    if (event.getCode() == this.this$0.getSettings$fxgl().getMenuKey()) {
                        this.onMenuKey(Intrinsics.areEqual((Object)event.getEventType(), (Object)KeyEvent.KEY_PRESSED));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.canSwitchGameMenu = true;
                }
            };
            GameScene gameScene = this.playState;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
            }
            Input input = gameScene.getInput();
            EventType eventType = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType, (String)"KeyEvent.ANY");
            input.addEventHandler(eventType, (EventHandler)menuKeyHandler2);
            FXGLScene fXGLScene = this.gameMenu;
            if (fXGLScene == null) {
                Intrinsics.throwNpe();
            }
            Input input2 = fXGLScene.getInput();
            EventType eventType2 = KeyEvent.ANY;
            Intrinsics.checkExpressionValueIsNotNull((Object)eventType2, (String)"KeyEvent.ANY");
            input2.addEventHandler(eventType2, (EventHandler)menuKeyHandler2);
        } else {
            GameScene gameScene = this.playState;
            if (gameScene == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
            }
            Input.addAction$default((Input)gameScene.getInput(), (UserAction)new UserAction(this, "Pause"){
                final /* synthetic */ Engine this$0;

                protected void onActionBegin() {
                    PauseMenuSubState.INSTANCE.requestShow$fxgl((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ initAppScenes.1 this$0;

                        public final void invoke() {
                            Engine.access$getMainWindow$p(this.this$0.this$0).pushState(PauseMenuSubState.INSTANCE);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }

                protected void onActionEnd() {
                    PauseMenuSubState.INSTANCE.unlockSwitch$fxgl();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            }, (KeyCode)this.settings.getMenuKey(), null, (int)4, null);
        }
        this.log.debug("Application scenes initialized");
    }

    private final void createRequiredDirs() {
        FS.Companion.createDirectoryTask("system/").then((Function)createRequiredDirs.1.INSTANCE).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable e) {
                Engine.access$getLog$p(this.this$0).warning("Failed to create system dir: " + e);
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void saveSystemData() {
        this.log.debug("Saving FXGL system data");
        Bundle bundle = this.bundle;
        if (bundle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        FS.Companion.writeDataTask((Serializable)bundle, "system/fxgl.bundle").onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to save: " + it);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadSystemData() {
        this.log.debug("Loading FXGL system data");
        FS.Companion.readDataTask("system/fxgl.bundle").onSuccess((Consumer)new Consumer<Bundle>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Bundle it) {
                Bundle bundle = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"it");
                this.this$0.setBundle$fxgl(bundle);
                this.this$0.getBundle$fxgl().log();
            }
            {
                this.this$0 = engine;
            }
        }).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable it) {
                Engine.access$getLog$p(this.this$0).warning("Failed to load: " + it);
                Engine.access$loadDefaultSystemData(this.this$0);
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    private final void loadDefaultSystemData() {
        this.log.debug("Loading default FXGL system data");
        this.bundle = new Bundle("FXGL");
    }

    private final void initFatalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ Engine this$0;

            public final void uncaughtException(Thread $noName_0, Throwable error) {
                Throwable throwable = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                Engine.access$handleFatalError(this.this$0, throwable);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void attachEventHandlers() {
        EventBus eventBus2 = FXGL.Companion.getEventBus();
        EventType<SaveEvent> eventType = SaveEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType, (String)"SaveEvent.ANY");
        eventBus2.addEventHandler(eventType, (EventHandler)new EventHandler<SaveEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(SaveEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                UserProfile userProfile = e.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.getProfile()");
                readOnlyGameSettings.save(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
        EventBus eventBus3 = FXGL.Companion.getEventBus();
        EventType<LoadEvent> eventType2 = LoadEvent.ANY;
        Intrinsics.checkExpressionValueIsNotNull(eventType2, (String)"LoadEvent.ANY");
        eventBus3.addEventHandler(eventType2, (EventHandler)new EventHandler<LoadEvent>(this){
            final /* synthetic */ Engine this$0;

            public final void handle(LoadEvent e) {
                ReadOnlyGameSettings readOnlyGameSettings = this.this$0.getSettings$fxgl();
                UserProfile userProfile = e.getProfile();
                Intrinsics.checkExpressionValueIsNotNull((Object)userProfile, (String)"e.getProfile()");
                readOnlyGameSettings.load(userProfile);
            }
            {
                this.this$0 = engine;
            }
        });
    }

    private final void runPreInit() {
        this.log.debug("Running preInit()");
        this.app.initInput();
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        SystemActions.INSTANCE.bind(gameScene.getInput());
        this.generateDefaultProfile();
    }

    private final void generateDefaultProfile() {
        this.log.debug("generateDefaultProfile()");
        this.defaultProfile = this.createProfile();
    }

    private final void loop(double tpf) {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.onUpdate$fxgl(tpf);
        this.getAudioPlayer$fxgl().onUpdate(tpf);
    }

    private final void handleFatalError(Throwable error) {
        if (this.handledOnce) {
            return;
        }
        this.handledOnce = true;
        if (Logger.Companion.isConfigured()) {
            this.log.fatal("Uncaught Exception:", error);
            this.log.fatal("Application will now exit");
        } else {
            String string = "Uncaught Exception:";
            System.out.println((Object)string);
            error.printStackTrace();
            string = "Application will now exit";
            System.out.println((Object)string);
        }
        this.loop.stop();
        new ErrorDialog(error).showAndWait();
        if (this.loop.isStarted()) {
            this.exit();
        } else {
            if (Logger.Companion.isConfigured()) {
                Logger.Companion.close();
            }
            System.exit(-1);
        }
    }

    @Override
    public void startNewGame() {
        this.log.debug("Starting new game");
        LoadingScene loadingScene = this.loadState;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        loadingScene.setDataFile$fxgl(DataFile.Companion.getEMPTY());
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadState;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        mainWindow.setScene(loadingScene2);
    }

    private final void startLoadedGame(DataFile dataFile) {
        this.log.debug("Starting loaded game");
        LoadingScene loadingScene = this.loadState;
        if (loadingScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        loadingScene.setDataFile$fxgl(dataFile);
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        LoadingScene loadingScene2 = this.loadState;
        if (loadingScene2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadState");
        }
        mainWindow.setScene(loadingScene2);
    }

    @Override
    public void gotoIntro() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.intro;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoMainMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.mainMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoGameMenu() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        FXGLScene fXGLScene = this.gameMenu;
        if (fXGLScene == null) {
            Intrinsics.throwNpe();
        }
        mainWindow.setScene(fXGLScene);
    }

    @Override
    public void gotoPlay() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        GameScene gameScene = this.playState;
        if (gameScene == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"playState");
        }
        mainWindow.setScene(gameScene);
    }

    @Override
    public void saveGame(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.doSave(fileName);
    }

    private final void doSave(String saveFileName) {
        DataFile dataFile = this.app.saveState();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
        SaveFile saveFile = new SaveFile(saveFileName, localDateTime);
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.saveTask(dataFile, saveFile).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.savingData") + ": " + saveFileName));
    }

    @Override
    public void loadGame(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull((Object)saveFile, (String)"saveFile");
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.loadTask(saveFile).onSuccess((Consumer)new Consumer<DataFile>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(DataFile it) {
                DataFile dataFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFile, (String)"it");
                Engine.access$startLoadedGame(this.this$0, dataFile);
            }
            {
                this.this$0 = engine;
            }
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.loading") + ": " + saveFile.getName()));
    }

    @Override
    public void loadGameFromLastSave() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.loadLastModifiedSaveFileTask().then(new Function<T, IOTask<R>>(this){
            final /* synthetic */ Engine this$0;

            public final IOTask<DataFile> apply(SaveFile it) {
                return Engine.access$getSaveLoadManager$p(this.this$0).loadTask(it);
            }
            {
                this.this$0 = engine;
            }
        }).onSuccess((Consumer)new Consumer<DataFile>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(DataFile it) {
                DataFile dataFile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFile, (String)"it");
                Engine.access$startLoadedGame(this.this$0, dataFile);
            }
            {
                this.this$0 = engine;
            }
        }).runAsyncFXWithDialog((IOTask.UIDialogHandler)new ProgressDialog(Local.getLocalizedString((String)"menu.loading") + "..."));
    }

    @Override
    public boolean saveScreenshot() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow.saveScreenshot();
    }

    @Override
    public void fixAspectRatio() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.fixAspectRatio();
    }

    @Override
    public void saveProfile() {
        SaveLoadManager saveLoadManager = this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        saveLoadManager.saveProfileTask(this.createProfile()).onFailure((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ Engine this$0;

            public final void accept(Throwable error) {
                String cfr_ignored_0 = "Failed to save profile: " + Engine.access$getProfileName$p(this.this$0).getValue() + " - " + error;
            }
            {
                this.this$0 = engine;
            }
        }).run();
    }

    @Override
    public boolean loadFromProfile(@NotNull UserProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        if (!profile.isCompatible(FXGL.Companion.getSettings().getTitle(), FXGL.Companion.getSettings().getVersion())) {
            return false;
        }
        FXGL.Companion.getEventBus().fireEvent((Event)new LoadEvent(LoadEvent.LOAD_PROFILE, profile));
        return true;
    }

    @Override
    @NotNull
    public StringProperty profileNameProperty() {
        return (StringProperty)this.profileName;
    }

    @Override
    public void restoreDefaultProfileSettings() {
        this.log.debug("restoreDefaultSettings()");
        EventBus eventBus2 = FXGL.Companion.getEventBus();
        UserProfile userProfile = this.defaultProfile;
        if (userProfile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultProfile");
        }
        eventBus2.fireEvent((Event)new LoadEvent(LoadEvent.RESTORE_SETTINGS, userProfile));
    }

    private final UserProfile createProfile() {
        this.log.debug("Creating default profile");
        UserProfile profile = new UserProfile(FXGL.Companion.getSettings().getTitle(), FXGL.Companion.getSettings().getVersion());
        FXGL.Companion.getEventBus().fireEvent((Event)new SaveEvent(profile));
        return profile;
    }

    @Override
    public void pushSubScene(@NotNull SubScene subScene) {
        Intrinsics.checkParameterIsNotNull((Object)subScene, (String)"subScene");
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.pushState(subScene);
    }

    @Override
    public void popSubScene() {
        MainWindow mainWindow = this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        mainWindow.popState();
    }

    @Override
    public void exit() {
        this.log.debug("Exiting FXGL");
        this.settings.isMenuEnabled();
        this.log.debug("Shutting down background threads");
        this.getExecutor$fxgl().shutdownNow();
        this.saveSystemData();
        this.log.debug("Closing logger and exiting JavaFX");
        Logger.Companion.close();
        Platform.exit();
    }

    @NotNull
    public final GameApplication getApp$fxgl() {
        return this.app;
    }

    @NotNull
    public final ReadOnlyGameSettings getSettings$fxgl() {
        return this.settings;
    }

    public Engine(@NotNull GameApplication app, @NotNull ReadOnlyGameSettings settings, @NotNull Stage stage) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        this.app = app;
        this.settings = settings;
        this.stage = stage;
        this.log = Logger.Companion.get(this.getClass());
        this.loop = new LoopRunner((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ Engine this$0;

            public final void invoke(double it) {
                Engine.access$loop(this.this$0, it);
            }
            {
                this.this$0 = engine;
                super(1);
            }
        }));
        this.assetLoader$delegate = LazyKt.lazy((Function0)assetLoader.2.INSTANCE);
        this.eventBus$delegate = LazyKt.lazy((Function0)eventBus.2.INSTANCE);
        this.audioPlayer$delegate = LazyKt.lazy((Function0)audioPlayer.2.INSTANCE);
        this.display$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Display>(this){
            final /* synthetic */ Engine this$0;

            @NotNull
            public final Display invoke() {
                DialogSubState dialogSubState = Engine.access$getDialogState$p(this.this$0);
                if (dialogSubState == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.ui.Display");
                }
                return dialogSubState;
            }
            {
                this.this$0 = engine;
                super(0);
            }
        }));
        this.executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);
        this.profileName = new SimpleStringProperty("no-profile");
        this.log.debug("Initializing FXGL");
        this.version = this.loadVersion();
        this.logVersion();
    }

    public static final /* synthetic */ boolean access$isFirstRun$p(Engine $this) {
        return $this.isFirstRun;
    }

    public static final /* synthetic */ void access$setFirstRun$p(Engine $this, boolean bl) {
        $this.isFirstRun = bl;
    }

    public static final /* synthetic */ void access$createRequiredDirs(Engine $this) {
        $this.createRequiredDirs();
    }

    public static final /* synthetic */ void access$loadDefaultSystemData(Engine $this) {
        $this.loadDefaultSystemData();
    }

    public static final /* synthetic */ void access$loadSystemData(Engine $this) {
        $this.loadSystemData();
    }

    public static final /* synthetic */ void access$initAppScenes(Engine $this) {
        $this.initAppScenes();
    }

    public static final /* synthetic */ void access$attachPauseResumeListener(Engine $this) {
        $this.attachPauseResumeListener();
    }

    public static final /* synthetic */ void access$attachEventHandlers(Engine $this) {
        $this.attachEventHandlers();
    }

    public static final /* synthetic */ void access$runPreInit(Engine $this) {
        $this.runPreInit();
    }

    public static final /* synthetic */ Logger access$getLog$p(Engine $this) {
        return $this.log;
    }

    public static final /* synthetic */ LoopRunner access$getLoop$p(Engine $this) {
        return $this.loop;
    }

    public static final /* synthetic */ MainWindow access$getMainWindow$p(Engine $this) {
        MainWindow mainWindow = $this.mainWindow;
        if (mainWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainWindow");
        }
        return mainWindow;
    }

    public static final /* synthetic */ void access$setMainWindow$p(Engine $this, MainWindow mainWindow) {
        $this.mainWindow = mainWindow;
    }

    public static final /* synthetic */ FXGLScene access$getGameMenu$p(Engine $this) {
        return $this.gameMenu;
    }

    public static final /* synthetic */ void access$setGameMenu$p(Engine $this, FXGLScene fXGLScene) {
        $this.gameMenu = fXGLScene;
    }

    public static final /* synthetic */ void access$handleFatalError(Engine $this, Throwable error) {
        $this.handleFatalError(error);
    }

    public static final /* synthetic */ void access$startLoadedGame(Engine $this, DataFile dataFile) {
        $this.startLoadedGame(dataFile);
    }

    public static final /* synthetic */ SaveLoadManager access$getSaveLoadManager$p(Engine $this) {
        SaveLoadManager saveLoadManager = $this.saveLoadManager;
        if (saveLoadManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLoadManager");
        }
        return saveLoadManager;
    }

    public static final /* synthetic */ void access$setSaveLoadManager$p(Engine $this, SaveLoadManager saveLoadManager) {
        $this.saveLoadManager = saveLoadManager;
    }

    public static final /* synthetic */ SimpleStringProperty access$getProfileName$p(Engine $this) {
        return $this.profileName;
    }

    public static final /* synthetic */ void access$loop(Engine $this, double tpf) {
        $this.loop(tpf);
    }

    public static final /* synthetic */ DialogSubState access$getDialogState$p(Engine $this) {
        DialogSubState dialogSubState = $this.dialogState;
        if (dialogSubState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialogState");
        }
        return dialogSubState;
    }

    public static final /* synthetic */ void access$setDialogState$p(Engine $this, DialogSubState dialogSubState) {
        $this.dialogState = dialogSubState;
    }
}

