/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.ui.UI;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001AB/\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001aJ\u001f\u0010$\u001a\u00020\u001f2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0&\"\u00020\u001a\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020\u001fJ\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u000fH\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000201H\u0014J\u000e\u00108\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001aJ\u001f\u0010<\u001a\u00020\u001f2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0&\"\u00020\u001a\u00a2\u0006\u0002\u0010'J\u000e\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020:J\b\u0010?\u001a\u00020\u001fH\u0002J\u000e\u0010@\u001a\u00020\u001f2\u0006\u00107\u001a\u000201R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/almasb/fxgl/app/GameScene;", "Lcom/almasb/fxgl/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameState", "Lcom/almasb/fxgl/gameplay/GameState;", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "(IILcom/almasb/fxgl/gameplay/GameState;Lcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;)V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "gameRoot", "Ljavafx/scene/Group;", "getGameState", "()Lcom/almasb/fxgl/gameplay/GameState;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUiNodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "addUI", "", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clear", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "", "h", "onEntityAdded", "entity", "onEntityRemoved", "onUpdate", "tpf", "removeUI", "removeUINode", "", "n", "removeUINodes", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "fxgl"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    private final Group gameRoot;
    private final Group uiRoot;
    private final ArrayList<Entity> entities;
    @NotNull
    private final GameState gameState;
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ObservableList<Node> getUiNodes() {
        ObservableList observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"uiRoot.childrenUnmodifiable");
        return observableList;
    }

    private final void initViewport(double w, double h) {
        Viewport viewport = this.getViewport();
        this.gameRoot.layoutXProperty().bind((ObservableValue)viewport.xProperty().negate());
        this.gameRoot.layoutYProperty().bind((ObservableValue)viewport.yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)viewport.xProperty());
        scale.pivotYProperty().bind((ObservableValue)viewport.yProperty());
        scale.xProperty().bind((ObservableValue)viewport.zoomProperty());
        scale.yProperty().bind((ObservableValue)viewport.zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind((ObservableValue)viewport.xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind((ObservableValue)viewport.yProperty().add(h / (double)2));
        rotate.angleProperty().bind((ObservableValue)viewport.angleProperty().negate());
        this.gameRoot.getTransforms().add((Object)rotate);
    }

    @Override
    protected void onUpdate(double tpf) {
        if (FXGL.Companion.getSettings().isSingleStep()) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        FXGL.Companion.getApp().onUpdate(tpf);
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.uiRoot.getChildren().add((Object)node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        this.addUINode((Node)ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        this.removeUINode((Node)ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    /*
     * WARNING - void declaration
     */
    private final void sortZ() {
        Collection<Group> collection;
        void $receiver$iv$iv;
        List list;
        ArrayList tmpE = new ArrayList(this.entities);
        Iterable $receiver$iv = tmpE;
        if ($receiver$iv.size() > 1) {
            list = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Entity it = (Entity)a;
                    boolean bl = false;
                    Entity entity = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"it");
                    it = (Entity)b;
                    Comparable comparable = Integer.valueOf(entity.getZ());
                    bl = false;
                    Entity entity2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"it");
                    Integer n = entity2.getZ();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator);
        }
        $receiver$iv = tmpE;
        ObservableList observableList = this.gameRoot.getChildren();
        list = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void e;
            Entity entity = (Entity)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = e;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"e");
            Group group = v0.getViewComponent().getParent();
            collection.add(group);
        }
        collection = (List)destination$iv$iv;
        observableList.setAll((Collection)collection);
    }

    public final void clear() {
        log.debug("Clearing game scene");
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
    }

    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewComponent, (String)"entity.viewComponent");
        this.initView(viewComponent);
        this.sortZ();
    }

    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewComponent, (String)"entity.viewComponent");
        this.destroyView(viewComponent);
    }

    private final void initView(ViewComponent viewComponent) {
        Collection collection = (Collection)this.gameRoot.getChildren();
        Group group = viewComponent.getParent();
        collection.add(group);
    }

    private final void destroyView(ViewComponent viewComponent) {
        Collection collection = (Collection)this.gameRoot.getChildren();
        Group group = viewComponent.getParent();
        collection.remove(group);
    }

    @NotNull
    public final GameState getGameState() {
        return this.gameState;
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public GameScene(int width, int height, @NotNull GameState gameState, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkParameterIsNotNull((Object)gameState, (String)"gameState");
        Intrinsics.checkParameterIsNotNull((Object)gameWorld, (String)"gameWorld");
        Intrinsics.checkParameterIsNotNull((Object)physicsWorld, (String)"physicsWorld");
        super(width, height);
        this.gameState = gameState;
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{(Node)this.gameRoot, (Node)this.uiRoot});
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add((Object)this.getViewport().getCamera().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + "x" + height);
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get(GameScene.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

