/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.scene.Viewport;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010>\u001a\u00020\u0007J\u001e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\u000e\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020+J\b\u0010F\u001a\u00020@H\u0002J\u000e\u0010G\u001a\u00020@2\u0006\u0010E\u001a\u00020+J\u000e\u0010H\u001a\u00020@2\u0006\u0010A\u001a\u00020\rJ\u0013\u0010I\u001a\n J*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\u0002\u0010KJ\u0006\u0010L\u001a\u00020\u0003J\u0006\u0010M\u001a\u00020\u0003J\u0006\u0010N\u001a\u00020\u0003J\u000e\u0010O\u001a\u00020@2\u0006\u0010P\u001a\u00020\u0003J\u000e\u0010Q\u001a\u00020@2\u0006\u0010R\u001a\u00020\u0003J&\u0010S\u001a\u00020@2\u0006\u0010&\u001a\u00020T2\u0006\u0010'\u001a\u00020T2\u0006\u0010#\u001a\u00020T2\u0006\u0010%\u001a\u00020TJ\u000e\u0010U\u001a\u00020@2\u0006\u0010;\u001a\u00020\u0003J\u000e\u0010V\u001a\u00020@2\u0006\u0010<\u001a\u00020\u0003J\u000e\u0010W\u001a\u00020@2\u0006\u0010R\u001a\u00020\u0003J\u0016\u0010X\u001a\u00020@2\u0006\u0010Y\u001a\u00020\u00032\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010[\u001a\u00020@2\u0006\u0010\\\u001a\u00020\u0003J\u000e\u0010]\u001a\u00020@2\u0006\u0010\\\u001a\u00020\u0003J\u0006\u0010^\u001a\u00020@J\u0006\u0010_\u001a\u00020\u0007J\u0006\u0010`\u001a\u00020\u0007J\u0006\u0010a\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001bR\u000e\u0010;\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/almasb/fxgl/scene/Viewport;", "", "width", "", "height", "(DD)V", "angle", "Ljavafx/beans/property/SimpleDoubleProperty;", "angleBeforeShake", "boundX", "Ljavafx/beans/binding/NumberBinding;", "boundY", "camera", "Lcom/almasb/fxgl/entity/Entity;", "getCamera", "()Lcom/almasb/fxgl/entity/Entity;", "entityToFollow", "flashAnimatedValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "flashRect", "Ljavafx/scene/shape/Rectangle;", "getFlashRect", "()Ljavafx/scene/shape/Rectangle;", "flashRect$delegate", "Lkotlin/Lazy;", "flashTime", "getHeight", "()D", "isFading", "", "isFlashing", "isLazy", "()Z", "setLazy", "(Z)V", "maxX", "Ljavafx/beans/property/SimpleIntegerProperty;", "maxY", "minX", "minY", "offset", "Lcom/almasb/fxgl/core/math/Vec2;", "onFadeFlashFinish", "Ljava/lang/Runnable;", "origin", "Ljavafx/geometry/Point2D;", "getOrigin", "()Ljavafx/geometry/Point2D;", "originBeforeShake", "shakeAngle", "shakePowerRotate", "shakePowerTranslate", "shakingRotate", "shakingTranslate", "visibleArea", "Ljavafx/geometry/Rectangle2D;", "getVisibleArea", "()Ljavafx/geometry/Rectangle2D;", "getWidth", "x", "y", "zoom", "angleProperty", "bindToEntity", "", "entity", "distX", "distY", "fade", "onFinished", "fadeFlash", "flash", "focusOn", "getAngle", "kotlin.jvm.PlatformType", "()Ljava/lang/Double;", "getX", "getY", "getZoom", "onUpdate", "tpf", "setAngle", "value", "setBounds", "", "setX", "setY", "setZoom", "shake", "powerTranslate", "powerRotate", "shakeRotational", "power", "shakeTranslational", "unbind", "xProperty", "yProperty", "zoomProperty", "fxgl"})
public final class Viewport {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SimpleDoubleProperty x;
    private final SimpleDoubleProperty y;
    private final SimpleDoubleProperty zoom;
    private final SimpleDoubleProperty angle;
    private Entity entityToFollow;
    private NumberBinding boundX;
    private NumberBinding boundY;
    private final SimpleIntegerProperty minX;
    private final SimpleIntegerProperty minY;
    private final SimpleIntegerProperty maxX;
    private final SimpleIntegerProperty maxY;
    private boolean isLazy;
    @NotNull
    private final Entity camera;
    private double shakePowerTranslate;
    private double shakePowerRotate;
    private double shakeAngle;
    private final Vec2 originBeforeShake;
    private double angleBeforeShake;
    private final Vec2 offset;
    private boolean shakingTranslate;
    private boolean shakingRotate;
    private final Lazy flashRect$delegate;
    private final AnimatedValue<Double> flashAnimatedValue;
    private double flashTime;
    private boolean isFlashing;
    private boolean isFading;
    private Runnable onFadeFlashFinish;
    private final double width;
    private final double height;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Viewport.class), "flashRect", "getFlashRect()Ljavafx/scene/shape/Rectangle;"))};
    }

    @NotNull
    public final Rectangle2D getVisibleArea() {
        return new Rectangle2D(this.getX(), this.getY(), this.width, this.height);
    }

    public final double getX() {
        return this.x.get();
    }

    @NotNull
    public final SimpleDoubleProperty xProperty() {
        return this.x;
    }

    public final void setX(double x) {
        this.xProperty().set(x);
    }

    public final double getY() {
        return this.y.get();
    }

    @NotNull
    public final SimpleDoubleProperty yProperty() {
        return this.y;
    }

    public final void setY(double y) {
        this.yProperty().set(y);
    }

    public final double getZoom() {
        return this.zoom.get();
    }

    @NotNull
    public final SimpleDoubleProperty zoomProperty() {
        return this.zoom;
    }

    public final void setZoom(double value) {
        this.zoomProperty().set(value);
    }

    @NotNull
    public final Point2D getOrigin() {
        return new Point2D(this.getX(), this.getY());
    }

    public final Double getAngle() {
        return this.angle.getValue();
    }

    @NotNull
    public final SimpleDoubleProperty angleProperty() {
        return this.angle;
    }

    public final void setAngle(double value) {
        this.angleProperty().set(value);
    }

    public final boolean isLazy() {
        return this.isLazy;
    }

    public final void setLazy(boolean bl) {
        this.isLazy = bl;
    }

    @NotNull
    public final Entity getCamera() {
        return this.camera;
    }

    public final void bindToEntity(@NotNull Entity entity, double distX, double distY) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        TransformComponent position = entity.getTransformComponent();
        DoubleBinding bx = position.xProperty().add(-distX);
        DoubleBinding by = position.yProperty().add(-distY);
        this.boundX = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)bx.lessThan((ObservableNumberValue)this.minX))).then((ObservableNumberValue)this.minX).otherwise((ObservableNumberValue)position.xProperty().add(-distX));
        this.boundY = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)by.lessThan((ObservableNumberValue)this.minY))).then((ObservableNumberValue)this.minY).otherwise((ObservableNumberValue)position.yProperty().add(-distY));
        this.boundX = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)bx.greaterThan((ObservableNumberValue)this.maxX.subtract(this.width)))).then((ObservableNumberValue)this.maxX.subtract(this.width)).otherwise((ObservableNumberValue)this.boundX);
        this.boundY = Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)by.greaterThan((ObservableNumberValue)this.maxY.subtract(this.height)))).then((ObservableNumberValue)this.maxY.subtract(this.height)).otherwise((ObservableNumberValue)this.boundY);
    }

    public final void unbind() {
        this.xProperty().unbind();
        this.yProperty().unbind();
        this.zoomProperty().unbind();
    }

    public final void setBounds(int minX, int minY, int maxX, int maxY) {
        this.minX.set(minX);
        this.minY.set(minY);
        this.maxX.set(maxX);
        this.maxY.set(maxY);
    }

    public final void focusOn(@NotNull Entity entity) {
        Point2D newOrigin;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Point2D point2D = newOrigin = entity.getCenter().subtract((double)FXGL.Companion.getAppWidth() / 2.0, (double)FXGL.Companion.getAppHeight() / 2.0);
        Intrinsics.checkExpressionValueIsNotNull((Object)point2D, (String)"newOrigin");
        this.setX(point2D.getX());
        this.setY(newOrigin.getY());
    }

    public final void shake(double powerTranslate, double powerRotate) {
        this.shakeTranslational(powerTranslate);
        this.shakeRotational(powerRotate);
    }

    public final void shakeTranslational(double power) {
        this.shakePowerTranslate = power;
        this.shakeAngle = FXGLMath.random() * (Math.PI * 2);
        if (!this.shakingTranslate) {
            this.originBeforeShake.set(this.x.floatValue(), this.y.floatValue());
        }
        this.shakingTranslate = true;
    }

    public final void shakeRotational(double power) {
        this.shakePowerRotate = power;
        if (!this.shakingRotate) {
            Double d = this.angle.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"angle.value");
            this.angleBeforeShake = d;
        }
        this.shakingRotate = true;
    }

    private final Rectangle getFlashRect() {
        Lazy lazy = this.flashRect$delegate;
        Viewport viewport = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Rectangle)lazy.getValue();
    }

    public final void flash(@NotNull Runnable onFinished) {
        Intrinsics.checkParameterIsNotNull((Object)onFinished, (String)"onFinished");
        if (this.isFlashing || this.isFading) {
            return;
        }
        this.onFadeFlashFinish = onFinished;
        this.getFlashRect().setOpacity(1.0);
        this.isFlashing = true;
        this.fadeFlash();
    }

    public final void fade(@NotNull Runnable onFinished) {
        Intrinsics.checkParameterIsNotNull((Object)onFinished, (String)"onFinished");
        if (this.isFlashing || this.isFading) {
            return;
        }
        this.onFadeFlashFinish = onFinished;
        this.getFlashRect().setOpacity(0.0);
        this.isFading = true;
        this.fadeFlash();
    }

    private final void fadeFlash() {
        this.camera.getViewComponent().setViewFromNode((Node)this.getFlashRect());
        this.flashTime = 0.0;
    }

    public final void onUpdate(double tpf) {
        if (this.isFlashing || this.isFading) {
            this.flashTime += tpf;
            if (this.flashTime > 1.0) {
                this.flashTime = 1.0;
                this.isFlashing = false;
                this.isFading = false;
                this.camera.getViewComponent().getParent().getChildren().clear();
                this.onFadeFlashFinish.run();
            }
            double ratio = this.flashTime / 1.0;
            double progress = this.isFading ? 1.0 - ratio : ratio;
            double opacity = ((Number)this.flashAnimatedValue.getValue(progress)).doubleValue();
            this.getFlashRect().setOpacity(opacity);
        }
        NumberBinding numberBinding = this.boundX;
        if (numberBinding != null) {
            NumberBinding ratio;
            NumberBinding it = ratio = numberBinding;
            boolean bl = false;
            if (!this.isLazy) {
                NumberBinding numberBinding2 = this.boundX;
                if (numberBinding2 == null) {
                    Intrinsics.throwNpe();
                }
                this.setX(numberBinding2.doubleValue());
                NumberBinding numberBinding3 = this.boundY;
                if (numberBinding3 == null) {
                    Intrinsics.throwNpe();
                }
                this.setY(numberBinding3.doubleValue());
            } else {
                double sourceX = this.getX();
                double sourceY = this.getY();
                NumberBinding numberBinding4 = this.boundX;
                if (numberBinding4 == null) {
                    Intrinsics.throwNpe();
                }
                this.setX(sourceX * 0.9 + numberBinding4.doubleValue() * 0.1);
                NumberBinding numberBinding5 = this.boundY;
                if (numberBinding5 == null) {
                    Intrinsics.throwNpe();
                }
                this.setY(sourceY * 0.9 + numberBinding5.doubleValue() * 0.1);
            }
        }
        if (!this.shakingRotate && !this.shakingTranslate) {
            return;
        }
        if (this.shakingTranslate) {
            this.shakePowerTranslate *= 0.9;
            this.shakeAngle += (double)180 + FXGLMath.random() * (Math.PI * 2) / (double)6;
            this.offset.set((float)(this.shakePowerTranslate * FXGLMath.cos((double)this.shakeAngle)), (float)(this.shakePowerTranslate * FXGLMath.sin((double)this.shakeAngle)));
            if (this.boundX != null) {
                if (!this.isLazy) {
                    double d = this.offset.x;
                    NumberBinding numberBinding6 = this.boundX;
                    if (numberBinding6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.setX(d + numberBinding6.doubleValue());
                    double d2 = this.offset.y;
                    NumberBinding numberBinding7 = this.boundY;
                    if (numberBinding7 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.setY(d2 + numberBinding7.doubleValue());
                } else {
                    double sourceX = (double)this.offset.x + this.getX();
                    double sourceY = (double)this.offset.y + this.getY();
                    NumberBinding numberBinding8 = this.boundX;
                    if (numberBinding8 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.setX(sourceX * 0.9 + numberBinding8.doubleValue() * 0.1);
                    NumberBinding numberBinding9 = this.boundY;
                    if (numberBinding9 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.setY(sourceY * 0.9 + numberBinding9.doubleValue() * 0.1);
                }
            } else {
                this.setX((double)this.offset.x + (double)this.originBeforeShake.x);
                this.setY((double)this.offset.y + (double)this.originBeforeShake.y);
            }
            if ((double)FXGLMath.abs((float)this.offset.x) < 0.5 && (double)FXGLMath.abs((float)this.offset.y) < 0.5) {
                this.shakingTranslate = false;
            }
        }
        if (this.shakingRotate) {
            double maxAngle = 10.0;
            this.shakePowerRotate *= 0.9;
            this.setAngle(maxAngle * this.shakePowerRotate * FXGLMath.random((double)-1.0, (double)1.0));
            if (FXGLMath.abs((double)(this.angle.getValue() - this.angleBeforeShake)) < 0.5) {
                this.setAngle(0.0);
                this.shakingRotate = false;
            }
        }
        this.camera.setX(this.getX());
        this.camera.setY(this.getY());
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Viewport(double width, double height) {
        this.width = width;
        this.height = height;
        this.x = new SimpleDoubleProperty();
        this.y = new SimpleDoubleProperty();
        this.zoom = new SimpleDoubleProperty(1.0);
        this.angle = new SimpleDoubleProperty();
        this.minX = new SimpleIntegerProperty(Integer.MIN_VALUE);
        this.minY = new SimpleIntegerProperty(Integer.MIN_VALUE);
        this.maxX = new SimpleIntegerProperty(Integer.MAX_VALUE);
        this.maxY = new SimpleIntegerProperty(Integer.MAX_VALUE);
        this.camera = new Entity();
        this.bindToEntity(this.camera, 0.0, 0.0);
        this.originBeforeShake = new Vec2();
        this.offset = new Vec2();
        this.flashRect$delegate = LazyKt.lazy((Function0)flashRect.2.INSTANCE);
        this.flashAnimatedValue = new AnimatedValue((Object)1.0, (Object)0.0, null, 4, null);
        this.onFadeFlashFinish = (Runnable)EmptyRunnable.INSTANCE;
    }
}

