/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.audio.impl.DesktopAudioService;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.texture.Texture;
import com.almasb.fxgl.ui.FontFactory;
import com.almasb.fxgl.ui.UI;
import com.almasb.fxgl.ui.UIController;
import com.almasb.sslogger.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u0004J\u001b\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010)J\u001c\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u00102\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u0004J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\u0006\u0010\u001e\u001a\u00020\u0004J\u0016\u00105\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010;\u001a\u00020<2\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u0004J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u0004042\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u0004J\u0016\u0010@\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010B\u001a\u00020CJ\u001e\u0010@\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020EJ\u0016\u0010G\u001a\u00020H2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010I\u001a\u00020JJ\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0004042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/almasb/fxgl/app/AssetLoader;", "", "()V", "AI_DIR", "", "ASSETS_DIR", "BINARY_DIR", "CSS_DIR", "CURSORS_DIR", "FONTS_DIR", "JSON_DIR", "KV_DIR", "LEVELS_DIR", "MUSIC_DIR", "PROPERTIES_DIR", "SCRIPTS_DIR", "SOUNDS_DIR", "TEXTURES_DIR", "TEXT_DIR", "TMX_DIR", "UI_DIR", "audioService", "Lcom/almasb/fxgl/audio/impl/DesktopAudioService;", "cachedAssets", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "log", "Lcom/almasb/sslogger/Logger;", "clearCache", "", "getAssetFromCache", "name", "getStream", "Ljava/io/InputStream;", "getURL", "Ljava/net/URL;", "loadCSS", "Lcom/almasb/fxgl/scene/CSS;", "loadCursorImage", "Ljavafx/scene/image/Image;", "loadDataInternal", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "loadFailed", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "assetName", "error", "", "loadFont", "Lcom/almasb/fxgl/ui/FontFactory;", "loadImage", "loadJSON", "", "loadLevel", "Lcom/almasb/fxgl/entity/level/Level;", "levelLoader", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "loadMusic", "Lcom/almasb/fxgl/audio/Music;", "loadResourceBundle", "Ljava/util/ResourceBundle;", "loadSound", "Lcom/almasb/fxgl/audio/Sound;", "loadText", "loadTexture", "Lcom/almasb/fxgl/texture/Texture;", "transparency", "Ljavafx/scene/paint/Color;", "width", "", "height", "loadUI", "Lcom/almasb/fxgl/ui/UI;", "controller", "Lcom/almasb/fxgl/ui/UIController;", "readAllLines", "fxgl"})
public final class AssetLoader {
    private final String ASSETS_DIR = "/assets/";
    private final String TEXTURES_DIR = this.ASSETS_DIR + "textures/";
    private final String SOUNDS_DIR = this.ASSETS_DIR + "sounds/";
    private final String MUSIC_DIR = this.ASSETS_DIR + "music/";
    private final String TEXT_DIR = this.ASSETS_DIR + "text/";
    private final String KV_DIR = this.ASSETS_DIR + "kv/";
    private final String JSON_DIR = this.ASSETS_DIR + "json/";
    private final String TMX_DIR = this.ASSETS_DIR + "tmx/";
    private final String BINARY_DIR = this.ASSETS_DIR + "data/";
    private final String SCRIPTS_DIR = this.ASSETS_DIR + "scripts/";
    private final String PROPERTIES_DIR = this.ASSETS_DIR + "properties/";
    private final String AI_DIR = this.ASSETS_DIR + "ai/";
    private final String LEVELS_DIR = this.ASSETS_DIR + "levels/";
    private final String UI_DIR = this.ASSETS_DIR + "ui/";
    private final String CSS_DIR = this.UI_DIR + "css/";
    private final String FONTS_DIR = this.UI_DIR + "fonts/";
    private final String CURSORS_DIR = this.UI_DIR + "cursors/";
    private final Logger log = Logger.Companion.get(this.getClass());
    private final DesktopAudioService audioService = new DesktopAudioService();
    private final ObjectMap<String, Object> cachedAssets = new ObjectMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return (Image)t;
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Image image = new Image(it);
                this.cachedAssets.put((Object)(this.TEXTURES_DIR + name), (Object)image);
                Image image2 = image;
                return image2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXTURES_DIR + name);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Texture texture = new Texture(new Image(it));
                this.cachedAssets.put((Object)(this.TEXTURES_DIR + name), (Object)texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, double width, double height) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String cacheKey = this.TEXTURES_DIR + name + "@" + width + "x" + height;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Texture texture = new Texture(new Image(it, width, height, false, true));
                this.cachedAssets.put((Object)cacheKey, (Object)texture.getImage());
                Texture texture2 = texture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Texture loadTexture(@NotNull String name, @NotNull Color transparency) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)transparency, (String)"transparency");
        String cacheKey = this.TEXTURES_DIR + name + "T" + transparency;
        Object asset = this.getAssetFromCache(cacheKey);
        if (asset != null) {
            Object t = Image.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Image::class.java.cast(asset)");
            return new Texture((Image)t);
        }
        try {
            Closeable closeable = this.getStream(this.TEXTURES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Texture texture = new Texture(new Image(it));
                Texture newTexture = texture.transparentColor(transparency);
                texture.dispose();
                this.cachedAssets.put((Object)cacheKey, (Object)newTexture.getImage());
                Texture texture2 = newTexture;
                return texture2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final Sound loadSound(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.SOUNDS_DIR + name);
        if (asset != null) {
            Object t = Sound.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Sound::class.java.cast(asset)");
            return (Sound)t;
        }
        try {
            Sound sound = new Sound(this.audioService.loadAudio(AudioType.SOUND, this.getURL(this.SOUNDS_DIR + name)));
            this.cachedAssets.put((Object)(this.SOUNDS_DIR + name), (Object)sound);
            return sound;
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final Music loadMusic(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.MUSIC_DIR + name);
        if (asset != null) {
            Object t = Music.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"Music::class.java.cast(asset)");
            return (Music)t;
        }
        try {
            Music music = new Music(this.audioService.loadAudio(AudioType.MUSIC, this.getURL(this.MUSIC_DIR + name)));
            this.cachedAssets.put((Object)(this.MUSIC_DIR + name), (Object)music);
            return music;
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final List<String> loadText(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.TEXT_DIR + name);
        if (asset != null) {
            return (List)asset;
        }
        List<String> text = this.readAllLines(this.TEXT_DIR + name);
        this.cachedAssets.put((Object)(this.TEXT_DIR + name), text);
        return text;
    }

    @NotNull
    public final List<String> loadJSON(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.readAllLines(this.JSON_DIR + name);
    }

    @NotNull
    public final Level loadLevel(@NotNull String name, @NotNull LevelLoader levelLoader) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)levelLoader, (String)"levelLoader");
        return levelLoader.load(this.getURL(this.LEVELS_DIR + name), FXGL.Companion.getGameWorld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ResourceBundle loadResourceBundle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.PROPERTIES_DIR + name);
        if (asset != null) {
            return (ResourceBundle)asset;
        }
        try {
            Closeable closeable = this.getStream(this.PROPERTIES_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset2);
                Reader reader = inputStreamReader;
                PropertyResourceBundle bundle = new PropertyResourceBundle(reader);
                this.cachedAssets.put((Object)(this.PROPERTIES_DIR + name), (Object)bundle);
                ResourceBundle resourceBundle = bundle;
                return resourceBundle;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Image loadCursorImage(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            Closeable closeable = this.getStream(this.CURSORS_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Image image = new Image(it);
                return image;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final UI loadUI(@NotNull String name, @NotNull UIController controller) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        try {
            Closeable closeable = this.getStream(this.UI_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                FXMLLoader loader = new FXMLLoader();
                loader.setController((Object)controller);
                Parent root = (Parent)loader.load(it);
                controller.init();
                Parent parent = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)parent, (String)"root");
                UI uI = new UI(parent, controller);
                return uI;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    @NotNull
    public final CSS loadCSS(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            String string = this.getURL(this.CSS_DIR + name).toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getURL(CSS_DIR + name).toExternalForm()");
            return new CSS(string);
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FontFactory loadFont(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object asset = this.getAssetFromCache(this.FONTS_DIR + name);
        if (asset != null) {
            Object t = FontFactory.class.cast(asset);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"FontFactory::class.java.cast(asset)");
            return (FontFactory)t;
        }
        try {
            Closeable closeable = this.getStream(this.FONTS_DIR + name);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Font font = Font.loadFont((InputStream)it, (double)12.0);
                if (font == null) {
                    font = Font.font((double)12.0);
                }
                Font font2 = font;
                if (font2 == null) {
                    Intrinsics.throwNpe();
                }
                FontFactory fontFactory = new FontFactory(font2);
                this.cachedAssets.put((Object)(this.FONTS_DIR + name), (Object)fontFactory);
                FontFactory fontFactory2 = fontFactory;
                return fontFactory2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T loadDataInternal(String name) {
        try {
            Closeable closeable = new ObjectInputStream(this.getStream(this.BINARY_DIR + name));
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                boolean bl = false;
                Object object = it.readObject();
                return (T)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    private final URL getURL(String name) {
        this.log.debug("Loading from disk: " + name);
        Object object = GameApplication.FXGLApplication.app;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getResource(name)) == null) {
            String string = name;
            int n = 1;
            StringBuilder stringBuilder = new StringBuilder().append("/fxgl");
            Class<?> clazz = this.getClass();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            object = clazz.getResource(stringBuilder.append(string4).toString());
        }
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("Asset \"" + name + "\" was not found!");
        }
        return object;
    }

    @NotNull
    public final InputStream getStream(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        try {
            InputStream inputStream = this.getURL(name).openStream();
            if (inputStream == null) {
                throw (Throwable)new IOException("Input stream to \"" + name + "\" is null!");
            }
            return inputStream;
        }
        catch (IOException e) {
            throw (Throwable)new IllegalArgumentException("Failed to obtain input stream to URL: " + e);
        }
    }

    private final Object getAssetFromCache(String name) {
        Object asset = this.cachedAssets.get((Object)name);
        if (asset != null) {
            this.log.debug("Loading from cache: " + name);
            return asset;
        }
        return null;
    }

    private final List<String> readAllLines(String name) {
        try {
            InputStream inputStream = this.getStream(name);
            Charset charset = Charsets.UTF_8;
            Closeable closeable = inputStream;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            int n = 8192;
            return TextStreamsKt.readLines((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        }
        catch (Exception e) {
            throw (Throwable)this.loadFailed(name, e);
        }
    }

    public final void clearCache() {
        this.log.debug("Clearing assets cache");
        this.cachedAssets.clear();
    }

    private final IllegalArgumentException loadFailed(String assetName, Throwable error) {
        this.log.fatal("Loading failed for asset: " + assetName + ". Cause: " + error.getMessage());
        return new IllegalArgumentException("Failed to load asset: " + assetName + ". Cause: " + error.getMessage());
    }
}

