/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.scene;

import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.Viewport;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$J\u0006\u0010(\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020\u001fJ\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/J\u000e\u0010-\u001a\u00020\u001f2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u000205R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014\u00a8\u00066"}, d2={"Lcom/almasb/fxgl/scene/FXGLScene;", "Lcom/almasb/fxgl/scene/Scene;", "width", "", "height", "(II)V", "active", "Ljavafx/beans/property/SimpleBooleanProperty;", "contentRoot", "Ljavafx/scene/layout/Pane;", "getContentRoot", "()Ljavafx/scene/layout/Pane;", "effect", "Ljavafx/scene/effect/Effect;", "getEffect", "()Ljavafx/scene/effect/Effect;", "setEffect", "(Ljavafx/scene/effect/Effect;)V", "", "getHeight", "()D", "root", "getRoot", "viewport", "Lcom/almasb/fxgl/scene/Viewport;", "getViewport", "()Lcom/almasb/fxgl/scene/Viewport;", "getWidth", "activeProperty", "Ljavafx/beans/property/BooleanProperty;", "appendCSS", "", "css", "Lcom/almasb/fxgl/scene/CSS;", "bindSize", "scaledWidth", "Ljavafx/beans/property/DoubleProperty;", "scaledHeight", "scaleRatioX", "scaleRatioY", "clearCSS", "clearEffect", "setBackgroundColor", "color", "Ljavafx/scene/paint/Paint;", "setBackgroundRepeat", "image", "Ljavafx/scene/image/Image;", "textureName", "", "setCursor", "imageName", "hotspot", "Ljavafx/geometry/Point2D;", "fxgl"})
public abstract class FXGLScene
extends Scene {
    @NotNull
    private final Pane root;
    @NotNull
    private final Pane contentRoot;
    @NotNull
    private final Viewport viewport;
    private final SimpleBooleanProperty active;

    @NotNull
    public final Pane getRoot() {
        return this.root;
    }

    @NotNull
    public final Pane getContentRoot() {
        return this.contentRoot;
    }

    @NotNull
    public final Viewport getViewport() {
        return this.viewport;
    }

    public final double getWidth() {
        return this.root.getPrefWidth();
    }

    public final double getHeight() {
        return this.root.getPrefHeight();
    }

    @Nullable
    public final Effect getEffect() {
        return this.contentRoot.getEffect();
    }

    public final void setEffect(@Nullable Effect effect) {
        this.contentRoot.setEffect(effect);
    }

    public final void clearEffect() {
        this.setEffect(null);
    }

    public final void setCursor(@NotNull String imageName, @NotNull Point2D hotspot) {
        Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
        Intrinsics.checkParameterIsNotNull((Object)hotspot, (String)"hotspot");
        this.root.setCursor((Cursor)new ImageCursor(FXGL.Companion.getAssetLoader().loadCursorImage(imageName), hotspot.getX(), hotspot.getY()));
    }

    @NotNull
    public final BooleanProperty activeProperty() {
        return (BooleanProperty)this.active;
    }

    public final void appendCSS(@NotNull CSS css) {
        Intrinsics.checkParameterIsNotNull((Object)css, (String)"css");
        this.root.getStylesheets().add((Object)css.getExternalForm());
    }

    public final void clearCSS() {
        this.root.getStylesheets().clear();
    }

    public final void bindSize(@NotNull DoubleProperty scaledWidth, @NotNull DoubleProperty scaledHeight, @NotNull DoubleProperty scaleRatioX, @NotNull DoubleProperty scaleRatioY) {
        Intrinsics.checkParameterIsNotNull((Object)scaledWidth, (String)"scaledWidth");
        Intrinsics.checkParameterIsNotNull((Object)scaledHeight, (String)"scaledHeight");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioX, (String)"scaleRatioX");
        Intrinsics.checkParameterIsNotNull((Object)scaleRatioY, (String)"scaleRatioY");
        this.root.prefWidthProperty().bind((ObservableValue)scaledWidth);
        this.root.prefHeightProperty().bind((ObservableValue)scaledHeight);
        Scale scale = new Scale();
        scale.xProperty().bind((ObservableValue)scaleRatioX);
        scale.yProperty().bind((ObservableValue)scaleRatioY);
        this.root.getTransforms().setAll((Object[])new Transform[]{(Transform)scale});
    }

    public final void setBackgroundColor(@NotNull Paint color) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        this.root.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(color, null, null)}));
    }

    public final void setBackgroundRepeat(@NotNull String textureName) {
        Intrinsics.checkParameterIsNotNull((Object)textureName, (String)"textureName");
        Image image = FXGL.Companion.texture(textureName).getImage();
        Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"FXGL.texture(textureName).image");
        this.setBackgroundRepeat(image);
    }

    public final void setBackgroundRepeat(@NotNull Image image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        this.root.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, null, null)}));
    }

    @JvmOverloads
    public FXGLScene(int width, int height) {
        this.root = new Pane();
        this.active = new SimpleBooleanProperty(false);
        this.root.setBackground((Background)null);
        this.contentRoot = new Pane();
        this.contentRoot.setBackground((Background)null);
        this.root.getChildren().addAll((Object[])new Node[]{(Node)this.contentRoot});
        this.viewport = new Viewport(width, height);
        if (FXGL.Companion.isDesktop()) {
            this.setCursor("fxgl_default.png", new Point2D(7.0, 6.0));
        }
    }

    @JvmOverloads
    public /* synthetic */ FXGLScene(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = FXGL.Companion.getAppWidth();
        }
        if ((n3 & 2) != 0) {
            n2 = FXGL.Companion.getAppHeight();
        }
        this(n, n2);
    }

    @JvmOverloads
    public FXGLScene(int width) {
        this(width, 0, 2, null);
    }

    @JvmOverloads
    public FXGLScene() {
        this(0, 0, 3, null);
    }
}

