/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0013\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001dJ\u001f\u0010-\u001a\u00020%2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0/\"\u00020\u001d\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020%J\u0006\u00102\u001a\u00020%J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020%2\u0006\u00104\u001a\u000205H\u0002J\u0018\u00107\u001a\u00020%2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0002J\u0010\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020\rH\u0016J\u0010\u0010=\u001a\u00020%2\u0006\u0010<\u001a\u00020\rH\u0016J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u000209H\u0014J\u000e\u0010@\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010A\u001a\u00020%2\u0006\u0010)\u001a\u00020*J\u000e\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u001dJ\u001f\u0010D\u001a\u00020%2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0/\"\u00020\u001d\u00a2\u0006\u0002\u00100J\r\u0010E\u001a\u00020%H\u0000\u00a2\u0006\u0002\bFJ\u000e\u0010G\u001a\u00020%2\u0006\u0010H\u001a\u00020\u0014J\b\u0010I\u001a\u00020%H\u0002J\u000e\u0010J\u001a\u00020%2\u0006\u0010?\u001a\u000209R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene;", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "(IILcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;)V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "gameRoot", "Ljavafx/scene/Group;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "isSingleStep", "", "()Z", "setSingleStep", "(Z)V", "isZSortingNeeded", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUiNodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "zChangeListener", "Ljavafx/beans/value/ChangeListener;", "", "addGameView", "", "view", "Lcom/almasb/fxgl/app/scene/GameView;", "addUI", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "", "h", "onEntityAdded", "entity", "onEntityRemoved", "onUpdate", "tpf", "removeGameView", "removeUI", "removeUINode", "n", "removeUINodes", "reset", "reset$fxgl", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "fxgl"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    private final Group gameRoot;
    private final Group uiRoot;
    private final ArrayList<Entity> entities;
    private boolean isZSortingNeeded;
    private final ChangeListener<Number> zChangeListener;
    private boolean isSingleStep;
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ObservableList<Node> getUiNodes() {
        ObservableList observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableList, (String)"uiRoot.childrenUnmodifiable");
        return observableList;
    }

    public final boolean isSingleStep() {
        return this.isSingleStep;
    }

    public final void setSingleStep(boolean bl) {
        this.isSingleStep = bl;
    }

    private final void initViewport(double w, double h) {
        this.gameRoot.translateXProperty().bind((ObservableValue)this.getViewport().xProperty().negate());
        this.gameRoot.translateYProperty().bind((ObservableValue)this.getViewport().yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty());
        scale.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty());
        scale.xProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        scale.yProperty().bind((ObservableValue)this.getViewport().zoomProperty());
        this.gameRoot.getTransforms().add((Object)scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind((ObservableValue)this.getViewport().xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind((ObservableValue)this.getViewport().yProperty().add(h / (double)2));
        rotate.angleProperty().bind((ObservableValue)this.getViewport().angleProperty().negate());
        this.gameRoot.getTransforms().add((Object)rotate);
    }

    protected void onUpdate(double tpf) {
        if (this.isSingleStep) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        if (this.isZSortingNeeded) {
            this.sortZ();
            this.isZSortingNeeded = false;
        }
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.uiRoot.getChildren().add((Object)node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
        return this.uiRoot.getChildren().remove((Object)n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull((Object)nodes, (String)"nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        this.addUINode((Node)ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        this.removeUINode((Node)ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    private final void sortZ() {
        ArrayList tmp = new ArrayList((Collection)this.gameRoot.getChildren());
        List $this$sortBy$iv = tmp;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List list = $this$sortBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Node it = (Node)a;
                    boolean bl2 = false;
                    Node node = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"it");
                    Object object = node.getProperties().get((Object)"viewData");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    it = (Node)b;
                    Comparable comparable = Integer.valueOf(((GameView)object).getZ());
                    bl2 = false;
                    Node node2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"it");
                    Object object2 = node2.getProperties().get((Object)"viewData");
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    }
                    Integer n = ((GameView)object2).getZ();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator);
        }
        this.gameRoot.getChildren().setAll((Collection)tmp);
    }

    public final void reset$fxgl() {
        log.debug("Clearing game scene");
        this.gameWorld.reset();
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
        this.physicsWorld.clear();
        this.physicsWorld.clearCollisionHandlers();
        this.getTimer().clear();
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewComponent, (String)"entity.viewComponent");
        this.initView(viewComponent);
    }

    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewComponent, (String)"entity.viewComponent");
        this.destroyView(viewComponent);
    }

    public final void addGameView(@NotNull GameView view2) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        view2.getZProperty().addListener(this.zChangeListener);
        ObservableMap observableMap = view2.getNode().getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)observableMap, (String)"view.node.properties");
        ((Map)observableMap).put("viewData", view2);
        this.gameRoot.getChildren().add((Object)view2.getNode());
        this.isZSortingNeeded = true;
    }

    public final void removeGameView(@NotNull GameView view2) {
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view");
        view2.getNode().getProperties().clear();
        this.gameRoot.getChildren().remove((Object)view2.getNode());
    }

    private final void initView(ViewComponent viewComponent) {
        Node node = (Node)viewComponent.getParent();
        Integer n = viewComponent.getZ().getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"viewComponent.z.value");
        GameView view2 = new GameView(node, n);
        view2.getZProperty().bind((ObservableValue)viewComponent.getZ());
        this.addGameView(view2);
    }

    private final void destroyView(ViewComponent viewComponent) {
        block1: {
            Object object = viewComponent.getParent().getProperties().get((Object)"viewData");
            if (object == null) break block1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            Object object3 = it;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
            }
            GameView view2 = (GameView)object3;
            view2.getZProperty().unbind();
            view2.getZProperty().removeListener(this.zChangeListener);
            this.removeGameView(view2);
        }
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkParameterIsNotNull((Object)gameWorld, (String)"gameWorld");
        Intrinsics.checkParameterIsNotNull((Object)physicsWorld, (String)"physicsWorld");
        super(width, height);
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.zChangeListener = (ChangeListener)new ChangeListener<Number>(this){
            final /* synthetic */ GameScene this$0;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number $noName_2) {
                GameScene.access$setZSortingNeeded$p(this.this$0, true);
            }
            {
                this.this$0 = gameScene;
            }
        };
        this.getContentRoot().getChildren().addAll((Object[])new Node[]{(Node)this.gameRoot, (Node)this.uiRoot});
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add((Object)this.getViewport().getCamera$fxgl().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + "x" + height);
        this.gameWorld.addWorldListener((EntityWorldListener)this.physicsWorld);
        this.gameWorld.addWorldListener((EntityWorldListener)this);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get(GameScene.class);
    }

    public static final /* synthetic */ boolean access$isZSortingNeeded$p(GameScene $this) {
        return $this.isZSortingNeeded;
    }

    public static final /* synthetic */ void access$setZSortingNeeded$p(GameScene $this, boolean bl) {
        $this.isZSortingNeeded = bl;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

